/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input object for the model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInput implements SdkPojo, Serializable, ToCopyableBuilder<ModelInput.Builder, ModelInput> {
    private static final SdkField<String> DATA_INPUT_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataInputConfig").getter(getter(ModelInput::dataInputConfig)).setter(setter(Builder::dataInputConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_INPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataInputConfig;

    private ModelInput(BuilderImpl builder) {
        this.dataInputConfig = builder.dataInputConfig;
    }

    /**
     * <p>
     * The input configuration object for the model.
     * </p>
     * 
     * @return The input configuration object for the model.
     */
    public final String dataInputConfig() {
        return dataInputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInput)) {
            return false;
        }
        ModelInput other = (ModelInput) obj;
        return Objects.equals(dataInputConfig(), other.dataInputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInput").add("DataInputConfig", dataInputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataInputConfig":
            return Optional.ofNullable(clazz.cast(dataInputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataInputConfig", DATA_INPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelInput, T> g) {
        return obj -> g.apply((ModelInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInput> {
        /**
         * <p>
         * The input configuration object for the model.
         * </p>
         * 
         * @param dataInputConfig
         *        The input configuration object for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfig(String dataInputConfig);
    }

    static final class BuilderImpl implements Builder {
        private String dataInputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInput model) {
            dataInputConfig(model.dataInputConfig);
        }

        public final String getDataInputConfig() {
            return dataInputConfig;
        }

        public final void setDataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
        }

        @Override
        public final Builder dataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
            return this;
        }

        @Override
        public ModelInput build() {
            return new ModelInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
