/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model registry settings for the SageMaker Canvas application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelRegisterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelRegisterSettings.Builder, ModelRegisterSettings> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelRegisterSettings::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CrossAccountModelRegisterRoleArn")
            .getter(getter(ModelRegisterSettings::crossAccountModelRegisterRoleArn))
            .setter(setter(Builder::crossAccountModelRegisterRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountModelRegisterRoleArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String crossAccountModelRegisterRoleArn;

    private ModelRegisterSettings(BuilderImpl builder) {
        this.status = builder.status;
        this.crossAccountModelRegisterRoleArn = builder.crossAccountModelRegisterRoleArn;
    }

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final FeatureStatus status() {
        return FeatureStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions
     * created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services account in which
     * SageMaker model registry is set up.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model
     *         versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services
     *         account in which SageMaker model registry is set up.
     */
    public final String crossAccountModelRegisterRoleArn() {
        return crossAccountModelRegisterRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountModelRegisterRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelRegisterSettings)) {
            return false;
        }
        ModelRegisterSettings other = (ModelRegisterSettings) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(crossAccountModelRegisterRoleArn(), other.crossAccountModelRegisterRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelRegisterSettings").add("Status", statusAsString())
                .add("CrossAccountModelRegisterRoleArn", crossAccountModelRegisterRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CrossAccountModelRegisterRoleArn":
            return Optional.ofNullable(clazz.cast(crossAccountModelRegisterRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("CrossAccountModelRegisterRoleArn", CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelRegisterSettings, T> g) {
        return obj -> g.apply((ModelRegisterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelRegisterSettings> {
        /**
         * <p>
         * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether the integration to the model registry is enabled or disabled in the Canvas
         *        application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes whether the integration to the model registry is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether the integration to the model registry is enabled or disabled in the Canvas
         *        application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(FeatureStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model
         * versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web Services
         * account in which SageMaker model registry is set up.
         * </p>
         * 
         * @param crossAccountModelRegisterRoleArn
         *        The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register
         *        model versions created by a different SageMaker Canvas Amazon Web Services account than the Amazon Web
         *        Services account in which SageMaker model registry is set up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String crossAccountModelRegisterRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelRegisterSettings model) {
            status(model.status);
            crossAccountModelRegisterRoleArn(model.crossAccountModelRegisterRoleArn);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCrossAccountModelRegisterRoleArn() {
            return crossAccountModelRegisterRoleArn;
        }

        public final void setCrossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
            this.crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn;
        }

        @Override
        public final Builder crossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
            this.crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn;
            return this;
        }

        @Override
        public ModelRegisterSettings build() {
            return new ModelRegisterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
