/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the CSV dataset format used when running a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringCsvDatasetFormat implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringCsvDatasetFormat.Builder, MonitoringCsvDatasetFormat> {
    private static final SdkField<Boolean> HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Header").getter(getter(MonitoringCsvDatasetFormat::header)).setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean header;

    private MonitoringCsvDatasetFormat(BuilderImpl builder) {
        this.header = builder.header;
    }

    /**
     * <p>
     * Indicates if the CSV data has a header.
     * </p>
     * 
     * @return Indicates if the CSV data has a header.
     */
    public final Boolean header() {
        return header;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringCsvDatasetFormat)) {
            return false;
        }
        MonitoringCsvDatasetFormat other = (MonitoringCsvDatasetFormat) obj;
        return Objects.equals(header(), other.header());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringCsvDatasetFormat").add("Header", header()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Header", HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringCsvDatasetFormat, T> g) {
        return obj -> g.apply((MonitoringCsvDatasetFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringCsvDatasetFormat> {
        /**
         * <p>
         * Indicates if the CSV data has a header.
         * </p>
         * 
         * @param header
         *        Indicates if the CSV data has a header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(Boolean header);
    }

    static final class BuilderImpl implements Builder {
        private Boolean header;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringCsvDatasetFormat model) {
            header(model.header);
        }

        public final Boolean getHeader() {
            return header;
        }

        public final void setHeader(Boolean header) {
            this.header = header;
        }

        @Override
        public final Builder header(Boolean header) {
            this.header = header;
            return this;
        }

        @Override
        public MonitoringCsvDatasetFormat build() {
            return new MonitoringCsvDatasetFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
