/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the dataset format used when running a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringDatasetFormat implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringDatasetFormat.Builder, MonitoringDatasetFormat> {
    private static final SdkField<MonitoringCsvDatasetFormat> CSV_FIELD = SdkField
            .<MonitoringCsvDatasetFormat> builder(MarshallingType.SDK_POJO).memberName("Csv")
            .getter(getter(MonitoringDatasetFormat::csv)).setter(setter(Builder::csv))
            .constructor(MonitoringCsvDatasetFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csv").build()).build();

    private static final SdkField<MonitoringJsonDatasetFormat> JSON_FIELD = SdkField
            .<MonitoringJsonDatasetFormat> builder(MarshallingType.SDK_POJO).memberName("Json")
            .getter(getter(MonitoringDatasetFormat::json)).setter(setter(Builder::json))
            .constructor(MonitoringJsonDatasetFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Json").build()).build();

    private static final SdkField<MonitoringParquetDatasetFormat> PARQUET_FIELD = SdkField
            .<MonitoringParquetDatasetFormat> builder(MarshallingType.SDK_POJO).memberName("Parquet")
            .getter(getter(MonitoringDatasetFormat::parquet)).setter(setter(Builder::parquet))
            .constructor(MonitoringParquetDatasetFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parquet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD, JSON_FIELD,
            PARQUET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MonitoringCsvDatasetFormat csv;

    private final MonitoringJsonDatasetFormat json;

    private final MonitoringParquetDatasetFormat parquet;

    private MonitoringDatasetFormat(BuilderImpl builder) {
        this.csv = builder.csv;
        this.json = builder.json;
        this.parquet = builder.parquet;
    }

    /**
     * <p>
     * The CSV dataset used in the monitoring job.
     * </p>
     * 
     * @return The CSV dataset used in the monitoring job.
     */
    public final MonitoringCsvDatasetFormat csv() {
        return csv;
    }

    /**
     * <p>
     * The JSON dataset used in the monitoring job
     * </p>
     * 
     * @return The JSON dataset used in the monitoring job
     */
    public final MonitoringJsonDatasetFormat json() {
        return json;
    }

    /**
     * <p>
     * The Parquet dataset used in the monitoring job
     * </p>
     * 
     * @return The Parquet dataset used in the monitoring job
     */
    public final MonitoringParquetDatasetFormat parquet() {
        return parquet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        hashCode = 31 * hashCode + Objects.hashCode(json());
        hashCode = 31 * hashCode + Objects.hashCode(parquet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringDatasetFormat)) {
            return false;
        }
        MonitoringDatasetFormat other = (MonitoringDatasetFormat) obj;
        return Objects.equals(csv(), other.csv()) && Objects.equals(json(), other.json())
                && Objects.equals(parquet(), other.parquet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringDatasetFormat").add("Csv", csv()).add("Json", json()).add("Parquet", parquet())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Csv":
            return Optional.ofNullable(clazz.cast(csv()));
        case "Json":
            return Optional.ofNullable(clazz.cast(json()));
        case "Parquet":
            return Optional.ofNullable(clazz.cast(parquet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Csv", CSV_FIELD);
        map.put("Json", JSON_FIELD);
        map.put("Parquet", PARQUET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringDatasetFormat, T> g) {
        return obj -> g.apply((MonitoringDatasetFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringDatasetFormat> {
        /**
         * <p>
         * The CSV dataset used in the monitoring job.
         * </p>
         * 
         * @param csv
         *        The CSV dataset used in the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(MonitoringCsvDatasetFormat csv);

        /**
         * <p>
         * The CSV dataset used in the monitoring job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringCsvDatasetFormat.Builder}
         * avoiding the need to create one manually via {@link MonitoringCsvDatasetFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringCsvDatasetFormat.Builder#build()} is called immediately
         * and its result is passed to {@link #csv(MonitoringCsvDatasetFormat)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link MonitoringCsvDatasetFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(MonitoringCsvDatasetFormat)
         */
        default Builder csv(Consumer<MonitoringCsvDatasetFormat.Builder> csv) {
            return csv(MonitoringCsvDatasetFormat.builder().applyMutation(csv).build());
        }

        /**
         * <p>
         * The JSON dataset used in the monitoring job
         * </p>
         * 
         * @param json
         *        The JSON dataset used in the monitoring job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder json(MonitoringJsonDatasetFormat json);

        /**
         * <p>
         * The JSON dataset used in the monitoring job
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringJsonDatasetFormat.Builder}
         * avoiding the need to create one manually via {@link MonitoringJsonDatasetFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringJsonDatasetFormat.Builder#build()} is called
         * immediately and its result is passed to {@link #json(MonitoringJsonDatasetFormat)}.
         * 
         * @param json
         *        a consumer that will call methods on {@link MonitoringJsonDatasetFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #json(MonitoringJsonDatasetFormat)
         */
        default Builder json(Consumer<MonitoringJsonDatasetFormat.Builder> json) {
            return json(MonitoringJsonDatasetFormat.builder().applyMutation(json).build());
        }

        /**
         * <p>
         * The Parquet dataset used in the monitoring job
         * </p>
         * 
         * @param parquet
         *        The Parquet dataset used in the monitoring job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquet(MonitoringParquetDatasetFormat parquet);

        /**
         * <p>
         * The Parquet dataset used in the monitoring job
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringParquetDatasetFormat.Builder}
         * avoiding the need to create one manually via {@link MonitoringParquetDatasetFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringParquetDatasetFormat.Builder#build()} is called
         * immediately and its result is passed to {@link #parquet(MonitoringParquetDatasetFormat)}.
         * 
         * @param parquet
         *        a consumer that will call methods on {@link MonitoringParquetDatasetFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquet(MonitoringParquetDatasetFormat)
         */
        default Builder parquet(Consumer<MonitoringParquetDatasetFormat.Builder> parquet) {
            return parquet(MonitoringParquetDatasetFormat.builder().applyMutation(parquet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MonitoringCsvDatasetFormat csv;

        private MonitoringJsonDatasetFormat json;

        private MonitoringParquetDatasetFormat parquet;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringDatasetFormat model) {
            csv(model.csv);
            json(model.json);
            parquet(model.parquet);
        }

        public final MonitoringCsvDatasetFormat.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        public final void setCsv(MonitoringCsvDatasetFormat.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(MonitoringCsvDatasetFormat csv) {
            this.csv = csv;
            return this;
        }

        public final MonitoringJsonDatasetFormat.Builder getJson() {
            return json != null ? json.toBuilder() : null;
        }

        public final void setJson(MonitoringJsonDatasetFormat.BuilderImpl json) {
            this.json = json != null ? json.build() : null;
        }

        @Override
        public final Builder json(MonitoringJsonDatasetFormat json) {
            this.json = json;
            return this;
        }

        public final MonitoringParquetDatasetFormat.Builder getParquet() {
            return parquet != null ? parquet.toBuilder() : null;
        }

        public final void setParquet(MonitoringParquetDatasetFormat.BuilderImpl parquet) {
            this.parquet = parquet != null ? parquet.build() : null;
        }

        @Override
        public final Builder parquet(MonitoringParquetDatasetFormat parquet) {
            this.parquet = parquet;
            return this;
        }

        @Override
        public MonitoringDatasetFormat build() {
            return new MonitoringDatasetFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
