/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A schedule for a model monitoring job. For information about model monitor, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringSchedule.Builder, MonitoringSchedule> {
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleArn").getter(getter(MonitoringSchedule::monitoringScheduleArn))
            .setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(MonitoringSchedule::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleStatus").getter(getter(MonitoringSchedule::monitoringScheduleStatusAsString))
            .setter(setter(Builder::monitoringScheduleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build())
            .build();

    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringType").getter(getter(MonitoringSchedule::monitoringTypeAsString))
            .setter(setter(Builder::monitoringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(MonitoringSchedule::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitoringSchedule::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(MonitoringSchedule::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField
            .<MonitoringScheduleConfig> builder(MarshallingType.SDK_POJO).memberName("MonitoringScheduleConfig")
            .getter(getter(MonitoringSchedule::monitoringScheduleConfig)).setter(setter(Builder::monitoringScheduleConfig))
            .constructor(MonitoringScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(MonitoringSchedule::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<MonitoringExecutionSummary> LAST_MONITORING_EXECUTION_SUMMARY_FIELD = SdkField
            .<MonitoringExecutionSummary> builder(MarshallingType.SDK_POJO)
            .memberName("LastMonitoringExecutionSummary")
            .getter(getter(MonitoringSchedule::lastMonitoringExecutionSummary))
            .setter(setter(Builder::lastMonitoringExecutionSummary))
            .constructor(MonitoringExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMonitoringExecutionSummary")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(MonitoringSchedule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_ARN_FIELD,
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_STATUS_FIELD, MONITORING_TYPE_FIELD, FAILURE_REASON_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD, ENDPOINT_NAME_FIELD,
            LAST_MONITORING_EXECUTION_SUMMARY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleArn;

    private final String monitoringScheduleName;

    private final String monitoringScheduleStatus;

    private final String monitoringType;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final MonitoringScheduleConfig monitoringScheduleConfig;

    private final String endpointName;

    private final MonitoringExecutionSummary lastMonitoringExecutionSummary;

    private final List<Tag> tags;

    private MonitoringSchedule(BuilderImpl builder) {
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.monitoringType = builder.monitoringType;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
        this.endpointName = builder.endpointName;
        this.lastMonitoringExecutionSummary = builder.lastMonitoringExecutionSummary;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    public final String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * The name of the monitoring schedule.
     * </p>
     * 
     * @return The name of the monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The status of the monitoring schedule. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The schedule is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The schedule failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code> - The schedule was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The schedule was stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The schedule is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The schedule failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code> - The schedule was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - The schedule was stopped.
     *         </p>
     *         </li>
     * @see ScheduleStatus
     */
    public final ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(monitoringScheduleStatus);
    }

    /**
     * <p>
     * The status of the monitoring schedule. This can be one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The schedule is pending being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The schedule failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code> - The schedule was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - The schedule was stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule. This can be one of the following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The schedule is pending being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The schedule failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code> - The schedule was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - The schedule was stopped.
     *         </p>
     *         </li>
     * @see ScheduleStatus
     */
    public final String monitoringScheduleStatusAsString() {
        return monitoringScheduleStatus;
    }

    /**
     * <p>
     * The type of the monitoring job definition to schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The type of the monitoring job definition to schedule.
     * @see MonitoringType
     */
    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(monitoringType);
    }

    /**
     * <p>
     * The type of the monitoring job definition to schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The type of the monitoring job definition to schedule.
     * @see MonitoringType
     */
    public final String monitoringTypeAsString() {
        return monitoringType;
    }

    /**
     * <p>
     * If the monitoring schedule failed, the reason it failed.
     * </p>
     * 
     * @return If the monitoring schedule failed, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The time that the monitoring schedule was created.
     * </p>
     * 
     * @return The time that the monitoring schedule was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the monitoring schedule was changed.
     * </p>
     * 
     * @return The last time the monitoring schedule was changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the MonitoringScheduleConfig property for this object.
     * 
     * @return The value of the MonitoringScheduleConfig property for this object.
     */
    public final MonitoringScheduleConfig monitoringScheduleConfig() {
        return monitoringScheduleConfig;
    }

    /**
     * <p>
     * The endpoint that hosts the model being monitored.
     * </p>
     * 
     * @return The endpoint that hosts the model being monitored.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * Returns the value of the LastMonitoringExecutionSummary property for this object.
     * 
     * @return The value of the LastMonitoringExecutionSummary property for this object.
     */
    public final MonitoringExecutionSummary lastMonitoringExecutionSummary() {
        return lastMonitoringExecutionSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tags associated with the monitoring schedlue. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of the tags associated with the monitoring schedlue. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(lastMonitoringExecutionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringSchedule)) {
            return false;
        }
        MonitoringSchedule other = (MonitoringSchedule) obj;
        return Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString())
                && Objects.equals(monitoringTypeAsString(), other.monitoringTypeAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringScheduleConfig(), other.monitoringScheduleConfig())
                && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(lastMonitoringExecutionSummary(), other.lastMonitoringExecutionSummary())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringSchedule").add("MonitoringScheduleArn", monitoringScheduleArn())
                .add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleStatus", monitoringScheduleStatusAsString())
                .add("MonitoringType", monitoringTypeAsString()).add("FailureReason", failureReason())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("MonitoringScheduleConfig", monitoringScheduleConfig()).add("EndpointName", endpointName())
                .add("LastMonitoringExecutionSummary", lastMonitoringExecutionSummary()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleStatus":
            return Optional.ofNullable(clazz.cast(monitoringScheduleStatusAsString()));
        case "MonitoringType":
            return Optional.ofNullable(clazz.cast(monitoringTypeAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringScheduleConfig":
            return Optional.ofNullable(clazz.cast(monitoringScheduleConfig()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "LastMonitoringExecutionSummary":
            return Optional.ofNullable(clazz.cast(lastMonitoringExecutionSummary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitoringScheduleArn", MONITORING_SCHEDULE_ARN_FIELD);
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("MonitoringScheduleStatus", MONITORING_SCHEDULE_STATUS_FIELD);
        map.put("MonitoringType", MONITORING_TYPE_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("MonitoringScheduleConfig", MONITORING_SCHEDULE_CONFIG_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("LastMonitoringExecutionSummary", LAST_MONITORING_EXECUTION_SUMMARY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringSchedule, T> g) {
        return obj -> g.apply((MonitoringSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringSchedule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The Amazon Resource Name (ARN) of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * The name of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The status of the monitoring schedule. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The schedule is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The schedule failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code> - The schedule was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> - The schedule was stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The schedule is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The schedule failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code> - The schedule was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> - The schedule was stopped.
         *        </p>
         *        </li>
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(String monitoringScheduleStatus);

        /**
         * <p>
         * The status of the monitoring schedule. This can be one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The schedule is pending being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The schedule failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code> - The schedule was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> - The schedule was stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule. This can be one of the following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The schedule is pending being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The schedule failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code> - The schedule was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> - The schedule was stopped.
         *        </p>
         *        </li>
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus);

        /**
         * <p>
         * The type of the monitoring job definition to schedule.
         * </p>
         * 
         * @param monitoringType
         *        The type of the monitoring job definition to schedule.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(String monitoringType);

        /**
         * <p>
         * The type of the monitoring job definition to schedule.
         * </p>
         * 
         * @param monitoringType
         *        The type of the monitoring job definition to schedule.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(MonitoringType monitoringType);

        /**
         * <p>
         * If the monitoring schedule failed, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If the monitoring schedule failed, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The time that the monitoring schedule was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the monitoring schedule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the monitoring schedule was changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the monitoring schedule was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the MonitoringScheduleConfig property for this object.
         *
         * @param monitoringScheduleConfig
         *        The new value for the MonitoringScheduleConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig);

        /**
         * Sets the value of the MonitoringScheduleConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringScheduleConfig.Builder}
         * avoiding the need to create one manually via {@link MonitoringScheduleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringScheduleConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringScheduleConfig(MonitoringScheduleConfig)}.
         * 
         * @param monitoringScheduleConfig
         *        a consumer that will call methods on {@link MonitoringScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleConfig(MonitoringScheduleConfig)
         */
        default Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return monitoringScheduleConfig(MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig).build());
        }

        /**
         * <p>
         * The endpoint that hosts the model being monitored.
         * </p>
         * 
         * @param endpointName
         *        The endpoint that hosts the model being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * Sets the value of the LastMonitoringExecutionSummary property for this object.
         *
         * @param lastMonitoringExecutionSummary
         *        The new value for the LastMonitoringExecutionSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary);

        /**
         * Sets the value of the LastMonitoringExecutionSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringExecutionSummary.Builder}
         * avoiding the need to create one manually via {@link MonitoringExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #lastMonitoringExecutionSummary(MonitoringExecutionSummary)}.
         * 
         * @param lastMonitoringExecutionSummary
         *        a consumer that will call methods on {@link MonitoringExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastMonitoringExecutionSummary(MonitoringExecutionSummary)
         */
        default Builder lastMonitoringExecutionSummary(Consumer<MonitoringExecutionSummary.Builder> lastMonitoringExecutionSummary) {
            return lastMonitoringExecutionSummary(MonitoringExecutionSummary.builder()
                    .applyMutation(lastMonitoringExecutionSummary).build());
        }

        /**
         * <p>
         * A list of the tags associated with the monitoring schedlue. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the monitoring schedlue. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tags associated with the monitoring schedlue. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of the tags associated with the monitoring schedlue. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tags associated with the monitoring schedlue. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleArn;

        private String monitoringScheduleName;

        private String monitoringScheduleStatus;

        private String monitoringType;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private MonitoringScheduleConfig monitoringScheduleConfig;

        private String endpointName;

        private MonitoringExecutionSummary lastMonitoringExecutionSummary;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringSchedule model) {
            monitoringScheduleArn(model.monitoringScheduleArn);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleStatus(model.monitoringScheduleStatus);
            monitoringType(model.monitoringType);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringScheduleConfig(model.monitoringScheduleConfig);
            endpointName(model.endpointName);
            lastMonitoringExecutionSummary(model.lastMonitoringExecutionSummary);
            tags(model.tags);
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringScheduleStatus() {
            return monitoringScheduleStatus;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final String getMonitoringType() {
            return monitoringType;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return monitoringScheduleConfig != null ? monitoringScheduleConfig.toBuilder() : null;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        @Override
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final MonitoringExecutionSummary.Builder getLastMonitoringExecutionSummary() {
            return lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.toBuilder() : null;
        }

        public final void setLastMonitoringExecutionSummary(MonitoringExecutionSummary.BuilderImpl lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.build()
                    : null;
        }

        @Override
        public final Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MonitoringSchedule build() {
            return new MonitoringSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
