/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the notebook instance lifecycle configuration script.
 * </p>
 * <p>
 * Each lifecycle configuration script has a limit of 16384 characters.
 * </p>
 * <p>
 * The value of the <code>$PATH</code> environment variable that is available to both scripts is
 * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
 * </p>
 * <p>
 * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
 * <code>/aws/sagemaker/NotebookInstances</code> in log stream
 * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
 * </p>
 * <p>
 * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it
 * fails and the notebook instance is not created or started.
 * </p>
 * <p>
 * For information about notebook instance lifestyle configurations, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize
 * a Notebook Instance</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotebookInstanceLifecycleHook implements SdkPojo, Serializable,
        ToCopyableBuilder<NotebookInstanceLifecycleHook.Builder, NotebookInstanceLifecycleHook> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(NotebookInstanceLifecycleHook::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private NotebookInstanceLifecycleHook(BuilderImpl builder) {
        this.content = builder.content;
    }

    /**
     * <p>
     * A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
     * </p>
     * 
     * @return A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookInstanceLifecycleHook)) {
            return false;
        }
        NotebookInstanceLifecycleHook other = (NotebookInstanceLifecycleHook) obj;
        return Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotebookInstanceLifecycleHook").add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotebookInstanceLifecycleHook, T> g) {
        return obj -> g.apply((NotebookInstanceLifecycleHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotebookInstanceLifecycleHook> {
        /**
         * <p>
         * A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
         * </p>
         * 
         * @param content
         *        A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookInstanceLifecycleHook model) {
            content(model.content);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public NotebookInstanceLifecycleHook build() {
            return new NotebookInstanceLifecycleHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
