/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your OIDC IdP workforce configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcConfigForResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<OidcConfigForResponse.Builder, OidcConfigForResponse> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(OidcConfigForResponse::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(OidcConfigForResponse::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint").getter(getter(OidcConfigForResponse::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenEndpoint").getter(getter(OidcConfigForResponse::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserInfoEndpoint").getter(getter(OidcConfigForResponse::userInfoEndpoint))
            .setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()).build();

    private static final SdkField<String> LOGOUT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogoutEndpoint").getter(getter(OidcConfigForResponse::logoutEndpoint))
            .setter(setter(Builder::logoutEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutEndpoint").build()).build();

    private static final SdkField<String> JWKS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JwksUri").getter(getter(OidcConfigForResponse::jwksUri)).setter(setter(Builder::jwksUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksUri").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(OidcConfigForResponse::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<Map<String, String>> AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AuthenticationRequestExtraParams")
            .getter(getter(OidcConfigForResponse::authenticationRequestExtraParams))
            .setter(setter(Builder::authenticationRequestExtraParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationRequestExtraParams")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, ISSUER_FIELD,
            AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, LOGOUT_ENDPOINT_FIELD, JWKS_URI_FIELD,
            SCOPE_FIELD, AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String logoutEndpoint;

    private final String jwksUri;

    private final String scope;

    private final Map<String, String> authenticationRequestExtraParams;

    private OidcConfigForResponse(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.logoutEndpoint = builder.logoutEndpoint;
        this.jwksUri = builder.jwksUri;
        this.scope = builder.scope;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
    }

    /**
     * <p>
     * The OIDC IdP client ID used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP client ID used to configure your private workforce.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OIDC IdP issuer used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP issuer used to configure your private workforce.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The OIDC IdP authorization endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP authorization endpoint used to configure your private workforce.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP token endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP token endpoint used to configure your private workforce.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP user information endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP user information endpoint used to configure your private workforce.
     */
    public final String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP logout endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP logout endpoint used to configure your private workforce.
     */
    public final String logoutEndpoint() {
        return logoutEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     */
    public final String jwksUri() {
        return jwksUri;
    }

    /**
     * <p>
     * An array of string identifiers used to refer to the specific pieces of user data or claims that the client
     * application wants to access.
     * </p>
     * 
     * @return An array of string identifiers used to refer to the specific pieces of user data or claims that the
     *         client application wants to access.
     */
    public final String scope() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationRequestExtraParams
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAuthenticationRequestExtraParams() {
        return authenticationRequestExtraParams != null && !(authenticationRequestExtraParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string to string map of identifiers specific to the custom identity provider (IdP) being used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationRequestExtraParams}
     * method.
     * </p>
     * 
     * @return A string to string map of identifiers specific to the custom identity provider (IdP) being used.
     */
    public final Map<String, String> authenticationRequestExtraParams() {
        return authenticationRequestExtraParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(logoutEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(jwksUri());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAuthenticationRequestExtraParams() ? authenticationRequestExtraParams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcConfigForResponse)) {
            return false;
        }
        OidcConfigForResponse other = (OidcConfigForResponse) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint())
                && Objects.equals(logoutEndpoint(), other.logoutEndpoint()) && Objects.equals(jwksUri(), other.jwksUri())
                && Objects.equals(scope(), other.scope())
                && hasAuthenticationRequestExtraParams() == other.hasAuthenticationRequestExtraParams()
                && Objects.equals(authenticationRequestExtraParams(), other.authenticationRequestExtraParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OidcConfigForResponse")
                .add("ClientId", clientId())
                .add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint())
                .add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint())
                .add("LogoutEndpoint", logoutEndpoint())
                .add("JwksUri", jwksUri())
                .add("Scope", scope())
                .add("AuthenticationRequestExtraParams",
                        hasAuthenticationRequestExtraParams() ? authenticationRequestExtraParams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "LogoutEndpoint":
            return Optional.ofNullable(clazz.cast(logoutEndpoint()));
        case "JwksUri":
            return Optional.ofNullable(clazz.cast(jwksUri()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "AuthenticationRequestExtraParams":
            return Optional.ofNullable(clazz.cast(authenticationRequestExtraParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
        map.put("LogoutEndpoint", LOGOUT_ENDPOINT_FIELD);
        map.put("JwksUri", JWKS_URI_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("AuthenticationRequestExtraParams", AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OidcConfigForResponse, T> g) {
        return obj -> g.apply((OidcConfigForResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcConfigForResponse> {
        /**
         * <p>
         * The OIDC IdP client ID used to configure your private workforce.
         * </p>
         * 
         * @param clientId
         *        The OIDC IdP client ID used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OIDC IdP issuer used to configure your private workforce.
         * </p>
         * 
         * @param issuer
         *        The OIDC IdP issuer used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The OIDC IdP authorization endpoint used to configure your private workforce.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The OIDC IdP authorization endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The OIDC IdP token endpoint used to configure your private workforce.
         * </p>
         * 
         * @param tokenEndpoint
         *        The OIDC IdP token endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The OIDC IdP user information endpoint used to configure your private workforce.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The OIDC IdP user information endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OIDC IdP logout endpoint used to configure your private workforce.
         * </p>
         * 
         * @param logoutEndpoint
         *        The OIDC IdP logout endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutEndpoint(String logoutEndpoint);

        /**
         * <p>
         * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * </p>
         * 
         * @param jwksUri
         *        The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwksUri(String jwksUri);

        /**
         * <p>
         * An array of string identifiers used to refer to the specific pieces of user data or claims that the client
         * application wants to access.
         * </p>
         * 
         * @param scope
         *        An array of string identifiers used to refer to the specific pieces of user data or claims that the
         *        client application wants to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * A string to string map of identifiers specific to the custom identity provider (IdP) being used.
         * </p>
         * 
         * @param authenticationRequestExtraParams
         *        A string to string map of identifiers specific to the custom identity provider (IdP) being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String logoutEndpoint;

        private String jwksUri;

        private String scope;

        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OidcConfigForResponse model) {
            clientId(model.clientId);
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            logoutEndpoint(model.logoutEndpoint);
            jwksUri(model.jwksUri);
            scope(model.scope);
            authenticationRequestExtraParams(model.authenticationRequestExtraParams);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getLogoutEndpoint() {
            return logoutEndpoint;
        }

        public final void setLogoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
        }

        @Override
        public final Builder logoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
            return this;
        }

        public final String getJwksUri() {
            return jwksUri;
        }

        public final void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        @Override
        public final Builder jwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            if (authenticationRequestExtraParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return authenticationRequestExtraParams;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
            return this;
        }

        @Override
        public OidcConfigForResponse build() {
            return new OidcConfigForResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
