/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the feature group online store configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnlineStoreConfigUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<OnlineStoreConfigUpdate.Builder, OnlineStoreConfigUpdate> {
    private static final SdkField<TtlDuration> TTL_DURATION_FIELD = SdkField.<TtlDuration> builder(MarshallingType.SDK_POJO)
            .memberName("TtlDuration").getter(getter(OnlineStoreConfigUpdate::ttlDuration)).setter(setter(Builder::ttlDuration))
            .constructor(TtlDuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TtlDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTL_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TtlDuration ttlDuration;

    private OnlineStoreConfigUpdate(BuilderImpl builder) {
        this.ttlDuration = builder.ttlDuration;
    }

    /**
     * <p>
     * Time to live duration, where the record is hard deleted after the expiration time is reached;
     * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete, see
     * the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">
     * DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
     * </p>
     * 
     * @return Time to live duration, where the record is hard deleted after the expiration time is reached;
     *         <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on
     *         HardDelete, see the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
     *         >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
     */
    public final TtlDuration ttlDuration() {
        return ttlDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttlDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineStoreConfigUpdate)) {
            return false;
        }
        OnlineStoreConfigUpdate other = (OnlineStoreConfigUpdate) obj;
        return Objects.equals(ttlDuration(), other.ttlDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnlineStoreConfigUpdate").add("TtlDuration", ttlDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TtlDuration":
            return Optional.ofNullable(clazz.cast(ttlDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TtlDuration", TTL_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnlineStoreConfigUpdate, T> g) {
        return obj -> g.apply((OnlineStoreConfigUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnlineStoreConfigUpdate> {
        /**
         * <p>
         * Time to live duration, where the record is hard deleted after the expiration time is reached;
         * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete,
         * see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         * >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * </p>
         * 
         * @param ttlDuration
         *        Time to live duration, where the record is hard deleted after the expiration time is reached;
         *        <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on
         *        HardDelete, see the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         *        >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttlDuration(TtlDuration ttlDuration);

        /**
         * <p>
         * Time to live duration, where the record is hard deleted after the expiration time is reached;
         * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete,
         * see the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html"
         * >DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link TtlDuration.Builder} avoiding the need to
         * create one manually via {@link TtlDuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TtlDuration.Builder#build()} is called immediately and its result
         * is passed to {@link #ttlDuration(TtlDuration)}.
         * 
         * @param ttlDuration
         *        a consumer that will call methods on {@link TtlDuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttlDuration(TtlDuration)
         */
        default Builder ttlDuration(Consumer<TtlDuration.Builder> ttlDuration) {
            return ttlDuration(TtlDuration.builder().applyMutation(ttlDuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TtlDuration ttlDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineStoreConfigUpdate model) {
            ttlDuration(model.ttlDuration);
        }

        public final TtlDuration.Builder getTtlDuration() {
            return ttlDuration != null ? ttlDuration.toBuilder() : null;
        }

        public final void setTtlDuration(TtlDuration.BuilderImpl ttlDuration) {
            this.ttlDuration = ttlDuration != null ? ttlDuration.build() : null;
        }

        @Override
        public final Builder ttlDuration(TtlDuration ttlDuration) {
            this.ttlDuration = ttlDuration;
            return this;
        }

        @Override
        public OnlineStoreConfigUpdate build() {
            return new OnlineStoreConfigUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
