/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the source model to optimize with an optimization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationJobModelSource implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationJobModelSource.Builder, OptimizationJobModelSource> {
    private static final SdkField<OptimizationJobModelSourceS3> S3_FIELD = SdkField
            .<OptimizationJobModelSourceS3> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(OptimizationJobModelSource::s3)).setter(setter(Builder::s3))
            .constructor(OptimizationJobModelSourceS3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OptimizationJobModelSourceS3 s3;

    private OptimizationJobModelSource(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * The Amazon S3 location of a source model to optimize with an optimization job.
     * </p>
     * 
     * @return The Amazon S3 location of a source model to optimize with an optimization job.
     */
    public final OptimizationJobModelSourceS3 s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobModelSource)) {
            return false;
        }
        OptimizationJobModelSource other = (OptimizationJobModelSource) obj;
        return Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationJobModelSource").add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobModelSource, T> g) {
        return obj -> g.apply((OptimizationJobModelSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationJobModelSource> {
        /**
         * <p>
         * The Amazon S3 location of a source model to optimize with an optimization job.
         * </p>
         * 
         * @param s3
         *        The Amazon S3 location of a source model to optimize with an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(OptimizationJobModelSourceS3 s3);

        /**
         * <p>
         * The Amazon S3 location of a source model to optimize with an optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationJobModelSourceS3.Builder}
         * avoiding the need to create one manually via {@link OptimizationJobModelSourceS3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationJobModelSourceS3.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(OptimizationJobModelSourceS3)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link OptimizationJobModelSourceS3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(OptimizationJobModelSourceS3)
         */
        default Builder s3(Consumer<OptimizationJobModelSourceS3.Builder> s3) {
            return s3(OptimizationJobModelSourceS3.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OptimizationJobModelSourceS3 s3;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobModelSource model) {
            s3(model.s3);
        }

        public final OptimizationJobModelSourceS3.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(OptimizationJobModelSourceS3.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(OptimizationJobModelSourceS3 s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public OptimizationJobModelSource build() {
            return new OptimizationJobModelSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
