/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of information related to a SageMaker Partner AI App. This information is used as part of the
 * <code>ListPartnerApps</code> API response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartnerAppSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PartnerAppSummary.Builder, PartnerAppSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PartnerAppSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PartnerAppSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PartnerAppSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PartnerAppSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PartnerAppSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final String status;

    private final Instant creationTime;

    private PartnerAppSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ARN of the SageMaker Partner AI App.
     * </p>
     * 
     * @return The ARN of the SageMaker Partner AI App.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the SageMaker Partner AI App.
     * </p>
     * 
     * @return The name of the SageMaker Partner AI App.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
     * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartnerAppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
     *         <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * @see PartnerAppType
     */
    public final PartnerAppType type() {
        return PartnerAppType.fromValue(type);
    }

    /**
     * <p>
     * The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
     * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PartnerAppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
     *         <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
     * @see PartnerAppType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker Partner AI App.
     * @see PartnerAppStatus
     */
    public final PartnerAppStatus status() {
        return PartnerAppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the SageMaker Partner AI App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker Partner AI App.
     * @see PartnerAppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time of the SageMaker Partner AI App.
     * </p>
     * 
     * @return The creation time of the SageMaker Partner AI App.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerAppSummary)) {
            return false;
        }
        PartnerAppSummary other = (PartnerAppSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartnerAppSummary").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartnerAppSummary, T> g) {
        return obj -> g.apply((PartnerAppSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartnerAppSummary> {
        /**
         * <p>
         * The ARN of the SageMaker Partner AI App.
         * </p>
         * 
         * @param arn
         *        The ARN of the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the SageMaker Partner AI App.
         * </p>
         * 
         * @param name
         *        The name of the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
         * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * </p>
         * 
         * @param type
         *        The type of SageMaker Partner AI App to create. Must be one of the following:
         *        <code>lakera-guard</code>, <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or
         *        <code>fiddler</code>.
         * @see PartnerAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of SageMaker Partner AI App to create. Must be one of the following: <code>lakera-guard</code>,
         * <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or <code>fiddler</code>.
         * </p>
         * 
         * @param type
         *        The type of SageMaker Partner AI App to create. Must be one of the following:
         *        <code>lakera-guard</code>, <code>comet</code>, <code>deepchecks-llm-evaluation</code>, or
         *        <code>fiddler</code>.
         * @see PartnerAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppType
         */
        Builder type(PartnerAppType type);

        /**
         * <p>
         * The status of the SageMaker Partner AI App.
         * </p>
         * 
         * @param status
         *        The status of the SageMaker Partner AI App.
         * @see PartnerAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SageMaker Partner AI App.
         * </p>
         * 
         * @param status
         *        The status of the SageMaker Partner AI App.
         * @see PartnerAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerAppStatus
         */
        Builder status(PartnerAppStatus status);

        /**
         * <p>
         * The creation time of the SageMaker Partner AI App.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerAppSummary model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartnerAppType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PartnerAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public PartnerAppSummary build() {
            return new PartnerAppSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
