/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for processing job outputs in Amazon SageMaker Feature Store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingFeatureStoreOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingFeatureStoreOutput.Builder, ProcessingFeatureStoreOutput> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(ProcessingFeatureStoreOutput::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String featureGroupName;

    private ProcessingFeatureStoreOutput(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note that your
     * processing script is responsible for putting records into your Feature Store.
     * </p>
     * 
     * @return The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note
     *         that your processing script is responsible for putting records into your Feature Store.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingFeatureStoreOutput)) {
            return false;
        }
        ProcessingFeatureStoreOutput other = (ProcessingFeatureStoreOutput) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessingFeatureStoreOutput").add("FeatureGroupName", featureGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcessingFeatureStoreOutput, T> g) {
        return obj -> g.apply((ProcessingFeatureStoreOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingFeatureStoreOutput> {
        /**
         * <p>
         * The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note that
         * your processing script is responsible for putting records into your Feature Store.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output.
         *        Note that your processing script is responsible for putting records into your Feature Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String featureGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingFeatureStoreOutput model) {
            featureGroupName(model.featureGroupName);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        @Override
        public ProcessingFeatureStoreOutput build() {
            return new ProcessingFeatureStoreOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
