/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryLineageRequest extends SageMakerRequest implements
        ToCopyableBuilder<QueryLineageRequest.Builder, QueryLineageRequest> {
    private static final SdkField<List<String>> START_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StartArns")
            .getter(getter(QueryLineageRequest::startArns))
            .setter(setter(Builder::startArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(QueryLineageRequest::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<Boolean> INCLUDE_EDGES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeEdges").getter(getter(QueryLineageRequest::includeEdges)).setter(setter(Builder::includeEdges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeEdges").build()).build();

    private static final SdkField<QueryFilters> FILTERS_FIELD = SdkField.<QueryFilters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(QueryLineageRequest::filters)).setter(setter(Builder::filters))
            .constructor(QueryFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDepth").getter(getter(QueryLineageRequest::maxDepth)).setter(setter(Builder::maxDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDepth").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(QueryLineageRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QueryLineageRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_ARNS_FIELD,
            DIRECTION_FIELD, INCLUDE_EDGES_FIELD, FILTERS_FIELD, MAX_DEPTH_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> startArns;

    private final String direction;

    private final Boolean includeEdges;

    private final QueryFilters filters;

    private final Integer maxDepth;

    private final Integer maxResults;

    private final String nextToken;

    private QueryLineageRequest(BuilderImpl builder) {
        super(builder);
        this.startArns = builder.startArns;
        this.direction = builder.direction;
        this.includeEdges = builder.includeEdges;
        this.filters = builder.filters;
        this.maxDepth = builder.maxDepth;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StartArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStartArns() {
        return startArns != null && !(startArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStartArns} method.
     * </p>
     * 
     * @return A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
     */
    public final List<String> startArns() {
        return startArns;
    }

    /**
     * <p>
     * Associations between lineage entities have a direction. This parameter determines the direction from the
     * StartArn(s) that the query traverses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link Direction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Associations between lineage entities have a direction. This parameter determines the direction from the
     *         StartArn(s) that the query traverses.
     * @see Direction
     */
    public final Direction direction() {
        return Direction.fromValue(direction);
    }

    /**
     * <p>
     * Associations between lineage entities have a direction. This parameter determines the direction from the
     * StartArn(s) that the query traverses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link Direction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Associations between lineage entities have a direction. This parameter determines the direction from the
     *         StartArn(s) that the query traverses.
     * @see Direction
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * Setting this value to <code>True</code> retrieves not only the entities of interest but also the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a> and
     * lineage entities on the path. Set to <code>False</code> to only return lineage entities that match your query.
     * </p>
     * 
     * @return Setting this value to <code>True</code> retrieves not only the entities of interest but also the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a>
     *         and lineage entities on the path. Set to <code>False</code> to only return lineage entities that match
     *         your query.
     */
    public final Boolean includeEdges() {
        return includeEdges;
    }

    /**
     * <p>
     * A set of filtering parameters that allow you to specify which entities should be returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties - Key-value pairs to match on the lineage entities' properties.
     * </p>
     * </li>
     * <li>
     * <p>
     * LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>,
     * <code>Artifact</code>, or <code>Context</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CreatedBefore - Filter entities created before this date.
     * </p>
     * </li>
     * <li>
     * <p>
     * ModifiedBefore - Filter entities modified before this date.
     * </p>
     * </li>
     * <li>
     * <p>
     * ModifiedAfter - Filter entities modified after this date.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A set of filtering parameters that allow you to specify which entities should be returned.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Properties - Key-value pairs to match on the lineage entities' properties.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>,
     *         <code>Artifact</code>, or <code>Context</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CreatedBefore - Filter entities created before this date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ModifiedBefore - Filter entities modified before this date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ModifiedAfter - Filter entities modified after this date.
     *         </p>
     *         </li>
     */
    public final QueryFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum depth in lineage relationships from the <code>StartArns</code> that are traversed. Depth is a measure
     * of the number of <code>Associations</code> from the <code>StartArn</code> entity to the matched results.
     * </p>
     * 
     * @return The maximum depth in lineage relationships from the <code>StartArns</code> that are traversed. Depth is a
     *         measure of the number of <code>Associations</code> from the <code>StartArn</code> entity to the matched
     *         results.
     */
    public final Integer maxDepth() {
        return maxDepth;
    }

    /**
     * <p>
     * Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to retrieve the
     * next page of results.
     * </p>
     * 
     * @return Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to retrieve
     *         the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Limits the number of vertices in the request. Use the <code>NextToken</code> in a response to to retrieve the
     * next page of results.
     * </p>
     * 
     * @return Limits the number of vertices in the request. Use the <code>NextToken</code> in a response to to retrieve
     *         the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStartArns() ? startArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeEdges());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLineageRequest)) {
            return false;
        }
        QueryLineageRequest other = (QueryLineageRequest) obj;
        return hasStartArns() == other.hasStartArns() && Objects.equals(startArns(), other.startArns())
                && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(includeEdges(), other.includeEdges()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxDepth(), other.maxDepth()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryLineageRequest").add("StartArns", hasStartArns() ? startArns() : null)
                .add("Direction", directionAsString()).add("IncludeEdges", includeEdges()).add("Filters", filters())
                .add("MaxDepth", maxDepth()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartArns":
            return Optional.ofNullable(clazz.cast(startArns()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "IncludeEdges":
            return Optional.ofNullable(clazz.cast(includeEdges()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxDepth":
            return Optional.ofNullable(clazz.cast(maxDepth()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartArns", START_ARNS_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("IncludeEdges", INCLUDE_EDGES_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxDepth", MAX_DEPTH_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryLineageRequest, T> g) {
        return obj -> g.apply((QueryLineageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryLineageRequest> {
        /**
         * <p>
         * A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
         * </p>
         * 
         * @param startArns
         *        A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startArns(Collection<String> startArns);

        /**
         * <p>
         * A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.
         * </p>
         * 
         * @param startArns
         *        A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startArns(String... startArns);

        /**
         * <p>
         * Associations between lineage entities have a direction. This parameter determines the direction from the
         * StartArn(s) that the query traverses.
         * </p>
         * 
         * @param direction
         *        Associations between lineage entities have a direction. This parameter determines the direction from
         *        the StartArn(s) that the query traverses.
         * @see Direction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Direction
         */
        Builder direction(String direction);

        /**
         * <p>
         * Associations between lineage entities have a direction. This parameter determines the direction from the
         * StartArn(s) that the query traverses.
         * </p>
         * 
         * @param direction
         *        Associations between lineage entities have a direction. This parameter determines the direction from
         *        the StartArn(s) that the query traverses.
         * @see Direction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Direction
         */
        Builder direction(Direction direction);

        /**
         * <p>
         * Setting this value to <code>True</code> retrieves not only the entities of interest but also the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a> and
         * lineage entities on the path. Set to <code>False</code> to only return lineage entities that match your
         * query.
         * </p>
         * 
         * @param includeEdges
         *        Setting this value to <code>True</code> retrieves not only the entities of interest but also the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a>
         *        and lineage entities on the path. Set to <code>False</code> to only return lineage entities that match
         *        your query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeEdges(Boolean includeEdges);

        /**
         * <p>
         * A set of filtering parameters that allow you to specify which entities should be returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Properties - Key-value pairs to match on the lineage entities' properties.
         * </p>
         * </li>
         * <li>
         * <p>
         * LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>,
         * <code>Artifact</code>, or <code>Context</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CreatedBefore - Filter entities created before this date.
         * </p>
         * </li>
         * <li>
         * <p>
         * ModifiedBefore - Filter entities modified before this date.
         * </p>
         * </li>
         * <li>
         * <p>
         * ModifiedAfter - Filter entities modified after this date.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A set of filtering parameters that allow you to specify which entities should be returned.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Properties - Key-value pairs to match on the lineage entities' properties.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>,
         *        <code>Artifact</code>, or <code>Context</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CreatedBefore - Filter entities created before this date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ModifiedBefore - Filter entities modified before this date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ModifiedAfter - Filter entities modified after this date.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(QueryFilters filters);

        /**
         * <p>
         * A set of filtering parameters that allow you to specify which entities should be returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Properties - Key-value pairs to match on the lineage entities' properties.
         * </p>
         * </li>
         * <li>
         * <p>
         * LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>,
         * <code>Artifact</code>, or <code>Context</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CreatedBefore - Filter entities created before this date.
         * </p>
         * </li>
         * <li>
         * <p>
         * ModifiedBefore - Filter entities modified before this date.
         * </p>
         * </li>
         * <li>
         * <p>
         * ModifiedAfter - Filter entities modified after this date.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link QueryFilters.Builder} avoiding the need
         * to create one manually via {@link QueryFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(QueryFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link QueryFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(QueryFilters)
         */
        default Builder filters(Consumer<QueryFilters.Builder> filters) {
            return filters(QueryFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum depth in lineage relationships from the <code>StartArns</code> that are traversed. Depth is a
         * measure of the number of <code>Associations</code> from the <code>StartArn</code> entity to the matched
         * results.
         * </p>
         * 
         * @param maxDepth
         *        The maximum depth in lineage relationships from the <code>StartArns</code> that are traversed. Depth
         *        is a measure of the number of <code>Associations</code> from the <code>StartArn</code> entity to the
         *        matched results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDepth(Integer maxDepth);

        /**
         * <p>
         * Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to retrieve the
         * next page of results.
         * </p>
         * 
         * @param maxResults
         *        Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to
         *        retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Limits the number of vertices in the request. Use the <code>NextToken</code> in a response to to retrieve the
         * next page of results.
         * </p>
         * 
         * @param nextToken
         *        Limits the number of vertices in the request. Use the <code>NextToken</code> in a response to to
         *        retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private List<String> startArns = DefaultSdkAutoConstructList.getInstance();

        private String direction;

        private Boolean includeEdges;

        private QueryFilters filters;

        private Integer maxDepth;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLineageRequest model) {
            super(model);
            startArns(model.startArns);
            direction(model.direction);
            includeEdges(model.includeEdges);
            filters(model.filters);
            maxDepth(model.maxDepth);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getStartArns() {
            if (startArns instanceof SdkAutoConstructList) {
                return null;
            }
            return startArns;
        }

        public final void setStartArns(Collection<String> startArns) {
            this.startArns = QueryLineageStartArnsCopier.copy(startArns);
        }

        @Override
        public final Builder startArns(Collection<String> startArns) {
            this.startArns = QueryLineageStartArnsCopier.copy(startArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startArns(String... startArns) {
            startArns(Arrays.asList(startArns));
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(Direction direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final Boolean getIncludeEdges() {
            return includeEdges;
        }

        public final void setIncludeEdges(Boolean includeEdges) {
            this.includeEdges = includeEdges;
        }

        @Override
        public final Builder includeEdges(Boolean includeEdges) {
            this.includeEdges = includeEdges;
            return this;
        }

        public final QueryFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(QueryFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(QueryFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxDepth() {
            return maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryLineageRequest build() {
            return new QueryLineageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
