/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RStudioServerProDomainSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RStudioServerProDomainSettings.Builder, RStudioServerProDomainSettings> {
    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainExecutionRoleArn").getter(getter(RStudioServerProDomainSettings::domainExecutionRoleArn))
            .setter(setter(Builder::domainExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainExecutionRoleArn").build())
            .build();

    private static final SdkField<String> R_STUDIO_CONNECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RStudioConnectUrl").getter(getter(RStudioServerProDomainSettings::rStudioConnectUrl))
            .setter(setter(Builder::rStudioConnectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioConnectUrl").build()).build();

    private static final SdkField<String> R_STUDIO_PACKAGE_MANAGER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RStudioPackageManagerUrl").getter(getter(RStudioServerProDomainSettings::rStudioPackageManagerUrl))
            .setter(setter(Builder::rStudioPackageManagerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioPackageManagerUrl").build())
            .build();

    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(RStudioServerProDomainSettings::defaultResourceSpec)).setter(setter(Builder::defaultResourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_EXECUTION_ROLE_ARN_FIELD, R_STUDIO_CONNECT_URL_FIELD, R_STUDIO_PACKAGE_MANAGER_URL_FIELD,
            DEFAULT_RESOURCE_SPEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainExecutionRoleArn;

    private final String rStudioConnectUrl;

    private final String rStudioPackageManagerUrl;

    private final ResourceSpec defaultResourceSpec;

    private RStudioServerProDomainSettings(BuilderImpl builder) {
        this.domainExecutionRoleArn = builder.domainExecutionRoleArn;
        this.rStudioConnectUrl = builder.rStudioConnectUrl;
        this.rStudioPackageManagerUrl = builder.rStudioPackageManagerUrl;
        this.defaultResourceSpec = builder.defaultResourceSpec;
    }

    /**
     * <p>
     * The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.
     * </p>
     * 
     * @return The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.
     */
    public final String domainExecutionRoleArn() {
        return domainExecutionRoleArn;
    }

    /**
     * <p>
     * A URL pointing to an RStudio Connect server.
     * </p>
     * 
     * @return A URL pointing to an RStudio Connect server.
     */
    public final String rStudioConnectUrl() {
        return rStudioConnectUrl;
    }

    /**
     * <p>
     * A URL pointing to an RStudio Package Manager server.
     * </p>
     * 
     * @return A URL pointing to an RStudio Package Manager server.
     */
    public final String rStudioPackageManagerUrl() {
        return rStudioPackageManagerUrl;
    }

    /**
     * Returns the value of the DefaultResourceSpec property for this object.
     * 
     * @return The value of the DefaultResourceSpec property for this object.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(rStudioConnectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rStudioPackageManagerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RStudioServerProDomainSettings)) {
            return false;
        }
        RStudioServerProDomainSettings other = (RStudioServerProDomainSettings) obj;
        return Objects.equals(domainExecutionRoleArn(), other.domainExecutionRoleArn())
                && Objects.equals(rStudioConnectUrl(), other.rStudioConnectUrl())
                && Objects.equals(rStudioPackageManagerUrl(), other.rStudioPackageManagerUrl())
                && Objects.equals(defaultResourceSpec(), other.defaultResourceSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RStudioServerProDomainSettings").add("DomainExecutionRoleArn", domainExecutionRoleArn())
                .add("RStudioConnectUrl", rStudioConnectUrl()).add("RStudioPackageManagerUrl", rStudioPackageManagerUrl())
                .add("DefaultResourceSpec", defaultResourceSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(domainExecutionRoleArn()));
        case "RStudioConnectUrl":
            return Optional.ofNullable(clazz.cast(rStudioConnectUrl()));
        case "RStudioPackageManagerUrl":
            return Optional.ofNullable(clazz.cast(rStudioPackageManagerUrl()));
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainExecutionRoleArn", DOMAIN_EXECUTION_ROLE_ARN_FIELD);
        map.put("RStudioConnectUrl", R_STUDIO_CONNECT_URL_FIELD);
        map.put("RStudioPackageManagerUrl", R_STUDIO_PACKAGE_MANAGER_URL_FIELD);
        map.put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RStudioServerProDomainSettings, T> g) {
        return obj -> g.apply((RStudioServerProDomainSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RStudioServerProDomainSettings> {
        /**
         * <p>
         * The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.
         * </p>
         * 
         * @param domainExecutionRoleArn
         *        The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainExecutionRoleArn(String domainExecutionRoleArn);

        /**
         * <p>
         * A URL pointing to an RStudio Connect server.
         * </p>
         * 
         * @param rStudioConnectUrl
         *        A URL pointing to an RStudio Connect server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioConnectUrl(String rStudioConnectUrl);

        /**
         * <p>
         * A URL pointing to an RStudio Package Manager server.
         * </p>
         * 
         * @param rStudioPackageManagerUrl
         *        A URL pointing to an RStudio Package Manager server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioPackageManagerUrl(String rStudioPackageManagerUrl);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * @param defaultResourceSpec
         *        The new value for the DefaultResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainExecutionRoleArn;

        private String rStudioConnectUrl;

        private String rStudioPackageManagerUrl;

        private ResourceSpec defaultResourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(RStudioServerProDomainSettings model) {
            domainExecutionRoleArn(model.domainExecutionRoleArn);
            rStudioConnectUrl(model.rStudioConnectUrl);
            rStudioPackageManagerUrl(model.rStudioPackageManagerUrl);
            defaultResourceSpec(model.defaultResourceSpec);
        }

        public final String getDomainExecutionRoleArn() {
            return domainExecutionRoleArn;
        }

        public final void setDomainExecutionRoleArn(String domainExecutionRoleArn) {
            this.domainExecutionRoleArn = domainExecutionRoleArn;
        }

        @Override
        public final Builder domainExecutionRoleArn(String domainExecutionRoleArn) {
            this.domainExecutionRoleArn = domainExecutionRoleArn;
            return this;
        }

        public final String getRStudioConnectUrl() {
            return rStudioConnectUrl;
        }

        public final void setRStudioConnectUrl(String rStudioConnectUrl) {
            this.rStudioConnectUrl = rStudioConnectUrl;
        }

        @Override
        public final Builder rStudioConnectUrl(String rStudioConnectUrl) {
            this.rStudioConnectUrl = rStudioConnectUrl;
            return this;
        }

        public final String getRStudioPackageManagerUrl() {
            return rStudioPackageManagerUrl;
        }

        public final void setRStudioPackageManagerUrl(String rStudioPackageManagerUrl) {
            this.rStudioPackageManagerUrl = rStudioPackageManagerUrl;
        }

        @Override
        public final Builder rStudioPackageManagerUrl(String rStudioPackageManagerUrl) {
            this.rStudioPackageManagerUrl = rStudioPackageManagerUrl;
            return this;
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        @Override
        public RStudioServerProDomainSettings build() {
            return new RStudioServerProDomainSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
