/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended configuration to use for Real-Time Inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeInferenceRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeInferenceRecommendation.Builder, RealTimeInferenceRecommendation> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(RealTimeInferenceRecommendation::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(RealTimeInferenceRecommendation::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(RealTimeInferenceRecommendation::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            INSTANCE_TYPE_FIELD, ENVIRONMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String instanceType;

    private final Map<String, String> environment;

    private RealTimeInferenceRecommendation(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.instanceType = builder.instanceType;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The recommendation ID which uniquely identifies each recommendation.
     * </p>
     * 
     * @return The recommendation ID which uniquely identifies each recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The recommended instance type for Real-Time Inference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The recommended instance type for Real-Time Inference.
     * @see ProductionVariantInstanceType
     */
    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The recommended instance type for Real-Time Inference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ProductionVariantInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The recommended instance type for Real-Time Inference.
     * @see ProductionVariantInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The recommended environment variables to set in the model container for Real-Time Inference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The recommended environment variables to set in the model container for Real-Time Inference.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeInferenceRecommendation)) {
            return false;
        }
        RealTimeInferenceRecommendation other = (RealTimeInferenceRecommendation) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeInferenceRecommendation").add("RecommendationId", recommendationId())
                .add("InstanceType", instanceTypeAsString()).add("Environment", hasEnvironment() ? environment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeInferenceRecommendation, T> g) {
        return obj -> g.apply((RealTimeInferenceRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeInferenceRecommendation> {
        /**
         * <p>
         * The recommendation ID which uniquely identifies each recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The recommendation ID which uniquely identifies each recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The recommended instance type for Real-Time Inference.
         * </p>
         * 
         * @param instanceType
         *        The recommended instance type for Real-Time Inference.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The recommended instance type for Real-Time Inference.
         * </p>
         * 
         * @param instanceType
         *        The recommended instance type for Real-Time Inference.
         * @see ProductionVariantInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductionVariantInstanceType
         */
        Builder instanceType(ProductionVariantInstanceType instanceType);

        /**
         * <p>
         * The recommended environment variables to set in the model container for Real-Time Inference.
         * </p>
         * 
         * @param environment
         *        The recommended environment variables to set in the model container for Real-Time Inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String instanceType;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeInferenceRecommendation model) {
            recommendationId(model.recommendationId);
            instanceType(model.instanceType);
            environment(model.environment);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        @Override
        public RealTimeInferenceRecommendation build() {
            return new RealTimeInferenceRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
