/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the output configuration for the compiled model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobCompiledOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobCompiledOutputConfig.Builder, RecommendationJobCompiledOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputUri").getter(getter(RecommendationJobCompiledOutputConfig::s3OutputUri))
            .setter(setter(Builder::s3OutputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3OutputUri;

    private RecommendationJobCompiledOutputConfig(BuilderImpl builder) {
        this.s3OutputUri = builder.s3OutputUri;
    }

    /**
     * <p>
     * Identifies the Amazon S3 bucket where you want SageMaker to store the compiled model artifacts.
     * </p>
     * 
     * @return Identifies the Amazon S3 bucket where you want SageMaker to store the compiled model artifacts.
     */
    public final String s3OutputUri() {
        return s3OutputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobCompiledOutputConfig)) {
            return false;
        }
        RecommendationJobCompiledOutputConfig other = (RecommendationJobCompiledOutputConfig) obj;
        return Objects.equals(s3OutputUri(), other.s3OutputUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobCompiledOutputConfig").add("S3OutputUri", s3OutputUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputUri":
            return Optional.ofNullable(clazz.cast(s3OutputUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3OutputUri", S3_OUTPUT_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobCompiledOutputConfig, T> g) {
        return obj -> g.apply((RecommendationJobCompiledOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobCompiledOutputConfig> {
        /**
         * <p>
         * Identifies the Amazon S3 bucket where you want SageMaker to store the compiled model artifacts.
         * </p>
         * 
         * @param s3OutputUri
         *        Identifies the Amazon S3 bucket where you want SageMaker to store the compiled model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputUri(String s3OutputUri);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobCompiledOutputConfig model) {
            s3OutputUri(model.s3OutputUri);
        }

        public final String getS3OutputUri() {
            return s3OutputUri;
        }

        public final void setS3OutputUri(String s3OutputUri) {
            this.s3OutputUri = s3OutputUri;
        }

        @Override
        public final Builder s3OutputUri(String s3OutputUri) {
            this.s3OutputUri = s3OutputUri;
            return this;
        }

        @Override
        public RecommendationJobCompiledOutputConfig build() {
            return new RecommendationJobCompiledOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
