/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the maximum number of jobs that can run in parallel and the maximum number of jobs that can run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobResourceLimit implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobResourceLimit.Builder, RecommendationJobResourceLimit> {
    private static final SdkField<Integer> MAX_NUMBER_OF_TESTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxNumberOfTests").getter(getter(RecommendationJobResourceLimit::maxNumberOfTests))
            .setter(setter(Builder::maxNumberOfTests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfTests").build()).build();

    private static final SdkField<Integer> MAX_PARALLEL_OF_TESTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxParallelOfTests").getter(getter(RecommendationJobResourceLimit::maxParallelOfTests))
            .setter(setter(Builder::maxParallelOfTests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelOfTests").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_NUMBER_OF_TESTS_FIELD,
            MAX_PARALLEL_OF_TESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxNumberOfTests;

    private final Integer maxParallelOfTests;

    private RecommendationJobResourceLimit(BuilderImpl builder) {
        this.maxNumberOfTests = builder.maxNumberOfTests;
        this.maxParallelOfTests = builder.maxParallelOfTests;
    }

    /**
     * <p>
     * Defines the maximum number of load tests.
     * </p>
     * 
     * @return Defines the maximum number of load tests.
     */
    public final Integer maxNumberOfTests() {
        return maxNumberOfTests;
    }

    /**
     * <p>
     * Defines the maximum number of parallel load tests.
     * </p>
     * 
     * @return Defines the maximum number of parallel load tests.
     */
    public final Integer maxParallelOfTests() {
        return maxParallelOfTests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfTests());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelOfTests());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobResourceLimit)) {
            return false;
        }
        RecommendationJobResourceLimit other = (RecommendationJobResourceLimit) obj;
        return Objects.equals(maxNumberOfTests(), other.maxNumberOfTests())
                && Objects.equals(maxParallelOfTests(), other.maxParallelOfTests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobResourceLimit").add("MaxNumberOfTests", maxNumberOfTests())
                .add("MaxParallelOfTests", maxParallelOfTests()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfTests":
            return Optional.ofNullable(clazz.cast(maxNumberOfTests()));
        case "MaxParallelOfTests":
            return Optional.ofNullable(clazz.cast(maxParallelOfTests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxNumberOfTests", MAX_NUMBER_OF_TESTS_FIELD);
        map.put("MaxParallelOfTests", MAX_PARALLEL_OF_TESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobResourceLimit, T> g) {
        return obj -> g.apply((RecommendationJobResourceLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobResourceLimit> {
        /**
         * <p>
         * Defines the maximum number of load tests.
         * </p>
         * 
         * @param maxNumberOfTests
         *        Defines the maximum number of load tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfTests(Integer maxNumberOfTests);

        /**
         * <p>
         * Defines the maximum number of parallel load tests.
         * </p>
         * 
         * @param maxParallelOfTests
         *        Defines the maximum number of parallel load tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelOfTests(Integer maxParallelOfTests);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxNumberOfTests;

        private Integer maxParallelOfTests;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobResourceLimit model) {
            maxNumberOfTests(model.maxNumberOfTests);
            maxParallelOfTests(model.maxParallelOfTests);
        }

        public final Integer getMaxNumberOfTests() {
            return maxNumberOfTests;
        }

        public final void setMaxNumberOfTests(Integer maxNumberOfTests) {
            this.maxNumberOfTests = maxNumberOfTests;
        }

        @Override
        public final Builder maxNumberOfTests(Integer maxNumberOfTests) {
            this.maxNumberOfTests = maxNumberOfTests;
            return this;
        }

        public final Integer getMaxParallelOfTests() {
            return maxParallelOfTests;
        }

        public final void setMaxParallelOfTests(Integer maxParallelOfTests) {
            this.maxParallelOfTests = maxParallelOfTests;
        }

        @Override
        public final Builder maxParallelOfTests(Integer maxParallelOfTests) {
            this.maxParallelOfTests = maxParallelOfTests;
            return this;
        }

        @Override
        public RecommendationJobResourceLimit build() {
            return new RecommendationJobResourceLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
