/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a reserved capacity for the training plan.
 * </p>
 * <p>
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker
 * Training Plan, see
 * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> </code>
 * .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedCapacitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedCapacitySummary.Builder, ReservedCapacitySummary> {
    private static final SdkField<String> RESERVED_CAPACITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedCapacityArn").getter(getter(ReservedCapacitySummary::reservedCapacityArn))
            .setter(setter(Builder::reservedCapacityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ReservedCapacitySummary::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(ReservedCapacitySummary::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReservedCapacitySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ReservedCapacitySummary::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationHours").getter(getter(ReservedCapacitySummary::durationHours))
            .setter(setter(Builder::durationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()).build();

    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMinutes").getter(getter(ReservedCapacitySummary::durationMinutes))
            .setter(setter(Builder::durationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedCapacitySummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ReservedCapacitySummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CAPACITY_ARN_FIELD,
            INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, STATUS_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_HOURS_FIELD,
            DURATION_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reservedCapacityArn;

    private final String instanceType;

    private final Integer totalInstanceCount;

    private final String status;

    private final String availabilityZone;

    private final Long durationHours;

    private final Long durationMinutes;

    private final Instant startTime;

    private final Instant endTime;

    private ReservedCapacitySummary(BuilderImpl builder) {
        this.reservedCapacityArn = builder.reservedCapacityArn;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.status = builder.status;
        this.availabilityZone = builder.availabilityZone;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN); of the reserved capacity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN); of the reserved capacity.
     */
    public final String reservedCapacityArn() {
        return reservedCapacityArn;
    }

    /**
     * <p>
     * The instance type for the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the reserved capacity.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the reserved capacity.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances in the reserved capacity.
     * </p>
     * 
     * @return The total number of instances in the reserved capacity.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The current status of the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedCapacityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the reserved capacity.
     * @see ReservedCapacityStatus
     */
    public final ReservedCapacityStatus status() {
        return ReservedCapacityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedCapacityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the reserved capacity.
     * @see ReservedCapacityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The availability zone for the reserved capacity.
     * </p>
     * 
     * @return The availability zone for the reserved capacity.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of whole hours in the total duration for this reserved capacity.
     * </p>
     * 
     * @return The number of whole hours in the total duration for this reserved capacity.
     */
    public final Long durationHours() {
        return durationHours;
    }

    /**
     * <p>
     * The additional minutes beyond whole hours in the total duration for this reserved capacity.
     * </p>
     * 
     * @return The additional minutes beyond whole hours in the total duration for this reserved capacity.
     */
    public final Long durationMinutes() {
        return durationMinutes;
    }

    /**
     * <p>
     * The start time of the reserved capacity.
     * </p>
     * 
     * @return The start time of the reserved capacity.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the reserved capacity.
     * </p>
     * 
     * @return The end time of the reserved capacity.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedCapacityArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCapacitySummary)) {
            return false;
        }
        ReservedCapacitySummary other = (ReservedCapacitySummary) obj;
        return Objects.equals(reservedCapacityArn(), other.reservedCapacityArn())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(durationHours(), other.durationHours())
                && Objects.equals(durationMinutes(), other.durationMinutes()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedCapacitySummary").add("ReservedCapacityArn", reservedCapacityArn())
                .add("InstanceType", instanceTypeAsString()).add("TotalInstanceCount", totalInstanceCount())
                .add("Status", statusAsString()).add("AvailabilityZone", availabilityZone())
                .add("DurationHours", durationHours()).add("DurationMinutes", durationMinutes()).add("StartTime", startTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCapacityArn":
            return Optional.ofNullable(clazz.cast(reservedCapacityArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DurationHours":
            return Optional.ofNullable(clazz.cast(durationHours()));
        case "DurationMinutes":
            return Optional.ofNullable(clazz.cast(durationMinutes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedCapacityArn", RESERVED_CAPACITY_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedCapacitySummary, T> g) {
        return obj -> g.apply((ReservedCapacitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedCapacitySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN); of the reserved capacity.
         * </p>
         * 
         * @param reservedCapacityArn
         *        The Amazon Resource Name (ARN); of the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCapacityArn(String reservedCapacityArn);

        /**
         * <p>
         * The instance type for the reserved capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the reserved capacity.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for the reserved capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the reserved capacity.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The total number of instances in the reserved capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances in the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The current status of the reserved capacity.
         * </p>
         * 
         * @param status
         *        The current status of the reserved capacity.
         * @see ReservedCapacityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the reserved capacity.
         * </p>
         * 
         * @param status
         *        The current status of the reserved capacity.
         * @see ReservedCapacityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityStatus
         */
        Builder status(ReservedCapacityStatus status);

        /**
         * <p>
         * The availability zone for the reserved capacity.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone for the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of whole hours in the total duration for this reserved capacity.
         * </p>
         * 
         * @param durationHours
         *        The number of whole hours in the total duration for this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHours(Long durationHours);

        /**
         * <p>
         * The additional minutes beyond whole hours in the total duration for this reserved capacity.
         * </p>
         * 
         * @param durationMinutes
         *        The additional minutes beyond whole hours in the total duration for this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMinutes(Long durationMinutes);

        /**
         * <p>
         * The start time of the reserved capacity.
         * </p>
         * 
         * @param startTime
         *        The start time of the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the reserved capacity.
         * </p>
         * 
         * @param endTime
         *        The end time of the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String reservedCapacityArn;

        private String instanceType;

        private Integer totalInstanceCount;

        private String status;

        private String availabilityZone;

        private Long durationHours;

        private Long durationMinutes;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCapacitySummary model) {
            reservedCapacityArn(model.reservedCapacityArn);
            instanceType(model.instanceType);
            totalInstanceCount(model.totalInstanceCount);
            status(model.status);
            availabilityZone(model.availabilityZone);
            durationHours(model.durationHours);
            durationMinutes(model.durationMinutes);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getReservedCapacityArn() {
            return reservedCapacityArn;
        }

        public final void setReservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
        }

        @Override
        public final Builder reservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedCapacityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDurationHours() {
            return durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ReservedCapacitySummary build() {
            return new ReservedCapacitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
