/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing a recommended scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ScalingPolicy.Builder, ScalingPolicy> {
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_FIELD = SdkField
            .<TargetTrackingScalingPolicyConfiguration> builder(MarshallingType.SDK_POJO).memberName("TargetTracking")
            .getter(getter(ScalingPolicy::targetTracking)).setter(setter(Builder::targetTracking))
            .constructor(TargetTrackingScalingPolicyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTracking").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TRACKING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TargetTrackingScalingPolicyConfiguration targetTracking;

    private final Type type;

    private ScalingPolicy(BuilderImpl builder) {
        this.targetTracking = builder.targetTracking;
        this.type = builder.type;
    }

    /**
     * <p>
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * </p>
     * 
     * @return A target tracking scaling policy. Includes support for predefined or customized metrics.
     */
    public final TargetTrackingScalingPolicyConfiguration targetTracking() {
        return targetTracking;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTracking());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy) obj;
        return Objects.equals(targetTracking(), other.targetTracking());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingPolicy").add("TargetTracking", targetTracking()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetTracking":
            return Optional.ofNullable(clazz.cast(targetTracking()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #targetTracking()} initialized to the given value.
     *
     * <p>
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * </p>
     * 
     * @param targetTracking
     *        A target tracking scaling policy. Includes support for predefined or customized metrics.
     */
    public static ScalingPolicy fromTargetTracking(TargetTrackingScalingPolicyConfiguration targetTracking) {
        return builder().targetTracking(targetTracking).build();
    }

    /**
     * Create an instance of this class with {@link #targetTracking()} initialized to the given value.
     *
     * <p>
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * </p>
     * 
     * @param targetTracking
     *        A target tracking scaling policy. Includes support for predefined or customized metrics.
     */
    public static ScalingPolicy fromTargetTracking(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTracking) {
        TargetTrackingScalingPolicyConfiguration.Builder builder = TargetTrackingScalingPolicyConfiguration.builder();
        targetTracking.accept(builder);
        return fromTargetTracking(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetTracking", TARGET_TRACKING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingPolicy> {
        /**
         * <p>
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * 
         * @param targetTracking
         *        A target tracking scaling policy. Includes support for predefined or customized metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTracking(TargetTrackingScalingPolicyConfiguration targetTracking);

        /**
         * <p>
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TargetTrackingScalingPolicyConfiguration.Builder} avoiding the need to create one manually via
         * {@link TargetTrackingScalingPolicyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTrackingScalingPolicyConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #targetTracking(TargetTrackingScalingPolicyConfiguration)}.
         * 
         * @param targetTracking
         *        a consumer that will call methods on {@link TargetTrackingScalingPolicyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTracking(TargetTrackingScalingPolicyConfiguration)
         */
        default Builder targetTracking(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTracking) {
            return targetTracking(TargetTrackingScalingPolicyConfiguration.builder().applyMutation(targetTracking).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TargetTrackingScalingPolicyConfiguration targetTracking;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            targetTracking(model.targetTracking);
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTracking() {
            return targetTracking != null ? targetTracking.toBuilder() : null;
        }

        public final void setTargetTracking(TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTracking) {
            Object oldValue = this.targetTracking;
            this.targetTracking = targetTracking != null ? targetTracking.build() : null;
            handleUnionValueChange(Type.TARGET_TRACKING, oldValue, this.targetTracking);
        }

        @Override
        public final Builder targetTracking(TargetTrackingScalingPolicyConfiguration targetTracking) {
            Object oldValue = this.targetTracking;
            this.targetTracking = targetTracking;
            handleUnionValueChange(Type.TARGET_TRACKING, oldValue, this.targetTracking);
            return this;
        }

        @Override
        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ScalingPolicy#type()
     */
    public enum Type {
        TARGET_TRACKING,

        UNKNOWN_TO_SDK_VERSION
    }
}
