/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric for a scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingPolicyMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingPolicyMetric.Builder, ScalingPolicyMetric> {
    private static final SdkField<Integer> INVOCATIONS_PER_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvocationsPerInstance").getter(getter(ScalingPolicyMetric::invocationsPerInstance))
            .setter(setter(Builder::invocationsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsPerInstance").build())
            .build();

    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelLatency").getter(getter(ScalingPolicyMetric::modelLatency)).setter(setter(Builder::modelLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INVOCATIONS_PER_INSTANCE_FIELD, MODEL_LATENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer invocationsPerInstance;

    private final Integer modelLatency;

    private ScalingPolicyMetric(BuilderImpl builder) {
        this.invocationsPerInstance = builder.invocationsPerInstance;
        this.modelLatency = builder.modelLatency;
    }

    /**
     * <p>
     * The number of invocations sent to a model, normalized by <code>InstanceCount</code> in each ProductionVariant.
     * <code>1/numberOfInstances</code> is sent as the value on each request, where <code>numberOfInstances</code> is
     * the number of active instances for the ProductionVariant behind the endpoint at the time of the request.
     * </p>
     * 
     * @return The number of invocations sent to a model, normalized by <code>InstanceCount</code> in each
     *         ProductionVariant. <code>1/numberOfInstances</code> is sent as the value on each request, where
     *         <code>numberOfInstances</code> is the number of active instances for the ProductionVariant behind the
     *         endpoint at the time of the request.
     */
    public final Integer invocationsPerInstance() {
        return invocationsPerInstance;
    }

    /**
     * <p>
     * The interval of time taken by a model to respond as viewed from SageMaker. This interval includes the local
     * communication times taken to send the request and to fetch the response from the container of a model and the
     * time taken to complete the inference in the container.
     * </p>
     * 
     * @return The interval of time taken by a model to respond as viewed from SageMaker. This interval includes the
     *         local communication times taken to send the request and to fetch the response from the container of a
     *         model and the time taken to complete the inference in the container.
     */
    public final Integer modelLatency() {
        return modelLatency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(modelLatency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicyMetric)) {
            return false;
        }
        ScalingPolicyMetric other = (ScalingPolicyMetric) obj;
        return Objects.equals(invocationsPerInstance(), other.invocationsPerInstance())
                && Objects.equals(modelLatency(), other.modelLatency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingPolicyMetric").add("InvocationsPerInstance", invocationsPerInstance())
                .add("ModelLatency", modelLatency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationsPerInstance":
            return Optional.ofNullable(clazz.cast(invocationsPerInstance()));
        case "ModelLatency":
            return Optional.ofNullable(clazz.cast(modelLatency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvocationsPerInstance", INVOCATIONS_PER_INSTANCE_FIELD);
        map.put("ModelLatency", MODEL_LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicyMetric, T> g) {
        return obj -> g.apply((ScalingPolicyMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingPolicyMetric> {
        /**
         * <p>
         * The number of invocations sent to a model, normalized by <code>InstanceCount</code> in each
         * ProductionVariant. <code>1/numberOfInstances</code> is sent as the value on each request, where
         * <code>numberOfInstances</code> is the number of active instances for the ProductionVariant behind the
         * endpoint at the time of the request.
         * </p>
         * 
         * @param invocationsPerInstance
         *        The number of invocations sent to a model, normalized by <code>InstanceCount</code> in each
         *        ProductionVariant. <code>1/numberOfInstances</code> is sent as the value on each request, where
         *        <code>numberOfInstances</code> is the number of active instances for the ProductionVariant behind the
         *        endpoint at the time of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationsPerInstance(Integer invocationsPerInstance);

        /**
         * <p>
         * The interval of time taken by a model to respond as viewed from SageMaker. This interval includes the local
         * communication times taken to send the request and to fetch the response from the container of a model and the
         * time taken to complete the inference in the container.
         * </p>
         * 
         * @param modelLatency
         *        The interval of time taken by a model to respond as viewed from SageMaker. This interval includes the
         *        local communication times taken to send the request and to fetch the response from the container of a
         *        model and the time taken to complete the inference in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLatency(Integer modelLatency);
    }

    static final class BuilderImpl implements Builder {
        private Integer invocationsPerInstance;

        private Integer modelLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicyMetric model) {
            invocationsPerInstance(model.invocationsPerInstance);
            modelLatency(model.modelLatency);
        }

        public final Integer getInvocationsPerInstance() {
            return invocationsPerInstance;
        }

        public final void setInvocationsPerInstance(Integer invocationsPerInstance) {
            this.invocationsPerInstance = invocationsPerInstance;
        }

        @Override
        public final Builder invocationsPerInstance(Integer invocationsPerInstance) {
            this.invocationsPerInstance = invocationsPerInstance;
            return this;
        }

        public final Integer getModelLatency() {
            return modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        @Override
        public ScalingPolicyMetric build() {
            return new ScalingPolicyMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
