/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRequest extends SageMakerRequest implements ToCopyableBuilder<SearchRequest.Builder, SearchRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(SearchRequest::resourceAsString)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<SearchExpression> SEARCH_EXPRESSION_FIELD = SdkField
            .<SearchExpression> builder(MarshallingType.SDK_POJO).memberName("SearchExpression")
            .getter(getter(SearchRequest::searchExpression)).setter(setter(Builder::searchExpression))
            .constructor(SearchExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchExpression").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(SearchRequest::sortBy)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(SearchRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> CROSS_ACCOUNT_FILTER_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrossAccountFilterOption").getter(getter(SearchRequest::crossAccountFilterOptionAsString))
            .setter(setter(Builder::crossAccountFilterOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountFilterOption").build())
            .build();

    private static final SdkField<List<VisibilityConditions>> VISIBILITY_CONDITIONS_FIELD = SdkField
            .<List<VisibilityConditions>> builder(MarshallingType.LIST)
            .memberName("VisibilityConditions")
            .getter(getter(SearchRequest::visibilityConditions))
            .setter(setter(Builder::visibilityConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VisibilityConditions> builder(MarshallingType.SDK_POJO)
                                            .constructor(VisibilityConditions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            SEARCH_EXPRESSION_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD,
            CROSS_ACCOUNT_FILTER_OPTION_FIELD, VISIBILITY_CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resource;

    private final SearchExpression searchExpression;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final String crossAccountFilterOption;

    private final List<VisibilityConditions> visibilityConditions;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.searchExpression = builder.searchExpression;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.crossAccountFilterOption = builder.crossAccountFilterOption;
        this.visibilityConditions = builder.visibilityConditions;
    }

    /**
     * <p>
     * The name of the SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the SageMaker resource to search for.
     * @see ResourceType
     */
    public final ResourceType resource() {
        return ResourceType.fromValue(resource);
    }

    /**
     * <p>
     * The name of the SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the SageMaker resource to search for.
     * @see ResourceType
     */
    public final String resourceAsString() {
        return resource;
    }

    /**
     * <p>
     * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must
     * provide at least one subexpression, filter, or nested filter. The maximum number of recursive
     * <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a
     * <code>SearchExpression</code> object is 50.
     * </p>
     * 
     * @return A Boolean conditional statement. Resources must satisfy this condition to be included in search results.
     *         You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive
     *         <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in
     *         a <code>SearchExpression</code> object is 50.
     */
    public final SearchExpression searchExpression() {
        return searchExpression;
    }

    /**
     * <p>
     * The name of the resource property used to sort the <code>SearchResults</code>. The default is
     * <code>LastModifiedTime</code>.
     * </p>
     * 
     * @return The name of the resource property used to sort the <code>SearchResults</code>. The default is
     *         <code>LastModifiedTime</code>.
     */
    public final String sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>.
     * The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SearchSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
     *         <code>Descending</code>. The default is <code>Descending</code>.
     * @see SearchSortOrder
     */
    public final SearchSortOrder sortOrder() {
        return SearchSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>.
     * The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SearchSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
     *         <code>Descending</code>. The default is <code>Descending</code>.
     * @see SearchSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the response
     * includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next
     * <code>SearchRequest</code> to continue retrieving results.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the
     *         response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next
     *         <code>SearchRequest</code> to continue retrieving results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only include
     * resources made discoverable to you from other accounts. When the value is <code>"SameAccount"</code> or
     * <code>null</code> the search results will only include resources from your account. Default is <code>null</code>.
     * For more information on searching for resources made discoverable to your account, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
     * Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
     * <code>ResourceCatalog</code>s viewable is 1000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #crossAccountFilterOption} will return {@link CrossAccountFilterOption#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #crossAccountFilterOptionAsString}.
     * </p>
     * 
     * @return A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only
     *         include resources made discoverable to you from other accounts. When the value is
     *         <code>"SameAccount"</code> or <code>null</code> the search results will only include resources from your
     *         account. Default is <code>null</code>. For more information on searching for resources made discoverable
     *         to your account, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
     *         Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
     *         <code>ResourceCatalog</code>s viewable is 1000.
     * @see CrossAccountFilterOption
     */
    public final CrossAccountFilterOption crossAccountFilterOption() {
        return CrossAccountFilterOption.fromValue(crossAccountFilterOption);
    }

    /**
     * <p>
     * A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only include
     * resources made discoverable to you from other accounts. When the value is <code>"SameAccount"</code> or
     * <code>null</code> the search results will only include resources from your account. Default is <code>null</code>.
     * For more information on searching for resources made discoverable to your account, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
     * Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
     * <code>ResourceCatalog</code>s viewable is 1000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #crossAccountFilterOption} will return {@link CrossAccountFilterOption#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #crossAccountFilterOptionAsString}.
     * </p>
     * 
     * @return A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only
     *         include resources made discoverable to you from other accounts. When the value is
     *         <code>"SameAccount"</code> or <code>null</code> the search results will only include resources from your
     *         account. Default is <code>null</code>. For more information on searching for resources made discoverable
     *         to your account, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
     *         Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
     *         <code>ResourceCatalog</code>s viewable is 1000.
     * @see CrossAccountFilterOption
     */
    public final String crossAccountFilterOptionAsString() {
        return crossAccountFilterOption;
    }

    /**
     * For responses, this returns true if the service returned a value for the VisibilityConditions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVisibilityConditions() {
        return visibilityConditions != null && !(visibilityConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Limits the results of your search request to the resources that you can access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVisibilityConditions} method.
     * </p>
     * 
     * @return Limits the results of your search request to the resources that you can access.
     */
    public final List<VisibilityConditions> visibilityConditions() {
        return visibilityConditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchExpression());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountFilterOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVisibilityConditions() ? visibilityConditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest) obj;
        return Objects.equals(resourceAsString(), other.resourceAsString())
                && Objects.equals(searchExpression(), other.searchExpression()) && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(crossAccountFilterOptionAsString(), other.crossAccountFilterOptionAsString())
                && hasVisibilityConditions() == other.hasVisibilityConditions()
                && Objects.equals(visibilityConditions(), other.visibilityConditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRequest").add("Resource", resourceAsString()).add("SearchExpression", searchExpression())
                .add("SortBy", sortBy()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("CrossAccountFilterOption", crossAccountFilterOptionAsString())
                .add("VisibilityConditions", hasVisibilityConditions() ? visibilityConditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resourceAsString()));
        case "SearchExpression":
            return Optional.ofNullable(clazz.cast(searchExpression()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "CrossAccountFilterOption":
            return Optional.ofNullable(clazz.cast(crossAccountFilterOptionAsString()));
        case "VisibilityConditions":
            return Optional.ofNullable(clazz.cast(visibilityConditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Resource", RESOURCE_FIELD);
        map.put("SearchExpression", SEARCH_EXPRESSION_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("CrossAccountFilterOption", CROSS_ACCOUNT_FILTER_OPTION_FIELD);
        map.put("VisibilityConditions", VISIBILITY_CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRequest, T> g) {
        return obj -> g.apply((SearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchRequest> {
        /**
         * <p>
         * The name of the SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(String resource);

        /**
         * <p>
         * The name of the SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(ResourceType resource);

        /**
         * <p>
         * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You
         * must provide at least one subexpression, filter, or nested filter. The maximum number of recursive
         * <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a
         * <code>SearchExpression</code> object is 50.
         * </p>
         * 
         * @param searchExpression
         *        A Boolean conditional statement. Resources must satisfy this condition to be included in search
         *        results. You must provide at least one subexpression, filter, or nested filter. The maximum number of
         *        recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can
         *        be included in a <code>SearchExpression</code> object is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchExpression(SearchExpression searchExpression);

        /**
         * <p>
         * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You
         * must provide at least one subexpression, filter, or nested filter. The maximum number of recursive
         * <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a
         * <code>SearchExpression</code> object is 50.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchExpression.Builder} avoiding the
         * need to create one manually via {@link SearchExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #searchExpression(SearchExpression)}.
         * 
         * @param searchExpression
         *        a consumer that will call methods on {@link SearchExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchExpression(SearchExpression)
         */
        default Builder searchExpression(Consumer<SearchExpression.Builder> searchExpression) {
            return searchExpression(SearchExpression.builder().applyMutation(searchExpression).build());
        }

        /**
         * <p>
         * The name of the resource property used to sort the <code>SearchResults</code>. The default is
         * <code>LastModifiedTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The name of the resource property used to sort the <code>SearchResults</code>. The default is
         *        <code>LastModifiedTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         * <code>Descending</code>. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         *        <code>Descending</code>. The default is <code>Descending</code>.
         * @see SearchSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         * <code>Descending</code>. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         *        <code>Descending</code>. The default is <code>Descending</code>.
         * @see SearchSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchSortOrder
         */
        Builder sortOrder(SearchSortOrder sortOrder);

        /**
         * <p>
         * If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the
         * response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next
         * <code>SearchRequest</code> to continue retrieving results.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the
         *        response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next
         *        <code>SearchRequest</code> to continue retrieving results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only
         * include resources made discoverable to you from other accounts. When the value is <code>"SameAccount"</code>
         * or <code>null</code> the search results will only include resources from your account. Default is
         * <code>null</code>. For more information on searching for resources made discoverable to your account, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
         * Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
         * <code>ResourceCatalog</code>s viewable is 1000.
         * </p>
         * 
         * @param crossAccountFilterOption
         *        A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will
         *        only include resources made discoverable to you from other accounts. When the value is
         *        <code>"SameAccount"</code> or <code>null</code> the search results will only include resources from
         *        your account. Default is <code>null</code>. For more information on searching for resources made
         *        discoverable to your account, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html"
         *        > Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
         *        <code>ResourceCatalog</code>s viewable is 1000.
         * @see CrossAccountFilterOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrossAccountFilterOption
         */
        Builder crossAccountFilterOption(String crossAccountFilterOption);

        /**
         * <p>
         * A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only
         * include resources made discoverable to you from other accounts. When the value is <code>"SameAccount"</code>
         * or <code>null</code> the search results will only include resources from your account. Default is
         * <code>null</code>. For more information on searching for resources made discoverable to your account, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html">
         * Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
         * <code>ResourceCatalog</code>s viewable is 1000.
         * </p>
         * 
         * @param crossAccountFilterOption
         *        A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will
         *        only include resources made discoverable to you from other accounts. When the value is
         *        <code>"SameAccount"</code> or <code>null</code> the search results will only include resources from
         *        your account. Default is <code>null</code>. For more information on searching for resources made
         *        discoverable to your account, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html"
         *        > Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of
         *        <code>ResourceCatalog</code>s viewable is 1000.
         * @see CrossAccountFilterOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrossAccountFilterOption
         */
        Builder crossAccountFilterOption(CrossAccountFilterOption crossAccountFilterOption);

        /**
         * <p>
         * Limits the results of your search request to the resources that you can access.
         * </p>
         * 
         * @param visibilityConditions
         *        Limits the results of your search request to the resources that you can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConditions(Collection<VisibilityConditions> visibilityConditions);

        /**
         * <p>
         * Limits the results of your search request to the resources that you can access.
         * </p>
         * 
         * @param visibilityConditions
         *        Limits the results of your search request to the resources that you can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConditions(VisibilityConditions... visibilityConditions);

        /**
         * <p>
         * Limits the results of your search request to the resources that you can access.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.VisibilityConditions.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.VisibilityConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.VisibilityConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #visibilityConditions(List<VisibilityConditions>)}.
         * 
         * @param visibilityConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.VisibilityConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConditions(java.util.Collection<VisibilityConditions>)
         */
        Builder visibilityConditions(Consumer<VisibilityConditions.Builder>... visibilityConditions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String resource;

        private SearchExpression searchExpression;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private String crossAccountFilterOption;

        private List<VisibilityConditions> visibilityConditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            super(model);
            resource(model.resource);
            searchExpression(model.searchExpression);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            crossAccountFilterOption(model.crossAccountFilterOption);
            visibilityConditions(model.visibilityConditions);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public final Builder resource(ResourceType resource) {
            this.resource(resource == null ? null : resource.toString());
            return this;
        }

        public final SearchExpression.Builder getSearchExpression() {
            return searchExpression != null ? searchExpression.toBuilder() : null;
        }

        public final void setSearchExpression(SearchExpression.BuilderImpl searchExpression) {
            this.searchExpression = searchExpression != null ? searchExpression.build() : null;
        }

        @Override
        public final Builder searchExpression(SearchExpression searchExpression) {
            this.searchExpression = searchExpression;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SearchSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getCrossAccountFilterOption() {
            return crossAccountFilterOption;
        }

        public final void setCrossAccountFilterOption(String crossAccountFilterOption) {
            this.crossAccountFilterOption = crossAccountFilterOption;
        }

        @Override
        public final Builder crossAccountFilterOption(String crossAccountFilterOption) {
            this.crossAccountFilterOption = crossAccountFilterOption;
            return this;
        }

        @Override
        public final Builder crossAccountFilterOption(CrossAccountFilterOption crossAccountFilterOption) {
            this.crossAccountFilterOption(crossAccountFilterOption == null ? null : crossAccountFilterOption.toString());
            return this;
        }

        public final List<VisibilityConditions.Builder> getVisibilityConditions() {
            List<VisibilityConditions.Builder> result = VisibilityConditionsListCopier.copyToBuilder(this.visibilityConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVisibilityConditions(Collection<VisibilityConditions.BuilderImpl> visibilityConditions) {
            this.visibilityConditions = VisibilityConditionsListCopier.copyFromBuilder(visibilityConditions);
        }

        @Override
        public final Builder visibilityConditions(Collection<VisibilityConditions> visibilityConditions) {
            this.visibilityConditions = VisibilityConditionsListCopier.copy(visibilityConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visibilityConditions(VisibilityConditions... visibilityConditions) {
            visibilityConditions(Arrays.asList(visibilityConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visibilityConditions(Consumer<VisibilityConditions.Builder>... visibilityConditions) {
            visibilityConditions(Stream.of(visibilityConditions)
                    .map(c -> VisibilityConditions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
