/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The selective execution configuration applied to the pipeline run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectiveExecutionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SelectiveExecutionConfig.Builder, SelectiveExecutionConfig> {
    private static final SdkField<String> SOURCE_PIPELINE_EXECUTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourcePipelineExecutionArn")
            .getter(getter(SelectiveExecutionConfig::sourcePipelineExecutionArn))
            .setter(setter(Builder::sourcePipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePipelineExecutionArn").build())
            .build();

    private static final SdkField<List<SelectedStep>> SELECTED_STEPS_FIELD = SdkField
            .<List<SelectedStep>> builder(MarshallingType.LIST)
            .memberName("SelectedSteps")
            .getter(getter(SelectiveExecutionConfig::selectedSteps))
            .setter(setter(Builder::selectedSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SelectedStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(SelectedStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_PIPELINE_EXECUTION_ARN_FIELD, SELECTED_STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourcePipelineExecutionArn;

    private final List<SelectedStep> selectedSteps;

    private SelectiveExecutionConfig(BuilderImpl builder) {
        this.sourcePipelineExecutionArn = builder.sourcePipelineExecutionArn;
        this.selectedSteps = builder.selectedSteps;
    }

    /**
     * <p>
     * The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the
     * selected steps to run. The execution status of the pipeline can be either <code>Failed</code> or
     * <code>Success</code>.
     * </p>
     * <p>
     * This field is required if the steps you specify for <code>SelectedSteps</code> depend on output collaterals from
     * any non-specified pipeline steps. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html">Selective Execution for
     * Pipeline Steps</a>.
     * </p>
     * 
     * @return The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the
     *         selected steps to run. The execution status of the pipeline can be either <code>Failed</code> or
     *         <code>Success</code>.</p>
     *         <p>
     *         This field is required if the steps you specify for <code>SelectedSteps</code> depend on output
     *         collaterals from any non-specified pipeline steps. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html">Selective Execution
     *         for Pipeline Steps</a>.
     */
    public final String sourcePipelineExecutionArn() {
        return sourcePipelineExecutionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedSteps() {
        return selectedSteps != null && !(selectedSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedSteps} method.
     * </p>
     * 
     * @return A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be
     *         included.
     */
    public final List<SelectedStep> selectedSteps() {
        return selectedSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedSteps() ? selectedSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectiveExecutionConfig)) {
            return false;
        }
        SelectiveExecutionConfig other = (SelectiveExecutionConfig) obj;
        return Objects.equals(sourcePipelineExecutionArn(), other.sourcePipelineExecutionArn())
                && hasSelectedSteps() == other.hasSelectedSteps() && Objects.equals(selectedSteps(), other.selectedSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectiveExecutionConfig").add("SourcePipelineExecutionArn", sourcePipelineExecutionArn())
                .add("SelectedSteps", hasSelectedSteps() ? selectedSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourcePipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(sourcePipelineExecutionArn()));
        case "SelectedSteps":
            return Optional.ofNullable(clazz.cast(selectedSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourcePipelineExecutionArn", SOURCE_PIPELINE_EXECUTION_ARN_FIELD);
        map.put("SelectedSteps", SELECTED_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectiveExecutionConfig, T> g) {
        return obj -> g.apply((SelectiveExecutionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectiveExecutionConfig> {
        /**
         * <p>
         * The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the
         * selected steps to run. The execution status of the pipeline can be either <code>Failed</code> or
         * <code>Success</code>.
         * </p>
         * <p>
         * This field is required if the steps you specify for <code>SelectedSteps</code> depend on output collaterals
         * from any non-specified pipeline steps. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html">Selective Execution for
         * Pipeline Steps</a>.
         * </p>
         * 
         * @param sourcePipelineExecutionArn
         *        The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for
         *        the selected steps to run. The execution status of the pipeline can be either <code>Failed</code> or
         *        <code>Success</code>.</p>
         *        <p>
         *        This field is required if the steps you specify for <code>SelectedSteps</code> depend on output
         *        collaterals from any non-specified pipeline steps. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html">Selective Execution
         *        for Pipeline Steps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePipelineExecutionArn(String sourcePipelineExecutionArn);

        /**
         * <p>
         * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
         * </p>
         * 
         * @param selectedSteps
         *        A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be
         *        included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSteps(Collection<SelectedStep> selectedSteps);

        /**
         * <p>
         * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
         * </p>
         * 
         * @param selectedSteps
         *        A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be
         *        included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSteps(SelectedStep... selectedSteps);

        /**
         * <p>
         * A list of pipeline steps to run. All step(s) in all path(s) between two selected steps should be included.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.SelectedStep.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.SelectedStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.SelectedStep.Builder#build()} is called immediately
         * and its result is passed to {@link #selectedSteps(List<SelectedStep>)}.
         * 
         * @param selectedSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.SelectedStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedSteps(java.util.Collection<SelectedStep>)
         */
        Builder selectedSteps(Consumer<SelectedStep.Builder>... selectedSteps);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePipelineExecutionArn;

        private List<SelectedStep> selectedSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectiveExecutionConfig model) {
            sourcePipelineExecutionArn(model.sourcePipelineExecutionArn);
            selectedSteps(model.selectedSteps);
        }

        public final String getSourcePipelineExecutionArn() {
            return sourcePipelineExecutionArn;
        }

        public final void setSourcePipelineExecutionArn(String sourcePipelineExecutionArn) {
            this.sourcePipelineExecutionArn = sourcePipelineExecutionArn;
        }

        @Override
        public final Builder sourcePipelineExecutionArn(String sourcePipelineExecutionArn) {
            this.sourcePipelineExecutionArn = sourcePipelineExecutionArn;
            return this;
        }

        public final List<SelectedStep.Builder> getSelectedSteps() {
            List<SelectedStep.Builder> result = SelectedStepListCopier.copyToBuilder(this.selectedSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedSteps(Collection<SelectedStep.BuilderImpl> selectedSteps) {
            this.selectedSteps = SelectedStepListCopier.copyFromBuilder(selectedSteps);
        }

        @Override
        public final Builder selectedSteps(Collection<SelectedStep> selectedSteps) {
            this.selectedSteps = SelectedStepListCopier.copy(selectedSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSteps(SelectedStep... selectedSteps) {
            selectedSteps(Arrays.asList(selectedSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSteps(Consumer<SelectedStep.Builder>... selectedSteps) {
            selectedSteps(Stream.of(selectedSteps).map(c -> SelectedStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SelectiveExecutionConfig build() {
            return new SelectiveExecutionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
