/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about attribute-based access control (ABAC) for a training job. The session chaining
 * configuration uses Amazon Security Token Service (STS) for your training job to request temporary, limited-privilege
 * credentials to tenants. For more information, see <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/dg/model-access-training-data.html#model-access-training-data-abac"
 * >Attribute-based access control (ABAC) for multi-tenancy training</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionChainingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionChainingConfig.Builder, SessionChainingConfig> {
    private static final SdkField<Boolean> ENABLE_SESSION_TAG_CHAINING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableSessionTagChaining")
            .getter(getter(SessionChainingConfig::enableSessionTagChaining)).setter(setter(Builder::enableSessionTagChaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSessionTagChaining").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_SESSION_TAG_CHAINING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableSessionTagChaining;

    private SessionChainingConfig(BuilderImpl builder) {
        this.enableSessionTagChaining = builder.enableSessionTagChaining;
    }

    /**
     * <p>
     * Set to <code>True</code> to allow SageMaker to extract session tags from a training job creation role and reuse
     * these tags when assuming the training job execution role.
     * </p>
     * 
     * @return Set to <code>True</code> to allow SageMaker to extract session tags from a training job creation role and
     *         reuse these tags when assuming the training job execution role.
     */
    public final Boolean enableSessionTagChaining() {
        return enableSessionTagChaining;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableSessionTagChaining());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionChainingConfig)) {
            return false;
        }
        SessionChainingConfig other = (SessionChainingConfig) obj;
        return Objects.equals(enableSessionTagChaining(), other.enableSessionTagChaining());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionChainingConfig").add("EnableSessionTagChaining", enableSessionTagChaining()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableSessionTagChaining":
            return Optional.ofNullable(clazz.cast(enableSessionTagChaining()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableSessionTagChaining", ENABLE_SESSION_TAG_CHAINING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionChainingConfig, T> g) {
        return obj -> g.apply((SessionChainingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionChainingConfig> {
        /**
         * <p>
         * Set to <code>True</code> to allow SageMaker to extract session tags from a training job creation role and
         * reuse these tags when assuming the training job execution role.
         * </p>
         * 
         * @param enableSessionTagChaining
         *        Set to <code>True</code> to allow SageMaker to extract session tags from a training job creation role
         *        and reuse these tags when assuming the training job execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSessionTagChaining(Boolean enableSessionTagChaining);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableSessionTagChaining;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionChainingConfig model) {
            enableSessionTagChaining(model.enableSessionTagChaining);
        }

        public final Boolean getEnableSessionTagChaining() {
            return enableSessionTagChaining;
        }

        public final void setEnableSessionTagChaining(Boolean enableSessionTagChaining) {
            this.enableSessionTagChaining = enableSessionTagChaining;
        }

        @Override
        public final Builder enableSessionTagChaining(Boolean enableSessionTagChaining) {
            this.enableSessionTagChaining = enableSessionTagChaining;
            return this;
        }

        @Override
        public SessionChainingConfig build() {
            return new SessionChainingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
