/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and sampling percentage of a shadow variant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShadowModelVariantConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ShadowModelVariantConfig.Builder, ShadowModelVariantConfig> {
    private static final SdkField<String> SHADOW_MODEL_VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShadowModelVariantName").getter(getter(ShadowModelVariantConfig::shadowModelVariantName))
            .setter(setter(Builder::shadowModelVariantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModelVariantName").build())
            .build();

    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SamplingPercentage").getter(getter(ShadowModelVariantConfig::samplingPercentage))
            .setter(setter(Builder::samplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SHADOW_MODEL_VARIANT_NAME_FIELD, SAMPLING_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shadowModelVariantName;

    private final Integer samplingPercentage;

    private ShadowModelVariantConfig(BuilderImpl builder) {
        this.shadowModelVariantName = builder.shadowModelVariantName;
        this.samplingPercentage = builder.samplingPercentage;
    }

    /**
     * <p>
     * The name of the shadow variant.
     * </p>
     * 
     * @return The name of the shadow variant.
     */
    public final String shadowModelVariantName() {
        return shadowModelVariantName;
    }

    /**
     * <p>
     * The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow
     * variant.
     * </p>
     * 
     * @return The percentage of inference requests that Amazon SageMaker replicates from the production variant to the
     *         shadow variant.
     */
    public final Integer samplingPercentage() {
        return samplingPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shadowModelVariantName());
        hashCode = 31 * hashCode + Objects.hashCode(samplingPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowModelVariantConfig)) {
            return false;
        }
        ShadowModelVariantConfig other = (ShadowModelVariantConfig) obj;
        return Objects.equals(shadowModelVariantName(), other.shadowModelVariantName())
                && Objects.equals(samplingPercentage(), other.samplingPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShadowModelVariantConfig").add("ShadowModelVariantName", shadowModelVariantName())
                .add("SamplingPercentage", samplingPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShadowModelVariantName":
            return Optional.ofNullable(clazz.cast(shadowModelVariantName()));
        case "SamplingPercentage":
            return Optional.ofNullable(clazz.cast(samplingPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShadowModelVariantName", SHADOW_MODEL_VARIANT_NAME_FIELD);
        map.put("SamplingPercentage", SAMPLING_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShadowModelVariantConfig, T> g) {
        return obj -> g.apply((ShadowModelVariantConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShadowModelVariantConfig> {
        /**
         * <p>
         * The name of the shadow variant.
         * </p>
         * 
         * @param shadowModelVariantName
         *        The name of the shadow variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowModelVariantName(String shadowModelVariantName);

        /**
         * <p>
         * The percentage of inference requests that Amazon SageMaker replicates from the production variant to the
         * shadow variant.
         * </p>
         * 
         * @param samplingPercentage
         *        The percentage of inference requests that Amazon SageMaker replicates from the production variant to
         *        the shadow variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingPercentage(Integer samplingPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String shadowModelVariantName;

        private Integer samplingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShadowModelVariantConfig model) {
            shadowModelVariantName(model.shadowModelVariantName);
            samplingPercentage(model.samplingPercentage);
        }

        public final String getShadowModelVariantName() {
            return shadowModelVariantName;
        }

        public final void setShadowModelVariantName(String shadowModelVariantName) {
            this.shadowModelVariantName = shadowModelVariantName;
        }

        @Override
        public final Builder shadowModelVariantName(String shadowModelVariantName) {
            this.shadowModelVariantName = shadowModelVariantName;
            return this;
        }

        public final Integer getSamplingPercentage() {
            return samplingPercentage;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        @Override
        public ShadowModelVariantConfig build() {
            return new ShadowModelVariantConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
