/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The application settings for a Code Editor space.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceCodeEditorAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SpaceCodeEditorAppSettings.Builder, SpaceCodeEditorAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(SpaceCodeEditorAppSettings::defaultResourceSpec)).setter(setter(Builder::defaultResourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final SdkField<SpaceAppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField
            .<SpaceAppLifecycleManagement> builder(MarshallingType.SDK_POJO).memberName("AppLifecycleManagement")
            .getter(getter(SpaceCodeEditorAppSettings::appLifecycleManagement)).setter(setter(Builder::appLifecycleManagement))
            .constructor(SpaceAppLifecycleManagement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD,
            APP_LIFECYCLE_MANAGEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourceSpec defaultResourceSpec;

    private final SpaceAppLifecycleManagement appLifecycleManagement;

    private SpaceCodeEditorAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.appLifecycleManagement = builder.appLifecycleManagement;
    }

    /**
     * Returns the value of the DefaultResourceSpec property for this object.
     * 
     * @return The value of the DefaultResourceSpec property for this object.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    /**
     * <p>
     * Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
     * </p>
     * 
     * @return Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
     */
    public final SpaceAppLifecycleManagement appLifecycleManagement() {
        return appLifecycleManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(appLifecycleManagement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceCodeEditorAppSettings)) {
            return false;
        }
        SpaceCodeEditorAppSettings other = (SpaceCodeEditorAppSettings) obj;
        return Objects.equals(defaultResourceSpec(), other.defaultResourceSpec())
                && Objects.equals(appLifecycleManagement(), other.appLifecycleManagement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceCodeEditorAppSettings").add("DefaultResourceSpec", defaultResourceSpec())
                .add("AppLifecycleManagement", appLifecycleManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        case "AppLifecycleManagement":
            return Optional.ofNullable(clazz.cast(appLifecycleManagement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
        map.put("AppLifecycleManagement", APP_LIFECYCLE_MANAGEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceCodeEditorAppSettings, T> g) {
        return obj -> g.apply((SpaceCodeEditorAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceCodeEditorAppSettings> {
        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * @param defaultResourceSpec
         *        The new value for the DefaultResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }

        /**
         * <p>
         * Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
         * </p>
         * 
         * @param appLifecycleManagement
         *        Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement);

        /**
         * <p>
         * Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceAppLifecycleManagement.Builder}
         * avoiding the need to create one manually via {@link SpaceAppLifecycleManagement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceAppLifecycleManagement.Builder#build()} is called
         * immediately and its result is passed to {@link #appLifecycleManagement(SpaceAppLifecycleManagement)}.
         * 
         * @param appLifecycleManagement
         *        a consumer that will call methods on {@link SpaceAppLifecycleManagement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appLifecycleManagement(SpaceAppLifecycleManagement)
         */
        default Builder appLifecycleManagement(Consumer<SpaceAppLifecycleManagement.Builder> appLifecycleManagement) {
            return appLifecycleManagement(SpaceAppLifecycleManagement.builder().applyMutation(appLifecycleManagement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceSpec defaultResourceSpec;

        private SpaceAppLifecycleManagement appLifecycleManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceCodeEditorAppSettings model) {
            defaultResourceSpec(model.defaultResourceSpec);
            appLifecycleManagement(model.appLifecycleManagement);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final SpaceAppLifecycleManagement.Builder getAppLifecycleManagement() {
            return appLifecycleManagement != null ? appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(SpaceAppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        @Override
        public SpaceCodeEditorAppSettings build() {
            return new SpaceCodeEditorAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
