/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies summary information about the space settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SpaceSettingsSummary.Builder, SpaceSettingsSummary> {
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppType").getter(getter(SpaceSettingsSummary::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<SpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField
            .<SpaceStorageSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceStorageSettings")
            .getter(getter(SpaceSettingsSummary::spaceStorageSettings)).setter(setter(Builder::spaceStorageSettings))
            .constructor(SpaceStorageSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_TYPE_FIELD,
            SPACE_STORAGE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appType;

    private final SpaceStorageSettings spaceStorageSettings;

    private SpaceSettingsSummary(BuilderImpl builder) {
        this.appType = builder.appType;
        this.spaceStorageSettings = builder.spaceStorageSettings;
    }

    /**
     * <p>
     * The type of app created within the space.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app created within the space.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app created within the space.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app created within the space.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The storage settings for a space.
     * </p>
     * 
     * @return The storage settings for a space.
     */
    public final SpaceStorageSettings spaceStorageSettings() {
        return spaceStorageSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spaceStorageSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettingsSummary)) {
            return false;
        }
        SpaceSettingsSummary other = (SpaceSettingsSummary) obj;
        return Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(spaceStorageSettings(), other.spaceStorageSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceSettingsSummary").add("AppType", appTypeAsString())
                .add("SpaceStorageSettings", spaceStorageSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "SpaceStorageSettings":
            return Optional.ofNullable(clazz.cast(spaceStorageSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppType", APP_TYPE_FIELD);
        map.put("SpaceStorageSettings", SPACE_STORAGE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceSettingsSummary, T> g) {
        return obj -> g.apply((SpaceSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceSettingsSummary> {
        /**
         * <p>
         * The type of app created within the space.
         * </p>
         * 
         * @param appType
         *        The type of app created within the space.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app created within the space.
         * </p>
         * 
         * @param appType
         *        The type of app created within the space.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The storage settings for a space.
         * </p>
         * 
         * @param spaceStorageSettings
         *        The storage settings for a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings);

        /**
         * <p>
         * The storage settings for a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceStorageSettings.Builder} avoiding
         * the need to create one manually via {@link SpaceStorageSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceStorageSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #spaceStorageSettings(SpaceStorageSettings)}.
         * 
         * @param spaceStorageSettings
         *        a consumer that will call methods on {@link SpaceStorageSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceStorageSettings(SpaceStorageSettings)
         */
        default Builder spaceStorageSettings(Consumer<SpaceStorageSettings.Builder> spaceStorageSettings) {
            return spaceStorageSettings(SpaceStorageSettings.builder().applyMutation(spaceStorageSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appType;

        private SpaceStorageSettings spaceStorageSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceSettingsSummary model) {
            appType(model.appType);
            spaceStorageSettings(model.spaceStorageSettings);
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final SpaceStorageSettings.Builder getSpaceStorageSettings() {
            return spaceStorageSettings != null ? spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(SpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        @Override
        public SpaceSettingsSummary build() {
            return new SpaceSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
