/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlflowTrackingServerRequest extends SageMakerRequest implements
        ToCopyableBuilder<StartMlflowTrackingServerRequest.Builder, StartMlflowTrackingServerRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(StartMlflowTrackingServerRequest::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerName;

    private StartMlflowTrackingServerRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
    }

    /**
     * <p>
     * The name of the tracking server to start.
     * </p>
     * 
     * @return The name of the tracking server to start.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlflowTrackingServerRequest)) {
            return false;
        }
        StartMlflowTrackingServerRequest other = (StartMlflowTrackingServerRequest) obj;
        return Objects.equals(trackingServerName(), other.trackingServerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMlflowTrackingServerRequest").add("TrackingServerName", trackingServerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMlflowTrackingServerRequest, T> g) {
        return obj -> g.apply((StartMlflowTrackingServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlflowTrackingServerRequest> {
        /**
         * <p>
         * The name of the tracking server to start.
         * </p>
         * 
         * @param trackingServerName
         *        The name of the tracking server to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trackingServerName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlflowTrackingServerRequest model) {
            super(model);
            trackingServerName(model.trackingServerName);
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlflowTrackingServerRequest build() {
            return new StartMlflowTrackingServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
