/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A target tracking scaling policy. Includes support for predefined or customized metrics.
 * </p>
 * <p>
 * When using the <a
 * href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html">PutScalingPolicy
 * </a> API, this parameter is required when you are creating a policy with the policy type
 * <code>TargetTrackingScaling</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingScalingPolicyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingScalingPolicyConfiguration.Builder, TargetTrackingScalingPolicyConfiguration> {
    private static final SdkField<MetricSpecification> METRIC_SPECIFICATION_FIELD = SdkField
            .<MetricSpecification> builder(MarshallingType.SDK_POJO).memberName("MetricSpecification")
            .getter(getter(TargetTrackingScalingPolicyConfiguration::metricSpecification))
            .setter(setter(Builder::metricSpecification)).constructor(MetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSpecification").build())
            .build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(TargetTrackingScalingPolicyConfiguration::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SPECIFICATION_FIELD,
            TARGET_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MetricSpecification metricSpecification;

    private final Double targetValue;

    private TargetTrackingScalingPolicyConfiguration(BuilderImpl builder) {
        this.metricSpecification = builder.metricSpecification;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * An object containing information about a metric.
     * </p>
     * 
     * @return An object containing information about a metric.
     */
    public final MetricSpecification metricSpecification() {
        return metricSpecification;
    }

    /**
     * <p>
     * The recommended target value to specify for the metric when creating a scaling policy.
     * </p>
     * 
     * @return The recommended target value to specify for the metric when creating a scaling policy.
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicyConfiguration)) {
            return false;
        }
        TargetTrackingScalingPolicyConfiguration other = (TargetTrackingScalingPolicyConfiguration) obj;
        return Objects.equals(metricSpecification(), other.metricSpecification())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingScalingPolicyConfiguration").add("MetricSpecification", metricSpecification())
                .add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSpecification":
            return Optional.ofNullable(clazz.cast(metricSpecification()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricSpecification", METRIC_SPECIFICATION_FIELD);
        map.put("TargetValue", TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
        /**
         * <p>
         * An object containing information about a metric.
         * </p>
         * 
         * @param metricSpecification
         *        An object containing information about a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSpecification(MetricSpecification metricSpecification);

        /**
         * <p>
         * An object containing information about a metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricSpecification.Builder} avoiding the
         * need to create one manually via {@link MetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #metricSpecification(MetricSpecification)}.
         * 
         * @param metricSpecification
         *        a consumer that will call methods on {@link MetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSpecification(MetricSpecification)
         */
        default Builder metricSpecification(Consumer<MetricSpecification.Builder> metricSpecification) {
            return metricSpecification(MetricSpecification.builder().applyMutation(metricSpecification).build());
        }

        /**
         * <p>
         * The recommended target value to specify for the metric when creating a scaling policy.
         * </p>
         * 
         * @param targetValue
         *        The recommended target value to specify for the metric when creating a scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private MetricSpecification metricSpecification;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicyConfiguration model) {
            metricSpecification(model.metricSpecification);
            targetValue(model.targetValue);
        }

        public final MetricSpecification.Builder getMetricSpecification() {
            return metricSpecification != null ? metricSpecification.toBuilder() : null;
        }

        public final void setMetricSpecification(MetricSpecification.BuilderImpl metricSpecification) {
            this.metricSpecification = metricSpecification != null ? metricSpecification.build() : null;
        }

        @Override
        public final Builder metricSpecification(MetricSpecification metricSpecification) {
            this.metricSpecification = metricSpecification;
            return this;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public TargetTrackingScalingPolicyConfiguration build() {
            return new TargetTrackingScalingPolicyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
