/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Time series forecast settings for the SageMaker Canvas application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesForecastingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesForecastingSettings.Builder, TimeSeriesForecastingSettings> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TimeSeriesForecastingSettings::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AMAZON_FORECAST_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonForecastRoleArn").getter(getter(TimeSeriesForecastingSettings::amazonForecastRoleArn))
            .setter(setter(Builder::amazonForecastRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonForecastRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            AMAZON_FORECAST_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String amazonForecastRoleArn;

    private TimeSeriesForecastingSettings(BuilderImpl builder) {
        this.status = builder.status;
        this.amazonForecastRoleArn = builder.amazonForecastRoleArn;
    }

    /**
     * <p>
     * Describes whether time series forecasting is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether time series forecasting is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final FeatureStatus status() {
        return FeatureStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes whether time series forecasting is enabled or disabled in the Canvas application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes whether time series forecasting is enabled or disabled in the Canvas application.
     * @see FeatureStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses the
     * execution role specified in the <code>UserProfile</code> that launches the Canvas application. If an execution
     * role is not specified in the <code>UserProfile</code>, Canvas uses the execution role specified in the Domain
     * that owns the <code>UserProfile</code>. To allow time series forecasting, this IAM role should have the <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess"
     * > AmazonSageMakerCanvasForecastAccess</a> policy attached and <code>forecast.amazonaws.com</code> added in the
     * trust relationship as a service principal.
     * </p>
     * 
     * @return The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses
     *         the execution role specified in the <code>UserProfile</code> that launches the Canvas application. If an
     *         execution role is not specified in the <code>UserProfile</code>, Canvas uses the execution role specified
     *         in the Domain that owns the <code>UserProfile</code>. To allow time series forecasting, this IAM role
     *         should have the <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess"
     *         > AmazonSageMakerCanvasForecastAccess</a> policy attached and <code>forecast.amazonaws.com</code> added
     *         in the trust relationship as a service principal.
     */
    public final String amazonForecastRoleArn() {
        return amazonForecastRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonForecastRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesForecastingSettings)) {
            return false;
        }
        TimeSeriesForecastingSettings other = (TimeSeriesForecastingSettings) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(amazonForecastRoleArn(), other.amazonForecastRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesForecastingSettings").add("Status", statusAsString())
                .add("AmazonForecastRoleArn", amazonForecastRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AmazonForecastRoleArn":
            return Optional.ofNullable(clazz.cast(amazonForecastRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("AmazonForecastRoleArn", AMAZON_FORECAST_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesForecastingSettings, T> g) {
        return obj -> g.apply((TimeSeriesForecastingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesForecastingSettings> {
        /**
         * <p>
         * Describes whether time series forecasting is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether time series forecasting is enabled or disabled in the Canvas application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes whether time series forecasting is enabled or disabled in the Canvas application.
         * </p>
         * 
         * @param status
         *        Describes whether time series forecasting is enabled or disabled in the Canvas application.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(FeatureStatus status);

        /**
         * <p>
         * The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses the
         * execution role specified in the <code>UserProfile</code> that launches the Canvas application. If an
         * execution role is not specified in the <code>UserProfile</code>, Canvas uses the execution role specified in
         * the Domain that owns the <code>UserProfile</code>. To allow time series forecasting, this IAM role should
         * have the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess"
         * > AmazonSageMakerCanvasForecastAccess</a> policy attached and <code>forecast.amazonaws.com</code> added in
         * the trust relationship as a service principal.
         * </p>
         * 
         * @param amazonForecastRoleArn
         *        The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas
         *        uses the execution role specified in the <code>UserProfile</code> that launches the Canvas
         *        application. If an execution role is not specified in the <code>UserProfile</code>, Canvas uses the
         *        execution role specified in the Domain that owns the <code>UserProfile</code>. To allow time series
         *        forecasting, this IAM role should have the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess"
         *        > AmazonSageMakerCanvasForecastAccess</a> policy attached and <code>forecast.amazonaws.com</code>
         *        added in the trust relationship as a service principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonForecastRoleArn(String amazonForecastRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String amazonForecastRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesForecastingSettings model) {
            status(model.status);
            amazonForecastRoleArn(model.amazonForecastRoleArn);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAmazonForecastRoleArn() {
            return amazonForecastRoleArn;
        }

        public final void setAmazonForecastRoleArn(String amazonForecastRoleArn) {
            this.amazonForecastRoleArn = amazonForecastRoleArn;
        }

        @Override
        public final Builder amazonForecastRoleArn(String amazonForecastRoleArn) {
            this.amazonForecastRoleArn = amazonForecastRoleArn;
            return this;
        }

        @Override
        public TimeSeriesForecastingSettings build() {
            return new TimeSeriesForecastingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
