/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the tracking server to list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingServerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackingServerSummary.Builder, TrackingServerSummary> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerArn").getter(getter(TrackingServerSummary::trackingServerArn))
            .setter(setter(Builder::trackingServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerArn").build()).build();

    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(TrackingServerSummary::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TrackingServerSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TrackingServerSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> TRACKING_SERVER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerStatus").getter(getter(TrackingServerSummary::trackingServerStatusAsString))
            .setter(setter(Builder::trackingServerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerStatus").build())
            .build();

    private static final SdkField<String> IS_ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsActive").getter(getter(TrackingServerSummary::isActiveAsString)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActive").build()).build();

    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlflowVersion").getter(getter(TrackingServerSummary::mlflowVersion))
            .setter(setter(Builder::mlflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD,
            TRACKING_SERVER_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRACKING_SERVER_STATUS_FIELD,
            IS_ACTIVE_FIELD, MLFLOW_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trackingServerArn;

    private final String trackingServerName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String trackingServerStatus;

    private final String isActive;

    private final String mlflowVersion;

    private TrackingServerSummary(BuilderImpl builder) {
        this.trackingServerArn = builder.trackingServerArn;
        this.trackingServerName = builder.trackingServerName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trackingServerStatus = builder.trackingServerStatus;
        this.isActive = builder.isActive;
        this.mlflowVersion = builder.mlflowVersion;
    }

    /**
     * <p>
     * The ARN of a listed tracking server.
     * </p>
     * 
     * @return The ARN of a listed tracking server.
     */
    public final String trackingServerArn() {
        return trackingServerArn;
    }

    /**
     * <p>
     * The name of a listed tracking server.
     * </p>
     * 
     * @return The name of a listed tracking server.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    /**
     * <p>
     * The creation time of a listed tracking server.
     * </p>
     * 
     * @return The creation time of a listed tracking server.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time of a listed tracking server.
     * </p>
     * 
     * @return The last modified time of a listed tracking server.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The creation status of a listed tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return The creation status of a listed tracking server.
     * @see TrackingServerStatus
     */
    public final TrackingServerStatus trackingServerStatus() {
        return TrackingServerStatus.fromValue(trackingServerStatus);
    }

    /**
     * <p>
     * The creation status of a listed tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return The creation status of a listed tracking server.
     * @see TrackingServerStatus
     */
    public final String trackingServerStatusAsString() {
        return trackingServerStatus;
    }

    /**
     * <p>
     * The activity status of a listed tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isActive} will
     * return {@link IsTrackingServerActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isActiveAsString}.
     * </p>
     * 
     * @return The activity status of a listed tracking server.
     * @see IsTrackingServerActive
     */
    public final IsTrackingServerActive isActive() {
        return IsTrackingServerActive.fromValue(isActive);
    }

    /**
     * <p>
     * The activity status of a listed tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isActive} will
     * return {@link IsTrackingServerActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isActiveAsString}.
     * </p>
     * 
     * @return The activity status of a listed tracking server.
     * @see IsTrackingServerActive
     */
    public final String isActiveAsString() {
        return isActive;
    }

    /**
     * <p>
     * The MLflow version used for a listed tracking server.
     * </p>
     * 
     * @return The MLflow version used for a listed tracking server.
     */
    public final String mlflowVersion() {
        return mlflowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isActiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlflowVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingServerSummary)) {
            return false;
        }
        TrackingServerSummary other = (TrackingServerSummary) obj;
        return Objects.equals(trackingServerArn(), other.trackingServerArn())
                && Objects.equals(trackingServerName(), other.trackingServerName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(trackingServerStatusAsString(), other.trackingServerStatusAsString())
                && Objects.equals(isActiveAsString(), other.isActiveAsString())
                && Objects.equals(mlflowVersion(), other.mlflowVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackingServerSummary").add("TrackingServerArn", trackingServerArn())
                .add("TrackingServerName", trackingServerName()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("TrackingServerStatus", trackingServerStatusAsString())
                .add("IsActive", isActiveAsString()).add("MlflowVersion", mlflowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerArn":
            return Optional.ofNullable(clazz.cast(trackingServerArn()));
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TrackingServerStatus":
            return Optional.ofNullable(clazz.cast(trackingServerStatusAsString()));
        case "IsActive":
            return Optional.ofNullable(clazz.cast(isActiveAsString()));
        case "MlflowVersion":
            return Optional.ofNullable(clazz.cast(mlflowVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerArn", TRACKING_SERVER_ARN_FIELD);
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("TrackingServerStatus", TRACKING_SERVER_STATUS_FIELD);
        map.put("IsActive", IS_ACTIVE_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrackingServerSummary, T> g) {
        return obj -> g.apply((TrackingServerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackingServerSummary> {
        /**
         * <p>
         * The ARN of a listed tracking server.
         * </p>
         * 
         * @param trackingServerArn
         *        The ARN of a listed tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerArn(String trackingServerArn);

        /**
         * <p>
         * The name of a listed tracking server.
         * </p>
         * 
         * @param trackingServerName
         *        The name of a listed tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        /**
         * <p>
         * The creation time of a listed tracking server.
         * </p>
         * 
         * @param creationTime
         *        The creation time of a listed tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time of a listed tracking server.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time of a listed tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The creation status of a listed tracking server.
         * </p>
         * 
         * @param trackingServerStatus
         *        The creation status of a listed tracking server.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(String trackingServerStatus);

        /**
         * <p>
         * The creation status of a listed tracking server.
         * </p>
         * 
         * @param trackingServerStatus
         *        The creation status of a listed tracking server.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(TrackingServerStatus trackingServerStatus);

        /**
         * <p>
         * The activity status of a listed tracking server.
         * </p>
         * 
         * @param isActive
         *        The activity status of a listed tracking server.
         * @see IsTrackingServerActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsTrackingServerActive
         */
        Builder isActive(String isActive);

        /**
         * <p>
         * The activity status of a listed tracking server.
         * </p>
         * 
         * @param isActive
         *        The activity status of a listed tracking server.
         * @see IsTrackingServerActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsTrackingServerActive
         */
        Builder isActive(IsTrackingServerActive isActive);

        /**
         * <p>
         * The MLflow version used for a listed tracking server.
         * </p>
         * 
         * @param mlflowVersion
         *        The MLflow version used for a listed tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlflowVersion(String mlflowVersion);
    }

    static final class BuilderImpl implements Builder {
        private String trackingServerArn;

        private String trackingServerName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String trackingServerStatus;

        private String isActive;

        private String mlflowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingServerSummary model) {
            trackingServerArn(model.trackingServerArn);
            trackingServerName(model.trackingServerName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            trackingServerStatus(model.trackingServerStatus);
            isActive(model.isActive);
            mlflowVersion(model.mlflowVersion);
        }

        public final String getTrackingServerArn() {
            return trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getTrackingServerStatus() {
            return trackingServerStatus;
        }

        public final void setTrackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
        }

        @Override
        public final Builder trackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
            return this;
        }

        @Override
        public final Builder trackingServerStatus(TrackingServerStatus trackingServerStatus) {
            this.trackingServerStatus(trackingServerStatus == null ? null : trackingServerStatus.toString());
            return this;
        }

        public final String getIsActive() {
            return isActive;
        }

        public final void setIsActive(String isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(String isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public final Builder isActive(IsTrackingServerActive isActive) {
            this.isActive(isActive == null ? null : isActive.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        @Override
        public TrackingServerSummary build() {
            return new TrackingServerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
