/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to use an image from a private Docker registry for a training job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingImageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingImageConfig.Builder, TrainingImageConfig> {
    private static final SdkField<String> TRAINING_REPOSITORY_ACCESS_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrainingRepositoryAccessMode")
            .getter(getter(TrainingImageConfig::trainingRepositoryAccessModeAsString))
            .setter(setter(Builder::trainingRepositoryAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingRepositoryAccessMode")
                    .build()).build();

    private static final SdkField<TrainingRepositoryAuthConfig> TRAINING_REPOSITORY_AUTH_CONFIG_FIELD = SdkField
            .<TrainingRepositoryAuthConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TrainingRepositoryAuthConfig")
            .getter(getter(TrainingImageConfig::trainingRepositoryAuthConfig))
            .setter(setter(Builder::trainingRepositoryAuthConfig))
            .constructor(TrainingRepositoryAuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingRepositoryAuthConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAINING_REPOSITORY_ACCESS_MODE_FIELD, TRAINING_REPOSITORY_AUTH_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trainingRepositoryAccessMode;

    private final TrainingRepositoryAuthConfig trainingRepositoryAuthConfig;

    private TrainingImageConfig(BuilderImpl builder) {
        this.trainingRepositoryAccessMode = builder.trainingRepositoryAccessMode;
        this.trainingRepositoryAuthConfig = builder.trainingRepositoryAuthConfig;
    }

    /**
     * <p>
     * The method that your training job will use to gain access to the images in your private Docker registry. For
     * access to an image in a private Docker registry, set to <code>Vpc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingRepositoryAccessMode} will return {@link TrainingRepositoryAccessMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #trainingRepositoryAccessModeAsString}.
     * </p>
     * 
     * @return The method that your training job will use to gain access to the images in your private Docker registry.
     *         For access to an image in a private Docker registry, set to <code>Vpc</code>.
     * @see TrainingRepositoryAccessMode
     */
    public final TrainingRepositoryAccessMode trainingRepositoryAccessMode() {
        return TrainingRepositoryAccessMode.fromValue(trainingRepositoryAccessMode);
    }

    /**
     * <p>
     * The method that your training job will use to gain access to the images in your private Docker registry. For
     * access to an image in a private Docker registry, set to <code>Vpc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingRepositoryAccessMode} will return {@link TrainingRepositoryAccessMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #trainingRepositoryAccessModeAsString}.
     * </p>
     * 
     * @return The method that your training job will use to gain access to the images in your private Docker registry.
     *         For access to an image in a private Docker registry, set to <code>Vpc</code>.
     * @see TrainingRepositoryAccessMode
     */
    public final String trainingRepositoryAccessModeAsString() {
        return trainingRepositoryAccessMode;
    }

    /**
     * <p>
     * An object containing authentication information for a private Docker registry containing your training images.
     * </p>
     * 
     * @return An object containing authentication information for a private Docker registry containing your training
     *         images.
     */
    public final TrainingRepositoryAuthConfig trainingRepositoryAuthConfig() {
        return trainingRepositoryAuthConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingRepositoryAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingRepositoryAuthConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingImageConfig)) {
            return false;
        }
        TrainingImageConfig other = (TrainingImageConfig) obj;
        return Objects.equals(trainingRepositoryAccessModeAsString(), other.trainingRepositoryAccessModeAsString())
                && Objects.equals(trainingRepositoryAuthConfig(), other.trainingRepositoryAuthConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingImageConfig")
                .add("TrainingRepositoryAccessMode", trainingRepositoryAccessModeAsString())
                .add("TrainingRepositoryAuthConfig", trainingRepositoryAuthConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingRepositoryAccessMode":
            return Optional.ofNullable(clazz.cast(trainingRepositoryAccessModeAsString()));
        case "TrainingRepositoryAuthConfig":
            return Optional.ofNullable(clazz.cast(trainingRepositoryAuthConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrainingRepositoryAccessMode", TRAINING_REPOSITORY_ACCESS_MODE_FIELD);
        map.put("TrainingRepositoryAuthConfig", TRAINING_REPOSITORY_AUTH_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingImageConfig, T> g) {
        return obj -> g.apply((TrainingImageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingImageConfig> {
        /**
         * <p>
         * The method that your training job will use to gain access to the images in your private Docker registry. For
         * access to an image in a private Docker registry, set to <code>Vpc</code>.
         * </p>
         * 
         * @param trainingRepositoryAccessMode
         *        The method that your training job will use to gain access to the images in your private Docker
         *        registry. For access to an image in a private Docker registry, set to <code>Vpc</code>.
         * @see TrainingRepositoryAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingRepositoryAccessMode
         */
        Builder trainingRepositoryAccessMode(String trainingRepositoryAccessMode);

        /**
         * <p>
         * The method that your training job will use to gain access to the images in your private Docker registry. For
         * access to an image in a private Docker registry, set to <code>Vpc</code>.
         * </p>
         * 
         * @param trainingRepositoryAccessMode
         *        The method that your training job will use to gain access to the images in your private Docker
         *        registry. For access to an image in a private Docker registry, set to <code>Vpc</code>.
         * @see TrainingRepositoryAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingRepositoryAccessMode
         */
        Builder trainingRepositoryAccessMode(TrainingRepositoryAccessMode trainingRepositoryAccessMode);

        /**
         * <p>
         * An object containing authentication information for a private Docker registry containing your training
         * images.
         * </p>
         * 
         * @param trainingRepositoryAuthConfig
         *        An object containing authentication information for a private Docker registry containing your training
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig trainingRepositoryAuthConfig);

        /**
         * <p>
         * An object containing authentication information for a private Docker registry containing your training
         * images.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingRepositoryAuthConfig.Builder}
         * avoiding the need to create one manually via {@link TrainingRepositoryAuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingRepositoryAuthConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig)}.
         * 
         * @param trainingRepositoryAuthConfig
         *        a consumer that will call methods on {@link TrainingRepositoryAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig)
         */
        default Builder trainingRepositoryAuthConfig(Consumer<TrainingRepositoryAuthConfig.Builder> trainingRepositoryAuthConfig) {
            return trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig.builder()
                    .applyMutation(trainingRepositoryAuthConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String trainingRepositoryAccessMode;

        private TrainingRepositoryAuthConfig trainingRepositoryAuthConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingImageConfig model) {
            trainingRepositoryAccessMode(model.trainingRepositoryAccessMode);
            trainingRepositoryAuthConfig(model.trainingRepositoryAuthConfig);
        }

        public final String getTrainingRepositoryAccessMode() {
            return trainingRepositoryAccessMode;
        }

        public final void setTrainingRepositoryAccessMode(String trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode = trainingRepositoryAccessMode;
        }

        @Override
        public final Builder trainingRepositoryAccessMode(String trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode = trainingRepositoryAccessMode;
            return this;
        }

        @Override
        public final Builder trainingRepositoryAccessMode(TrainingRepositoryAccessMode trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode(trainingRepositoryAccessMode == null ? null : trainingRepositoryAccessMode
                    .toString());
            return this;
        }

        public final TrainingRepositoryAuthConfig.Builder getTrainingRepositoryAuthConfig() {
            return trainingRepositoryAuthConfig != null ? trainingRepositoryAuthConfig.toBuilder() : null;
        }

        public final void setTrainingRepositoryAuthConfig(TrainingRepositoryAuthConfig.BuilderImpl trainingRepositoryAuthConfig) {
            this.trainingRepositoryAuthConfig = trainingRepositoryAuthConfig != null ? trainingRepositoryAuthConfig.build()
                    : null;
        }

        @Override
        public final Builder trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig trainingRepositoryAuthConfig) {
            this.trainingRepositoryAuthConfig = trainingRepositoryAuthConfig;
            return this;
        }

        @Override
        public TrainingImageConfig build() {
            return new TrainingImageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
