/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingJobStatusCounters implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingJobStatusCounters.Builder, TrainingJobStatusCounters> {
    private static final SdkField<Integer> COMPLETED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Completed").getter(getter(TrainingJobStatusCounters::completed)).setter(setter(Builder::completed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()).build();

    private static final SdkField<Integer> IN_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InProgress").getter(getter(TrainingJobStatusCounters::inProgress)).setter(setter(Builder::inProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgress").build()).build();

    private static final SdkField<Integer> RETRYABLE_ERROR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryableError").getter(getter(TrainingJobStatusCounters::retryableError))
            .setter(setter(Builder::retryableError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryableError").build()).build();

    private static final SdkField<Integer> NON_RETRYABLE_ERROR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonRetryableError").getter(getter(TrainingJobStatusCounters::nonRetryableError))
            .setter(setter(Builder::nonRetryableError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRetryableError").build()).build();

    private static final SdkField<Integer> STOPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Stopped").getter(getter(TrainingJobStatusCounters::stopped)).setter(setter(Builder::stopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stopped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_FIELD,
            IN_PROGRESS_FIELD, RETRYABLE_ERROR_FIELD, NON_RETRYABLE_ERROR_FIELD, STOPPED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer completed;

    private final Integer inProgress;

    private final Integer retryableError;

    private final Integer nonRetryableError;

    private final Integer stopped;

    private TrainingJobStatusCounters(BuilderImpl builder) {
        this.completed = builder.completed;
        this.inProgress = builder.inProgress;
        this.retryableError = builder.retryableError;
        this.nonRetryableError = builder.nonRetryableError;
        this.stopped = builder.stopped;
    }

    /**
     * <p>
     * The number of completed training jobs launched by the hyperparameter tuning job.
     * </p>
     * 
     * @return The number of completed training jobs launched by the hyperparameter tuning job.
     */
    public final Integer completed() {
        return completed;
    }

    /**
     * <p>
     * The number of in-progress training jobs launched by a hyperparameter tuning job.
     * </p>
     * 
     * @return The number of in-progress training jobs launched by a hyperparameter tuning job.
     */
    public final Integer inProgress() {
        return inProgress;
    }

    /**
     * <p>
     * The number of training jobs that failed, but can be retried. A failed training job can be retried only if it
     * failed because an internal service error occurred.
     * </p>
     * 
     * @return The number of training jobs that failed, but can be retried. A failed training job can be retried only if
     *         it failed because an internal service error occurred.
     */
    public final Integer retryableError() {
        return retryableError;
    }

    /**
     * <p>
     * The number of training jobs that failed and can't be retried. A failed training job can't be retried if it failed
     * because a client error occurred.
     * </p>
     * 
     * @return The number of training jobs that failed and can't be retried. A failed training job can't be retried if
     *         it failed because a client error occurred.
     */
    public final Integer nonRetryableError() {
        return nonRetryableError;
    }

    /**
     * <p>
     * The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
     * </p>
     * 
     * @return The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
     */
    public final Integer stopped() {
        return stopped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completed());
        hashCode = 31 * hashCode + Objects.hashCode(inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(retryableError());
        hashCode = 31 * hashCode + Objects.hashCode(nonRetryableError());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobStatusCounters)) {
            return false;
        }
        TrainingJobStatusCounters other = (TrainingJobStatusCounters) obj;
        return Objects.equals(completed(), other.completed()) && Objects.equals(inProgress(), other.inProgress())
                && Objects.equals(retryableError(), other.retryableError())
                && Objects.equals(nonRetryableError(), other.nonRetryableError()) && Objects.equals(stopped(), other.stopped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingJobStatusCounters").add("Completed", completed()).add("InProgress", inProgress())
                .add("RetryableError", retryableError()).add("NonRetryableError", nonRetryableError()).add("Stopped", stopped())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Completed":
            return Optional.ofNullable(clazz.cast(completed()));
        case "InProgress":
            return Optional.ofNullable(clazz.cast(inProgress()));
        case "RetryableError":
            return Optional.ofNullable(clazz.cast(retryableError()));
        case "NonRetryableError":
            return Optional.ofNullable(clazz.cast(nonRetryableError()));
        case "Stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Completed", COMPLETED_FIELD);
        map.put("InProgress", IN_PROGRESS_FIELD);
        map.put("RetryableError", RETRYABLE_ERROR_FIELD);
        map.put("NonRetryableError", NON_RETRYABLE_ERROR_FIELD);
        map.put("Stopped", STOPPED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobStatusCounters, T> g) {
        return obj -> g.apply((TrainingJobStatusCounters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingJobStatusCounters> {
        /**
         * <p>
         * The number of completed training jobs launched by the hyperparameter tuning job.
         * </p>
         * 
         * @param completed
         *        The number of completed training jobs launched by the hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completed(Integer completed);

        /**
         * <p>
         * The number of in-progress training jobs launched by a hyperparameter tuning job.
         * </p>
         * 
         * @param inProgress
         *        The number of in-progress training jobs launched by a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgress(Integer inProgress);

        /**
         * <p>
         * The number of training jobs that failed, but can be retried. A failed training job can be retried only if it
         * failed because an internal service error occurred.
         * </p>
         * 
         * @param retryableError
         *        The number of training jobs that failed, but can be retried. A failed training job can be retried only
         *        if it failed because an internal service error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryableError(Integer retryableError);

        /**
         * <p>
         * The number of training jobs that failed and can't be retried. A failed training job can't be retried if it
         * failed because a client error occurred.
         * </p>
         * 
         * @param nonRetryableError
         *        The number of training jobs that failed and can't be retried. A failed training job can't be retried
         *        if it failed because a client error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonRetryableError(Integer nonRetryableError);

        /**
         * <p>
         * The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
         * </p>
         * 
         * @param stopped
         *        The number of training jobs launched by a hyperparameter tuning job that were manually stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Integer stopped);
    }

    static final class BuilderImpl implements Builder {
        private Integer completed;

        private Integer inProgress;

        private Integer retryableError;

        private Integer nonRetryableError;

        private Integer stopped;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobStatusCounters model) {
            completed(model.completed);
            inProgress(model.inProgress);
            retryableError(model.retryableError);
            nonRetryableError(model.nonRetryableError);
            stopped(model.stopped);
        }

        public final Integer getCompleted() {
            return completed;
        }

        public final void setCompleted(Integer completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(Integer completed) {
            this.completed = completed;
            return this;
        }

        public final Integer getInProgress() {
            return inProgress;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        @Override
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final Integer getRetryableError() {
            return retryableError;
        }

        public final void setRetryableError(Integer retryableError) {
            this.retryableError = retryableError;
        }

        @Override
        public final Builder retryableError(Integer retryableError) {
            this.retryableError = retryableError;
            return this;
        }

        public final Integer getNonRetryableError() {
            return nonRetryableError;
        }

        public final void setNonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
        }

        @Override
        public final Builder nonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
            return this;
        }

        public final Integer getStopped() {
            return stopped;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        @Override
        public TrainingJobStatusCounters build() {
            return new TrainingJobStatusCounters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
