/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an amount of money in United States dollars.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class USD implements SdkPojo, Serializable, ToCopyableBuilder<USD.Builder, USD> {
    private static final SdkField<Integer> DOLLARS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Dollars").getter(getter(USD::dollars)).setter(setter(Builder::dollars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dollars").build()).build();

    private static final SdkField<Integer> CENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Cents")
            .getter(getter(USD::cents)).setter(setter(Builder::cents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cents").build()).build();

    private static final SdkField<Integer> TENTH_FRACTIONS_OF_A_CENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TenthFractionsOfACent").getter(getter(USD::tenthFractionsOfACent))
            .setter(setter(Builder::tenthFractionsOfACent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenthFractionsOfACent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOLLARS_FIELD, CENTS_FIELD,
            TENTH_FRACTIONS_OF_A_CENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dollars;

    private final Integer cents;

    private final Integer tenthFractionsOfACent;

    private USD(BuilderImpl builder) {
        this.dollars = builder.dollars;
        this.cents = builder.cents;
        this.tenthFractionsOfACent = builder.tenthFractionsOfACent;
    }

    /**
     * <p>
     * The whole number of dollars in the amount.
     * </p>
     * 
     * @return The whole number of dollars in the amount.
     */
    public final Integer dollars() {
        return dollars;
    }

    /**
     * <p>
     * The fractional portion, in cents, of the amount.
     * </p>
     * 
     * @return The fractional portion, in cents, of the amount.
     */
    public final Integer cents() {
        return cents;
    }

    /**
     * <p>
     * Fractions of a cent, in tenths.
     * </p>
     * 
     * @return Fractions of a cent, in tenths.
     */
    public final Integer tenthFractionsOfACent() {
        return tenthFractionsOfACent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dollars());
        hashCode = 31 * hashCode + Objects.hashCode(cents());
        hashCode = 31 * hashCode + Objects.hashCode(tenthFractionsOfACent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof USD)) {
            return false;
        }
        USD other = (USD) obj;
        return Objects.equals(dollars(), other.dollars()) && Objects.equals(cents(), other.cents())
                && Objects.equals(tenthFractionsOfACent(), other.tenthFractionsOfACent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("USD").add("Dollars", dollars()).add("Cents", cents())
                .add("TenthFractionsOfACent", tenthFractionsOfACent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dollars":
            return Optional.ofNullable(clazz.cast(dollars()));
        case "Cents":
            return Optional.ofNullable(clazz.cast(cents()));
        case "TenthFractionsOfACent":
            return Optional.ofNullable(clazz.cast(tenthFractionsOfACent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dollars", DOLLARS_FIELD);
        map.put("Cents", CENTS_FIELD);
        map.put("TenthFractionsOfACent", TENTH_FRACTIONS_OF_A_CENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<USD, T> g) {
        return obj -> g.apply((USD) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, USD> {
        /**
         * <p>
         * The whole number of dollars in the amount.
         * </p>
         * 
         * @param dollars
         *        The whole number of dollars in the amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dollars(Integer dollars);

        /**
         * <p>
         * The fractional portion, in cents, of the amount.
         * </p>
         * 
         * @param cents
         *        The fractional portion, in cents, of the amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cents(Integer cents);

        /**
         * <p>
         * Fractions of a cent, in tenths.
         * </p>
         * 
         * @param tenthFractionsOfACent
         *        Fractions of a cent, in tenths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenthFractionsOfACent(Integer tenthFractionsOfACent);
    }

    static final class BuilderImpl implements Builder {
        private Integer dollars;

        private Integer cents;

        private Integer tenthFractionsOfACent;

        private BuilderImpl() {
        }

        private BuilderImpl(USD model) {
            dollars(model.dollars);
            cents(model.cents);
            tenthFractionsOfACent(model.tenthFractionsOfACent);
        }

        public final Integer getDollars() {
            return dollars;
        }

        public final void setDollars(Integer dollars) {
            this.dollars = dollars;
        }

        @Override
        public final Builder dollars(Integer dollars) {
            this.dollars = dollars;
            return this;
        }

        public final Integer getCents() {
            return cents;
        }

        public final void setCents(Integer cents) {
            this.cents = cents;
        }

        @Override
        public final Builder cents(Integer cents) {
            this.cents = cents;
            return this;
        }

        public final Integer getTenthFractionsOfACent() {
            return tenthFractionsOfACent;
        }

        public final void setTenthFractionsOfACent(Integer tenthFractionsOfACent) {
            this.tenthFractionsOfACent = tenthFractionsOfACent;
        }

        @Override
        public final Builder tenthFractionsOfACent(Integer tenthFractionsOfACent) {
            this.tenthFractionsOfACent = tenthFractionsOfACent;
            return this;
        }

        @Override
        public USD build() {
            return new USD(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
