/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperimentRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateExperimentRequest.Builder, UpdateExperimentRequest> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(UpdateExperimentRequest::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateExperimentRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateExperimentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String experimentName;

    private final String displayName;

    private final String description;

    private UpdateExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.experimentName = builder.experimentName;
        this.displayName = builder.displayName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the experiment to update.
     * </p>
     * 
     * @return The name of the experiment to update.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * The name of the experiment as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
     * specified, <code>ExperimentName</code> is displayed.
     * </p>
     * 
     * @return The name of the experiment as displayed. The name doesn't need to be unique. If <code>DisplayName</code>
     *         isn't specified, <code>ExperimentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the experiment.
     * </p>
     * 
     * @return The description of the experiment.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentRequest)) {
            return false;
        }
        UpdateExperimentRequest other = (UpdateExperimentRequest) obj;
        return Objects.equals(experimentName(), other.experimentName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperimentRequest").add("ExperimentName", experimentName())
                .add("DisplayName", displayName()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExperimentName", EXPERIMENT_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentRequest, T> g) {
        return obj -> g.apply((UpdateExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExperimentRequest> {
        /**
         * <p>
         * The name of the experiment to update.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * The name of the experiment as displayed. The name doesn't need to be unique. If <code>DisplayName</code>
         * isn't specified, <code>ExperimentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the experiment as displayed. The name doesn't need to be unique. If
         *        <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the experiment.
         * </p>
         * 
         * @param description
         *        The description of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String experimentName;

        private String displayName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentRequest model) {
            super(model);
            experimentName(model.experimentName);
            displayName(model.displayName);
            description(model.description);
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperimentRequest build() {
            return new UpdateExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
