/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFeatureMetadataRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateFeatureMetadataRequest.Builder, UpdateFeatureMetadataRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(UpdateFeatureMetadataRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(UpdateFeatureMetadataRequest::featureName))
            .setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFeatureMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<FeatureParameter>> PARAMETER_ADDITIONS_FIELD = SdkField
            .<List<FeatureParameter>> builder(MarshallingType.LIST)
            .memberName("ParameterAdditions")
            .getter(getter(UpdateFeatureMetadataRequest::parameterAdditions))
            .setter(setter(Builder::parameterAdditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterAdditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PARAMETER_REMOVALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParameterRemovals")
            .getter(getter(UpdateFeatureMetadataRequest::parameterRemovals))
            .setter(setter(Builder::parameterRemovals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterRemovals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            FEATURE_NAME_FIELD, DESCRIPTION_FIELD, PARAMETER_ADDITIONS_FIELD, PARAMETER_REMOVALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String featureGroupName;

    private final String featureName;

    private final String description;

    private final List<FeatureParameter> parameterAdditions;

    private final List<String> parameterRemovals;

    private UpdateFeatureMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.featureName = builder.featureName;
        this.description = builder.description;
        this.parameterAdditions = builder.parameterAdditions;
        this.parameterRemovals = builder.parameterRemovals;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the feature group containing the feature that you're updating.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the feature group containing the feature that you're updating.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The name of the feature that you're updating.
     * </p>
     * 
     * @return The name of the feature that you're updating.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * A description that you can write to better describe the feature.
     * </p>
     * 
     * @return A description that you can write to better describe the feature.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterAdditions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterAdditions() {
        return parameterAdditions != null && !(parameterAdditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that you can add to better describe the feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterAdditions} method.
     * </p>
     * 
     * @return A list of key-value pairs that you can add to better describe the feature.
     */
    public final List<FeatureParameter> parameterAdditions() {
        return parameterAdditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterRemovals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterRemovals() {
        return parameterRemovals != null && !(parameterRemovals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter keys that you can specify to remove parameters that describe your feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterRemovals} method.
     * </p>
     * 
     * @return A list of parameter keys that you can specify to remove parameters that describe your feature.
     */
    public final List<String> parameterRemovals() {
        return parameterRemovals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterAdditions() ? parameterAdditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterRemovals() ? parameterRemovals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureMetadataRequest)) {
            return false;
        }
        UpdateFeatureMetadataRequest other = (UpdateFeatureMetadataRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName()) && Objects.equals(featureName(), other.featureName())
                && Objects.equals(description(), other.description()) && hasParameterAdditions() == other.hasParameterAdditions()
                && Objects.equals(parameterAdditions(), other.parameterAdditions())
                && hasParameterRemovals() == other.hasParameterRemovals()
                && Objects.equals(parameterRemovals(), other.parameterRemovals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFeatureMetadataRequest").add("FeatureGroupName", featureGroupName())
                .add("FeatureName", featureName()).add("Description", description())
                .add("ParameterAdditions", hasParameterAdditions() ? parameterAdditions() : null)
                .add("ParameterRemovals", hasParameterRemovals() ? parameterRemovals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ParameterAdditions":
            return Optional.ofNullable(clazz.cast(parameterAdditions()));
        case "ParameterRemovals":
            return Optional.ofNullable(clazz.cast(parameterRemovals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("FeatureName", FEATURE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ParameterAdditions", PARAMETER_ADDITIONS_FIELD);
        map.put("ParameterRemovals", PARAMETER_REMOVALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureMetadataRequest, T> g) {
        return obj -> g.apply((UpdateFeatureMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFeatureMetadataRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the feature group containing the feature that you're updating.
         * </p>
         * 
         * @param featureGroupName
         *        The name or Amazon Resource Name (ARN) of the feature group containing the feature that you're
         *        updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The name of the feature that you're updating.
         * </p>
         * 
         * @param featureName
         *        The name of the feature that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * A description that you can write to better describe the feature.
         * </p>
         * 
         * @param description
         *        A description that you can write to better describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of key-value pairs that you can add to better describe the feature.
         * </p>
         * 
         * @param parameterAdditions
         *        A list of key-value pairs that you can add to better describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterAdditions(Collection<FeatureParameter> parameterAdditions);

        /**
         * <p>
         * A list of key-value pairs that you can add to better describe the feature.
         * </p>
         * 
         * @param parameterAdditions
         *        A list of key-value pairs that you can add to better describe the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterAdditions(FeatureParameter... parameterAdditions);

        /**
         * <p>
         * A list of key-value pairs that you can add to better describe the feature.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.FeatureParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.FeatureParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterAdditions(List<FeatureParameter>)}.
         * 
         * @param parameterAdditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.FeatureParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterAdditions(java.util.Collection<FeatureParameter>)
         */
        Builder parameterAdditions(Consumer<FeatureParameter.Builder>... parameterAdditions);

        /**
         * <p>
         * A list of parameter keys that you can specify to remove parameters that describe your feature.
         * </p>
         * 
         * @param parameterRemovals
         *        A list of parameter keys that you can specify to remove parameters that describe your feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterRemovals(Collection<String> parameterRemovals);

        /**
         * <p>
         * A list of parameter keys that you can specify to remove parameters that describe your feature.
         * </p>
         * 
         * @param parameterRemovals
         *        A list of parameter keys that you can specify to remove parameters that describe your feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterRemovals(String... parameterRemovals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private String featureName;

        private String description;

        private List<FeatureParameter> parameterAdditions = DefaultSdkAutoConstructList.getInstance();

        private List<String> parameterRemovals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureMetadataRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            featureName(model.featureName);
            description(model.description);
            parameterAdditions(model.parameterAdditions);
            parameterRemovals(model.parameterRemovals);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FeatureParameter.Builder> getParameterAdditions() {
            List<FeatureParameter.Builder> result = FeatureParameterAdditionsCopier.copyToBuilder(this.parameterAdditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterAdditions(Collection<FeatureParameter.BuilderImpl> parameterAdditions) {
            this.parameterAdditions = FeatureParameterAdditionsCopier.copyFromBuilder(parameterAdditions);
        }

        @Override
        public final Builder parameterAdditions(Collection<FeatureParameter> parameterAdditions) {
            this.parameterAdditions = FeatureParameterAdditionsCopier.copy(parameterAdditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterAdditions(FeatureParameter... parameterAdditions) {
            parameterAdditions(Arrays.asList(parameterAdditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterAdditions(Consumer<FeatureParameter.Builder>... parameterAdditions) {
            parameterAdditions(Stream.of(parameterAdditions).map(c -> FeatureParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getParameterRemovals() {
            if (parameterRemovals instanceof SdkAutoConstructList) {
                return null;
            }
            return parameterRemovals;
        }

        public final void setParameterRemovals(Collection<String> parameterRemovals) {
            this.parameterRemovals = FeatureParameterRemovalsCopier.copy(parameterRemovals);
        }

        @Override
        public final Builder parameterRemovals(Collection<String> parameterRemovals) {
            this.parameterRemovals = FeatureParameterRemovalsCopier.copy(parameterRemovals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterRemovals(String... parameterRemovals) {
            parameterRemovals(Arrays.asList(parameterRemovals));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureMetadataRequest build() {
            return new UpdateFeatureMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
