/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a production variant property type for an Endpoint.
 * </p>
 * <p>
 * If you are updating an endpoint with the <code>RetainAllVariantProperties</code> option of <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html">UpdateEndpointInput</a> set
 * to <code>true</code>, the <code>VariantProperty</code> objects listed in the
 * <code>ExcludeRetainedVariantProperties</code> parameter of <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html">UpdateEndpointInput</a>
 * override the existing variant properties of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariantProperty implements SdkPojo, Serializable, ToCopyableBuilder<VariantProperty.Builder, VariantProperty> {
    private static final SdkField<String> VARIANT_PROPERTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantPropertyType").getter(getter(VariantProperty::variantPropertyTypeAsString))
            .setter(setter(Builder::variantPropertyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantPropertyType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_PROPERTY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String variantPropertyType;

    private VariantProperty(BuilderImpl builder) {
        this.variantPropertyType = builder.variantPropertyType;
    }

    /**
     * <p>
     * The type of variant property. The supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
     * <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DesiredWeight</code>: Overrides the existing variant weights using the <code>InitialVariantWeight</code>
     * values in the <code>ProductionVariants</code> of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataCaptureConfig</code>: (Not currently supported.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #variantPropertyType} will return {@link VariantPropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #variantPropertyTypeAsString}.
     * </p>
     * 
     * @return The type of variant property. The supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
     *         <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     *         >CreateEndpointConfig</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DesiredWeight</code>: Overrides the existing variant weights using the
     *         <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     *         >CreateEndpointConfig</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataCaptureConfig</code>: (Not currently supported.)
     *         </p>
     *         </li>
     * @see VariantPropertyType
     */
    public final VariantPropertyType variantPropertyType() {
        return VariantPropertyType.fromValue(variantPropertyType);
    }

    /**
     * <p>
     * The type of variant property. The supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
     * <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DesiredWeight</code>: Overrides the existing variant weights using the <code>InitialVariantWeight</code>
     * values in the <code>ProductionVariants</code> of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataCaptureConfig</code>: (Not currently supported.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #variantPropertyType} will return {@link VariantPropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #variantPropertyTypeAsString}.
     * </p>
     * 
     * @return The type of variant property. The supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
     *         <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     *         >CreateEndpointConfig</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DesiredWeight</code>: Overrides the existing variant weights using the
     *         <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     *         >CreateEndpointConfig</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataCaptureConfig</code>: (Not currently supported.)
     *         </p>
     *         </li>
     * @see VariantPropertyType
     */
    public final String variantPropertyTypeAsString() {
        return variantPropertyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variantPropertyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariantProperty)) {
            return false;
        }
        VariantProperty other = (VariantProperty) obj;
        return Objects.equals(variantPropertyTypeAsString(), other.variantPropertyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariantProperty").add("VariantPropertyType", variantPropertyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VariantPropertyType":
            return Optional.ofNullable(clazz.cast(variantPropertyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VariantPropertyType", VARIANT_PROPERTY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VariantProperty, T> g) {
        return obj -> g.apply((VariantProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariantProperty> {
        /**
         * <p>
         * The type of variant property. The supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
         * <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         * >CreateEndpointConfig</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DesiredWeight</code>: Overrides the existing variant weights using the
         * <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         * >CreateEndpointConfig</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataCaptureConfig</code>: (Not currently supported.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param variantPropertyType
         *        The type of variant property. The supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
         *        <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         *        >CreateEndpointConfig</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DesiredWeight</code>: Overrides the existing variant weights using the
         *        <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         *        >CreateEndpointConfig</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataCaptureConfig</code>: (Not currently supported.)
         *        </p>
         *        </li>
         * @see VariantPropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariantPropertyType
         */
        Builder variantPropertyType(String variantPropertyType);

        /**
         * <p>
         * The type of variant property. The supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
         * <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         * >CreateEndpointConfig</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DesiredWeight</code>: Overrides the existing variant weights using the
         * <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         * >CreateEndpointConfig</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataCaptureConfig</code>: (Not currently supported.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param variantPropertyType
         *        The type of variant property. The supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the
         *        <code>InitialInstanceCount</code> values in the <code>ProductionVariants</code> of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         *        >CreateEndpointConfig</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DesiredWeight</code>: Overrides the existing variant weights using the
         *        <code>InitialVariantWeight</code> values in the <code>ProductionVariants</code> of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         *        >CreateEndpointConfig</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataCaptureConfig</code>: (Not currently supported.)
         *        </p>
         *        </li>
         * @see VariantPropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariantPropertyType
         */
        Builder variantPropertyType(VariantPropertyType variantPropertyType);
    }

    static final class BuilderImpl implements Builder {
        private String variantPropertyType;

        private BuilderImpl() {
        }

        private BuilderImpl(VariantProperty model) {
            variantPropertyType(model.variantPropertyType);
        }

        public final String getVariantPropertyType() {
            return variantPropertyType;
        }

        public final void setVariantPropertyType(String variantPropertyType) {
            this.variantPropertyType = variantPropertyType;
        }

        @Override
        public final Builder variantPropertyType(String variantPropertyType) {
            this.variantPropertyType = variantPropertyType;
            return this;
        }

        @Override
        public final Builder variantPropertyType(VariantPropertyType variantPropertyType) {
            this.variantPropertyType(variantPropertyType == null ? null : variantPropertyType.toString());
            return this;
        }

        @Override
        public VariantProperty build() {
            return new VariantProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
