/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The workspace settings for the SageMaker Canvas application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceSettings.Builder, WorkspaceSettings> {
    private static final SdkField<String> S3_ARTIFACT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ArtifactPath").getter(getter(WorkspaceSettings::s3ArtifactPath))
            .setter(setter(Builder::s3ArtifactPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ArtifactPath").build()).build();

    private static final SdkField<String> S3_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KmsKeyId").getter(getter(WorkspaceSettings::s3KmsKeyId)).setter(setter(Builder::s3KmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ARTIFACT_PATH_FIELD,
            S3_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3ArtifactPath;

    private final String s3KmsKeyId;

    private WorkspaceSettings(BuilderImpl builder) {
        this.s3ArtifactPath = builder.s3ArtifactPath;
        this.s3KmsKeyId = builder.s3KmsKeyId;
    }

    /**
     * <p>
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log
     * out and log back in to apply the new location.
     * </p>
     * 
     * @return The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     *         existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users
     *         must log out and log back in to apply the new location.
     */
    public final String s3ArtifactPath() {
        return s3ArtifactPath;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     * generated by Canvas in the Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     *         generated by Canvas in the Amazon S3 bucket.
     */
    public final String s3KmsKeyId() {
        return s3KmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ArtifactPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3KmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceSettings)) {
            return false;
        }
        WorkspaceSettings other = (WorkspaceSettings) obj;
        return Objects.equals(s3ArtifactPath(), other.s3ArtifactPath()) && Objects.equals(s3KmsKeyId(), other.s3KmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceSettings").add("S3ArtifactPath", s3ArtifactPath()).add("S3KmsKeyId", s3KmsKeyId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ArtifactPath":
            return Optional.ofNullable(clazz.cast(s3ArtifactPath()));
        case "S3KmsKeyId":
            return Optional.ofNullable(clazz.cast(s3KmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3ArtifactPath", S3_ARTIFACT_PATH_FIELD);
        map.put("S3KmsKeyId", S3_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceSettings, T> g) {
        return obj -> g.apply((WorkspaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceSettings> {
        /**
         * <p>
         * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
         * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must
         * log out and log back in to apply the new location.
         * </p>
         * 
         * @param s3ArtifactPath
         *        The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location
         *        impacts existing configuration settings, and Canvas users no longer have access to their artifacts.
         *        Canvas users must log out and log back in to apply the new location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ArtifactPath(String s3ArtifactPath);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
         * generated by Canvas in the Amazon S3 bucket.
         * </p>
         * 
         * @param s3KmsKeyId
         *        The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt
         *        artifacts generated by Canvas in the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KmsKeyId(String s3KmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String s3ArtifactPath;

        private String s3KmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceSettings model) {
            s3ArtifactPath(model.s3ArtifactPath);
            s3KmsKeyId(model.s3KmsKeyId);
        }

        public final String getS3ArtifactPath() {
            return s3ArtifactPath;
        }

        public final void setS3ArtifactPath(String s3ArtifactPath) {
            this.s3ArtifactPath = s3ArtifactPath;
        }

        @Override
        public final Builder s3ArtifactPath(String s3ArtifactPath) {
            this.s3ArtifactPath = s3ArtifactPath;
            return this;
        }

        public final String getS3KmsKeyId() {
            return s3KmsKeyId;
        }

        public final void setS3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
        }

        @Override
        public final Builder s3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
            return this;
        }

        @Override
        public WorkspaceSettings build() {
            return new WorkspaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
