/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sagemaker.internal.SageMakerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.ConflictException;
import software.amazon.awssdk.services.sagemaker.model.CreateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClustersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClustersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasRequest;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasResponse;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.transform.AddAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AssociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.BatchDeleteClusterNodesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.BatchDescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateAutoMlJobV2RequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateClusterSchedulerConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateComputeQuotaRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHubContentReferenceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHubRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateInferenceComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelCardExportJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelCardRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateOptimizationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePartnerAppPresignedUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePartnerAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedDomainUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedMlflowTrackingServerUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedNotebookInstanceUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateSpaceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteClusterSchedulerConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteComputeQuotaRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHubContentReferenceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHubContentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHubRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteInferenceComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelCardRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteOptimizationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeletePartnerAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteSpaceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeregisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeAutoMlJobV2RequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeClusterNodeRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeClusterSchedulerConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeComputeQuotaRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDataQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgeDeploymentPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeFlowDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHubContentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHubRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHumanTaskUiRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeInferenceComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeLineageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelBiasJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelCardExportJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelCardRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelExplainabilityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelQualityJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeOptimizationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePartnerAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineDefinitionForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeSpaceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeStudioLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeSubscribedWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingPlanRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DisassociateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.EnableSagemakerServicecatalogPortfolioRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetDeviceFleetReportRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetLineageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSagemakerServicecatalogPortfolioStatusRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetScalingConfigurationRecommendationRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.GetSearchSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ImportHubContentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListActionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAlgorithmsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppImageConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListAutoMlJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCandidatesForAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListClusterNodesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListClusterSchedulerConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCodeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListCompilationJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListComputeQuotasRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListContextsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDataQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDeviceFleetsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgeDeploymentPlansRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEdgePackagingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListExperimentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFeatureGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListFlowDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHubContentVersionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHubContentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHubsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHumanTaskUisRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListHyperParameterTuningJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImageVersionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceComponentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceExperimentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceRecommendationsJobStepsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListInferenceRecommendationsJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsForWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLabelingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListLineageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMlflowTrackingServersRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelBiasJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelCardExportJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelCardVersionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelCardsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelExplainabilityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackageGroupsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelPackagesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelQualityJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringAlertHistoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringAlertsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListMonitoringSchedulesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstanceLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstancesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListOptimizationJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPartnerAppsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionStepsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelineParametersForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListResourceCatalogsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListSpacesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStageDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListStudioLifecycleConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListSubscribedWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsForHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingPlansRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialComponentsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrialsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListUserProfilesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkforcesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListWorkteamsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.PutModelPackageGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.QueryLineageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RegisterDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RenderUiTemplateRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.RetryPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SearchTrainingPlanOfferingsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepFailureRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.SendPipelineExecutionStepSuccessRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopAutoMlJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopCompilationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgeDeploymentStageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopEdgePackagingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopHyperParameterTuningJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopInferenceRecommendationsJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopLabelingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopOptimizationJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTransformJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateActionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateAppImageConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateArtifactRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateClusterSchedulerConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateClusterSoftwareRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateCodeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateComputeQuotaRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateContextRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDeviceFleetRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDevicesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateDomainRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointWeightsAndCapacitiesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureGroupRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateFeatureMetadataRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateHubContentReferenceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateHubContentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateHubRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateImageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateImageVersionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateInferenceComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateInferenceComponentRuntimeConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateInferenceExperimentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateMlflowTrackingServerRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateModelCardRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateModelPackageRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateMonitoringAlertRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateMonitoringScheduleRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceLifecycleConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePartnerAppRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateSpaceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialComponentRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateTrialRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkforceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateWorkteamRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SageMakerAsyncClient}.
 *
 * @see SageMakerAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSageMakerAsyncClient implements SageMakerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSageMakerAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultSageMakerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param addAssociationRequest
     * @return A Java Future containing the result of the AddAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddAssociationResponse> addAssociation(AddAssociationRequest addAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddAssociationRequest, AddAssociationResponse>()
                            .withOperationName("AddAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addAssociationRequest));
            CompletableFuture<AddAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the
     * Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched
     * before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to
     * all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile
     * by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a
     * href
     * ="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new AddTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsRequest));
            CompletableFuture<AddTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param associateTrialComponentRequest
     * @return A Java Future containing the result of the AssociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTrialComponentResponse> associateTrialComponent(
            AssociateTrialComponentRequest associateTrialComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTrialComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTrialComponentRequest, AssociateTrialComponentResponse>()
                            .withOperationName("AssociateTrialComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateTrialComponentRequest));
            CompletableFuture<AssociateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes specific nodes within a SageMaker HyperPod cluster. <code>BatchDeleteClusterNodes</code> accepts a
     * cluster name and a list of node IDs.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre file system before invoking the API
     * on a worker node group. This will help prevent any potential data loss from the instance root volume. For more
     * information about backup, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup"
     * >Use the backup script provided by SageMaker HyperPod</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to invoke this API on an existing cluster, you'll first need to patch the cluster by running the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html">
     * UpdateClusterSoftware API</a>. For more information about patching a cluster, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software"
     * >Update the SageMaker HyperPod platform software of a cluster</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param batchDeleteClusterNodesRequest
     * @return A Java Future containing the result of the BatchDeleteClusterNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDeleteClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDeleteClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteClusterNodesResponse> batchDeleteClusterNodes(
            BatchDeleteClusterNodesRequest batchDeleteClusterNodesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteClusterNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteClusterNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteClusterNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteClusterNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteClusterNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteClusterNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteClusterNodesRequest, BatchDeleteClusterNodesResponse>()
                            .withOperationName("BatchDeleteClusterNodes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteClusterNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteClusterNodesRequest));
            CompletableFuture<BatchDeleteClusterNodesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     * @return A Java Future containing the result of the BatchDescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDescribeModelPackageResponse> batchDescribeModelPackage(
            BatchDescribeModelPackageRequest batchDescribeModelPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDescribeModelPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDescribeModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDescribeModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeModelPackageRequest, BatchDescribeModelPackageResponse>()
                            .withOperationName("BatchDescribeModelPackage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDescribeModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDescribeModelPackageRequest));
            CompletableFuture<BatchDescribeModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     *
     * @param createActionRequest
     * @return A Java Future containing the result of the CreateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateActionResponse> createAction(CreateActionRequest createActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateActionRequest, CreateActionResponse>()
                            .withOperationName("CreateAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createActionRequest));
            CompletableFuture<CreateActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return A Java Future containing the result of the CreateAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAlgorithmResponse> createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAlgorithmRequest, CreateAlgorithmResponse>()
                            .withOperationName("CreateAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAlgorithmRequest));
            CompletableFuture<CreateAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may
     * have multiple Apps active simultaneously.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>().withOperationName("CreateApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAppRequest));
            CompletableFuture<CreateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
     * </p>
     *
     * @param createAppImageConfigRequest
     * @return A Java Future containing the result of the CreateAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppImageConfigResponse> createAppImageConfig(
            CreateAppImageConfigRequest createAppImageConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppImageConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppImageConfigRequest, CreateAppImageConfigResponse>()
                            .withOperationName("CreateAppImageConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAppImageConfigRequest));
            CompletableFuture<CreateAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createArtifactRequest
     * @return A Java Future containing the result of the CreateArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateArtifactResponse> createArtifact(CreateArtifactRequest createArtifactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createArtifactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateArtifactRequest, CreateArtifactResponse>()
                            .withOperationName("CreateArtifact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createArtifactRequest));
            CompletableFuture<CreateArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <note>
     * <p>
     * We recommend using the new versions <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a>, which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * You can find the best-performing model after you run an AutoML job by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a> (recommended) or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html"
     * >DescribeAutoMLJob</a>.
     * </p>
     *
     * @param createAutoMlJobRequest
     * @return A Java Future containing the result of the CreateAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAutoMlJobResponse> createAutoMLJob(CreateAutoMlJobRequest createAutoMlJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAutoMlJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAutoMLJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAutoMlJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAutoMlJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAutoMlJobRequest, CreateAutoMlJobResponse>()
                            .withOperationName("CreateAutoMLJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAutoMlJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAutoMlJobRequest));
            CompletableFuture<CreateAutoMlJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <p>
     * AutoML jobs V2 support various problem types such as regression, binary, and multiclass classification with
     * tabular data, text and image classification, time-series forecasting, and fine-tuning of large language models
     * (LLMs) for text generation.
     * </p>
     * <note>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a> are new versions of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>
     * which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html"
     * >AutoMLProblemTypeConfig</a>.
     * </p>
     * <p>
     * You can find the best-performing model after you run an AutoML job V2 by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a>.
     * </p>
     *
     * @param createAutoMlJobV2Request
     * @return A Java Future containing the result of the CreateAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAutoMlJobV2Response> createAutoMLJobV2(CreateAutoMlJobV2Request createAutoMlJobV2Request) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAutoMlJobV2Request,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAutoMlJobV2Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAutoMLJobV2");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAutoMlJobV2Response> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAutoMlJobV2Response::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAutoMlJobV2Response> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAutoMlJobV2Request, CreateAutoMlJobV2Response>()
                            .withOperationName("CreateAutoMLJobV2").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAutoMlJobV2RequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAutoMlJobV2Request));
            CompletableFuture<CreateAutoMlJobV2Response> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing
     * persistent clusters for developing large machine learning models, such as large language models (LLMs) and
     * diffusion models. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in
     * the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterRequest, CreateClusterResponse>()
                            .withOperationName("CreateCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterRequest));
            CompletableFuture<CreateClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of
     * idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param createClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the CreateClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterSchedulerConfigResponse> createClusterSchedulerConfig(
            CreateClusterSchedulerConfigRequest createClusterSchedulerConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterSchedulerConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterSchedulerConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClusterSchedulerConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateClusterSchedulerConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateClusterSchedulerConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateClusterSchedulerConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterSchedulerConfigRequest, CreateClusterSchedulerConfigResponse>()
                            .withOperationName("CreateClusterSchedulerConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterSchedulerConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterSchedulerConfigRequest));
            CompletableFuture<CreateClusterSchedulerConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return A Java Future containing the result of the CreateCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCodeRepositoryResponse> createCodeRepository(
            CreateCodeRepositoryRequest createCodeRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCodeRepositoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCodeRepositoryRequest, CreateCodeRepositoryResponse>()
                            .withOperationName("CreateCodeRepository").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCodeRepositoryRequest));
            CompletableFuture<CreateCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker AI hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker AI assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html"
     * >StopCompilationJob</a>. To get information about a particular model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html"
     * >DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return A Java Future containing the result of the CreateCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCompilationJobResponse> createCompilationJob(
            CreateCompilationJobRequest createCompilationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCompilationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCompilationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCompilationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCompilationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCompilationJobRequest, CreateCompilationJobResponse>()
                            .withOperationName("CreateCompilationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCompilationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCompilationJobRequest));
            CompletableFuture<CreateCompilationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified
     * entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified
     * entities.
     * </p>
     *
     * @param createComputeQuotaRequest
     * @return A Java Future containing the result of the CreateComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComputeQuotaResponse> createComputeQuota(CreateComputeQuotaRequest createComputeQuotaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComputeQuotaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComputeQuotaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComputeQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComputeQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComputeQuotaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateComputeQuotaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComputeQuotaRequest, CreateComputeQuotaResponse>()
                            .withOperationName("CreateComputeQuota").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateComputeQuotaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createComputeQuotaRequest));
            CompletableFuture<CreateComputeQuotaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createContextRequest
     * @return A Java Future containing the result of the CreateContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContextResponse> createContext(CreateContextRequest createContextRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContextRequest, CreateContextResponse>()
                            .withOperationName("CreateContext").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContextRequest));
            CompletableFuture<CreateContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataQualityJobDefinitionResponse> createDataQualityJobDefinition(
            CreateDataQualityJobDefinitionRequest createDataQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataQualityJobDefinitionRequest, CreateDataQualityJobDefinitionResponse>()
                            .withOperationName("CreateDataQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataQualityJobDefinitionRequest));
            CompletableFuture<CreateDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     *
     * @param createDeviceFleetRequest
     * @return A Java Future containing the result of the CreateDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceFleetResponse> createDeviceFleet(CreateDeviceFleetRequest createDeviceFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeviceFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceFleetRequest, CreateDeviceFleetResponse>()
                            .withOperationName("CreateDeviceFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeviceFleetRequest));
            CompletableFuture<CreateDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of
     * authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC)
     * configurations. Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker AI uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS
     * volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can
     * specify a customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other
     * traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code>
     * corresponds to the network access type that you choose when you onboard to the domain. The following options are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by
     * default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or
     * host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and
     * your security groups allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * Amazon SageMaker AI Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon
     * SageMaker AI Studio Notebooks to Resources in a VPC</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                            .withOperationName("CreateDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDomainRequest));
            CompletableFuture<CreateDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgeDeploymentPlanResponse> createEdgeDeploymentPlan(
            CreateEdgeDeploymentPlanRequest createEdgeDeploymentPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEdgeDeploymentPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentPlanRequest, CreateEdgeDeploymentPlanResponse>()
                            .withOperationName("CreateEdgeDeploymentPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEdgeDeploymentPlanRequest));
            CompletableFuture<CreateEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgeDeploymentStageResponse> createEdgeDeploymentStage(
            CreateEdgeDeploymentStageRequest createEdgeDeploymentStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEdgeDeploymentStageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgeDeploymentStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgeDeploymentStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgeDeploymentStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgeDeploymentStageRequest, CreateEdgeDeploymentStageResponse>()
                            .withOperationName("CreateEdgeDeploymentStage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEdgeDeploymentStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEdgeDeploymentStageRequest));
            CompletableFuture<CreateEdgeDeploymentStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     *
     * @param createEdgePackagingJobRequest
     * @return A Java Future containing the result of the CreateEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEdgePackagingJobResponse> createEdgePackagingJob(
            CreateEdgePackagingJobRequest createEdgePackagingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEdgePackagingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEdgePackagingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEdgePackagingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEdgePackagingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEdgePackagingJobRequest, CreateEdgePackagingJobResponse>()
                            .withOperationName("CreateEdgePackagingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEdgePackagingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEdgePackagingJobRequest));
            CompletableFuture<CreateEdgePackagingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a> API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a>
     * API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web
     * Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
     * and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Identity and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig</a> API operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                            .withOperationName("CreateEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointRequest));
            CompletableFuture<CreateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     *
     * @param createEndpointConfigRequest
     * @return A Java Future containing the result of the CreateEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointConfigResponse> createEndpointConfig(
            CreateEndpointConfigRequest createEndpointConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointConfigRequest, CreateEndpointConfigResponse>()
                            .withOperationName("CreateEndpointConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointConfigRequest));
            CompletableFuture<CreateEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared
     * and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine
     * learning model.
     * </p>
     * <note>
     * <p>
     * In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as
     * <i>runs</i>.
     * </p>
     * </note>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>
     * API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a>
     * API. To view an experiment's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html"
     * >DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To
     * create a trial call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.
     * </p>
     *
     * @param createExperimentRequest
     * @return A Java Future containing the result of the CreateExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExperimentResponse> createExperiment(CreateExperimentRequest createExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExperimentRequest, CreateExperimentResponse>()
                            .withOperationName("CreateExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createExperimentRequest));
            CompletableFuture<CreateExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code>
     * <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important>
     *
     * @param createFeatureGroupRequest
     * @return A Java Future containing the result of the CreateFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFeatureGroupResponse> createFeatureGroup(CreateFeatureGroupRequest createFeatureGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFeatureGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFeatureGroupRequest, CreateFeatureGroupResponse>()
                            .withOperationName("CreateFeatureGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFeatureGroupRequest));
            CompletableFuture<CreateFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     *
     * @param createFlowDefinitionRequest
     * @return A Java Future containing the result of the CreateFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowDefinitionResponse> createFlowDefinition(
            CreateFlowDefinitionRequest createFlowDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowDefinitionRequest, CreateFlowDefinitionResponse>()
                            .withOperationName("CreateFlowDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFlowDefinitionRequest));
            CompletableFuture<CreateFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a hub.
     * </p>
     *
     * @param createHubRequest
     * @return A Java Future containing the result of the CreateHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHub" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHubResponse> createHub(CreateHubRequest createHubRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHubRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHubRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHub");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHubResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateHubResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHubResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHubRequest, CreateHubResponse>().withOperationName("CreateHub")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHubRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createHubRequest));
            CompletableFuture<CreateHubResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
     * </p>
     *
     * @param createHubContentReferenceRequest
     * @return A Java Future containing the result of the CreateHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHubContentReferenceResponse> createHubContentReference(
            CreateHubContentReferenceRequest createHubContentReferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHubContentReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHubContentReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHubContentReference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHubContentReferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHubContentReferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHubContentReferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHubContentReferenceRequest, CreateHubContentReferenceResponse>()
                            .withOperationName("CreateHubContentReference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHubContentReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHubContentReferenceRequest));
            CompletableFuture<CreateHubContentReferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     *
     * @param createHumanTaskUiRequest
     * @return A Java Future containing the result of the CreateHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHumanTaskUiResponse> createHumanTaskUi(CreateHumanTaskUiRequest createHumanTaskUiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHumanTaskUiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHumanTaskUiRequest, CreateHumanTaskUiResponse>()
                            .withOperationName("CreateHumanTaskUi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHumanTaskUiRequest));
            CompletableFuture<CreateHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <p>
     * A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for
     * each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View
     * Experiments, Trials, and Trial Components</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by any security-sensitive
     * information included in the request hyperparameter variable or plain text fields..
     * </p>
     * </important>
     *
     * @param createHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the CreateHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHyperParameterTuningJobResponse> createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHyperParameterTuningJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHyperParameterTuningJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHyperParameterTuningJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateHyperParameterTuningJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHyperParameterTuningJobRequest, CreateHyperParameterTuningJobResponse>()
                            .withOperationName("CreateHyperParameterTuningJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHyperParameterTuningJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHyperParameterTuningJobRequest));
            CompletableFuture<CreateHyperParameterTuningJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version
     * represents a container image stored in Amazon ECR. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker AI image</a>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImageRequest));
            CompletableFuture<CreateImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a version of the SageMaker AI image specified by <code>ImageName</code>. The version represents the
     * Amazon ECR container image specified by <code>BaseImage</code>.
     * </p>
     *
     * @param createImageVersionRequest
     * @return A Java Future containing the result of the CreateImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageVersionResponse> createImageVersion(CreateImageVersionRequest createImageVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageVersionRequest, CreateImageVersionResponse>()
                            .withOperationName("CreateImageVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImageVersionRequest));
            CompletableFuture<CreateImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an
     * endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes
     * the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU
     * cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where
     * each inference component contains one model and the resource utilization needs for that individual model. After
     * you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint
     * API action.
     * </p>
     *
     * @param createInferenceComponentRequest
     * @return A Java Future containing the result of the CreateInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInferenceComponentResponse> createInferenceComponent(
            CreateInferenceComponentRequest createInferenceComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInferenceComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInferenceComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInferenceComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInferenceComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInferenceComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInferenceComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInferenceComponentRequest, CreateInferenceComponentResponse>()
                            .withOperationName("CreateInferenceComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInferenceComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInferenceComponentRequest));
            CompletableFuture<CreateInferenceComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an inference experiment using the configurations specified in the request.
     * </p>
     * <p>
     * Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference
     * endpoint. For more information about inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>.
     * </p>
     * <p>
     * Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model
     * variants based on your specified configuration.
     * </p>
     * <p>
     * While the experiment is in progress or after it has concluded, you can view metrics that compare your model
     * variants. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and
     * edit shadow tests</a>.
     * </p>
     *
     * @param createInferenceExperimentRequest
     * @return A Java Future containing the result of the CreateInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInferenceExperimentResponse> createInferenceExperiment(
            CreateInferenceExperimentRequest createInferenceExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInferenceExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInferenceExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInferenceExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInferenceExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInferenceExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInferenceExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInferenceExperimentRequest, CreateInferenceExperimentResponse>()
                            .withOperationName("CreateInferenceExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInferenceExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInferenceExperimentRequest));
            CompletableFuture<CreateInferenceExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the CreateInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInferenceRecommendationsJobResponse> createInferenceRecommendationsJob(
            CreateInferenceRecommendationsJobRequest createInferenceRecommendationsJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInferenceRecommendationsJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInferenceRecommendationsJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInferenceRecommendationsJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateInferenceRecommendationsJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInferenceRecommendationsJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInferenceRecommendationsJobRequest, CreateInferenceRecommendationsJobResponse>()
                            .withOperationName("CreateInferenceRecommendationsJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInferenceRecommendationsJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInferenceRecommendationsJobRequest));
            CompletableFuture<CreateInferenceRecommendationsJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return A Java Future containing the result of the CreateLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLabelingJobResponse> createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLabelingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLabelingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLabelingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLabelingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLabelingJobRequest, CreateLabelingJobResponse>()
                            .withOperationName("CreateLabelingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLabelingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLabelingJobRequest));
            CompletableFuture<CreateLabelingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow
     * Tracking Server</a>.
     * </p>
     *
     * @param createMlflowTrackingServerRequest
     * @return A Java Future containing the result of the CreateMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMlflowTrackingServerResponse> createMlflowTrackingServer(
            CreateMlflowTrackingServerRequest createMlflowTrackingServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMlflowTrackingServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlflowTrackingServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMlflowTrackingServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMlflowTrackingServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMlflowTrackingServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMlflowTrackingServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMlflowTrackingServerRequest, CreateMlflowTrackingServerResponse>()
                            .withOperationName("CreateMlflowTrackingServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMlflowTrackingServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMlflowTrackingServerRequest));
            CompletableFuture<CreateMlflowTrackingServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                            .withOperationName("CreateModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelRequest));
            CompletableFuture<CreateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelBiasJobDefinitionResponse> createModelBiasJobDefinition(
            CreateModelBiasJobDefinitionRequest createModelBiasJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelBiasJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelBiasJobDefinitionRequest, CreateModelBiasJobDefinitionResponse>()
                            .withOperationName("CreateModelBiasJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelBiasJobDefinitionRequest));
            CompletableFuture<CreateModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card.
     * </p>
     * <p>
     * For information about how to use model cards, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.
     * </p>
     *
     * @param createModelCardRequest
     * @return A Java Future containing the result of the CreateModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelCardResponse> createModelCard(CreateModelCardRequest createModelCardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelCardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelCardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelCard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelCardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelCardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelCardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelCardRequest, CreateModelCardResponse>()
                            .withOperationName("CreateModelCard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelCardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelCardRequest));
            CompletableFuture<CreateModelCardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param createModelCardExportJobRequest
     * @return A Java Future containing the result of the CreateModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelCardExportJobResponse> createModelCardExportJob(
            CreateModelCardExportJobRequest createModelCardExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelCardExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelCardExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelCardExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelCardExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelCardExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelCardExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelCardExportJobRequest, CreateModelCardExportJobResponse>()
                            .withOperationName("CreateModelCardExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelCardExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelCardExportJobRequest));
            CompletableFuture<CreateModelCardExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> createModelExplainabilityJobDefinition(
            CreateModelExplainabilityJobDefinitionRequest createModelExplainabilityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelExplainabilityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelExplainabilityJobDefinitionRequest, CreateModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("CreateModelExplainabilityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelExplainabilityJobDefinitionRequest));
            CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createModelPackageRequest
     * @return A Java Future containing the result of the CreateModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelPackageResponse> createModelPackage(CreateModelPackageRequest createModelPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelPackageRequest, CreateModelPackageResponse>()
                            .withOperationName("CreateModelPackage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelPackageRequest));
            CompletableFuture<CreateModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     *
     * @param createModelPackageGroupRequest
     * @return A Java Future containing the result of the CreateModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelPackageGroupResponse> createModelPackageGroup(
            CreateModelPackageGroupRequest createModelPackageGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelPackageGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelPackageGroupRequest, CreateModelPackageGroupResponse>()
                            .withOperationName("CreateModelPackageGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelPackageGroupRequest));
            CompletableFuture<CreateModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateModelQualityJobDefinitionResponse> createModelQualityJobDefinition(
            CreateModelQualityJobDefinitionRequest createModelQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelQualityJobDefinitionRequest, CreateModelQualityJobDefinitionResponse>()
                            .withOperationName("CreateModelQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelQualityJobDefinitionRequest));
            CompletableFuture<CreateModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an
     * Amazon SageMaker AI Endpoint.
     * </p>
     *
     * @param createMonitoringScheduleRequest
     * @return A Java Future containing the result of the CreateMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMonitoringScheduleResponse> createMonitoringSchedule(
            CreateMonitoringScheduleRequest createMonitoringScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMonitoringScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMonitoringScheduleRequest, CreateMonitoringScheduleResponse>()
                            .withOperationName("CreateMonitoringSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMonitoringScheduleRequest));
            CompletableFuture<CreateMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker AI launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker AI also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker AI with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker AI does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker AI VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker AI creates a network interface in your own VPC, which
     * is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker AI
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker AI VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker AI specifies both network interfaces when launching this instance.
     * This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow
     * it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker AI returns its Amazon Resource Name (ARN). You can't change the
     * name of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker AI creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker AI endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return A Java Future containing the result of the CreateNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNotebookInstanceResponse> createNotebookInstance(
            CreateNotebookInstanceRequest createNotebookInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNotebookInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceRequest, CreateNotebookInstanceResponse>()
                            .withOperationName("CreateNotebookInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNotebookInstanceRequest));
            CompletableFuture<CreateNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNotebookInstanceLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNotebookInstanceLifecycleConfigRequest, CreateNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("CreateNotebookInstanceLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a
     * source model, and you provide the settings for the optimization techniques that you want the job to apply. When
     * the job completes successfully, SageMaker uploads the new optimized model to the output destination that you
     * specify.
     * </p>
     * <p>
     * For more information about how to use this action, and about the supported optimization techniques, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon
     * SageMaker</a>.
     * </p>
     *
     * @param createOptimizationJobRequest
     * @return A Java Future containing the result of the CreateOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOptimizationJobResponse> createOptimizationJob(
            CreateOptimizationJobRequest createOptimizationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOptimizationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOptimizationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOptimizationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOptimizationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOptimizationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOptimizationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOptimizationJobRequest, CreateOptimizationJobResponse>()
                            .withOperationName("CreateOptimizationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOptimizationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOptimizationJobRequest));
            CompletableFuture<CreateOptimizationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppRequest
     * @return A Java Future containing the result of the CreatePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePartnerAppResponse> createPartnerApp(CreatePartnerAppRequest createPartnerAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartnerAppRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartnerAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartnerApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePartnerAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePartnerAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePartnerAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePartnerAppRequest, CreatePartnerAppResponse>()
                            .withOperationName("CreatePartnerApp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePartnerAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPartnerAppRequest));
            CompletableFuture<CreatePartnerAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a presigned URL to access an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppPresignedUrlRequest
     * @return A Java Future containing the result of the CreatePartnerAppPresignedUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerAppPresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerAppPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePartnerAppPresignedUrlResponse> createPartnerAppPresignedUrl(
            CreatePartnerAppPresignedUrlRequest createPartnerAppPresignedUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartnerAppPresignedUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartnerAppPresignedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartnerAppPresignedUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePartnerAppPresignedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePartnerAppPresignedUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePartnerAppPresignedUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePartnerAppPresignedUrlRequest, CreatePartnerAppPresignedUrlResponse>()
                            .withOperationName("CreatePartnerAppPresignedUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePartnerAppPresignedUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPartnerAppPresignedUrlRequest));
            CompletableFuture<CreatePartnerAppPresignedUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     *
     * @param createPipelineRequest
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePipelineRequest, CreatePipelineResponse>()
                            .withOperationName("CreatePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPipelineRequest));
            CompletableFuture<CreatePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to the domain, and granted access to all of the Apps and files associated with the
     * Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals
     * IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker
     * AI Studio Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </li>
     * <li>
     * <p>
     * The JupyterLab session default expiration time is 12 hours. You can configure this value using
     * SessionExpirationDurationInSeconds.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createPresignedDomainUrlRequest
     * @return A Java Future containing the result of the CreatePresignedDomainUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedDomainUrlResponse> createPresignedDomainUrl(
            CreatePresignedDomainUrlRequest createPresignedDomainUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedDomainUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedDomainUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedDomainUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedDomainUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePresignedDomainUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedDomainUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedDomainUrlRequest, CreatePresignedDomainUrlResponse>()
                            .withOperationName("CreatePresignedDomainUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePresignedDomainUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPresignedDomainUrlRequest));
            CompletableFuture<CreatePresignedDomainUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the
     * MLflow UI using a presigned URL</a>.
     * </p>
     *
     * @param createPresignedMlflowTrackingServerUrlRequest
     * @return A Java Future containing the result of the CreatePresignedMlflowTrackingServerUrl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedMlflowTrackingServerUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedMlflowTrackingServerUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedMlflowTrackingServerUrlResponse> createPresignedMlflowTrackingServerUrl(
            CreatePresignedMlflowTrackingServerUrlRequest createPresignedMlflowTrackingServerUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedMlflowTrackingServerUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPresignedMlflowTrackingServerUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedMlflowTrackingServerUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedMlflowTrackingServerUrlResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreatePresignedMlflowTrackingServerUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedMlflowTrackingServerUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedMlflowTrackingServerUrlRequest, CreatePresignedMlflowTrackingServerUrlResponse>()
                            .withOperationName("CreatePresignedMlflowTrackingServerUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePresignedMlflowTrackingServerUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPresignedMlflowTrackingServerUrlRequest));
            CompletableFuture<CreatePresignedMlflowTrackingServerUrlResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker AI opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html"
     * >CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return A Java Future containing the result of the CreatePresignedNotebookInstanceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedNotebookInstanceUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPresignedNotebookInstanceUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookInstanceUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePresignedNotebookInstanceUrlResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreatePresignedNotebookInstanceUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedNotebookInstanceUrlRequest, CreatePresignedNotebookInstanceUrlResponse>()
                            .withOperationName("CreatePresignedNotebookInstanceUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePresignedNotebookInstanceUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPresignedNotebookInstanceUrlRequest));
            CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     *
     * @param createProcessingJobRequest
     * @return A Java Future containing the result of the CreateProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProcessingJobResponse> createProcessingJob(
            CreateProcessingJobRequest createProcessingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProcessingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProcessingJobRequest, CreateProcessingJobResponse>()
                            .withOperationName("CreateProcessingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProcessingJobRequest));
            CompletableFuture<CreateProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                            .withOperationName("CreateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProjectRequest));
            CompletableFuture<CreateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a private space or a space used for real time collaboration in a domain.
     * </p>
     *
     * @param createSpaceRequest
     * @return A Java Future containing the result of the CreateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSpaceResponse> createSpace(CreateSpaceRequest createSpaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSpaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSpaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSpaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSpaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSpaceRequest, CreateSpaceResponse>()
                            .withOperationName("CreateSpace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSpaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSpaceRequest));
            CompletableFuture<CreateSpaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStudioLifecycleConfigResponse> createStudioLifecycleConfig(
            CreateStudioLifecycleConfigRequest createStudioLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStudioLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStudioLifecycleConfigRequest, CreateStudioLifecycleConfigResponse>()
                            .withOperationName("CreateStudioLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStudioLifecycleConfigRequest));
            CompletableFuture<CreateStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by security-sensitive information
     * included in the request hyperparameter variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx
     * location where it is stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * environment fields. As part of the shared responsibility model, you are responsible for any potential exposure,
     * unauthorized access, or compromise of your sensitive data if caused by security-sensitive information included in
     * the request environment variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return A Java Future containing the result of the CreateTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrainingJobResponse> createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrainingJobRequest, CreateTrainingJobResponse>()
                            .withOperationName("CreateTrainingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrainingJobRequest));
            CompletableFuture<CreateTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new training plan in SageMaker to reserve compute capacity.
     * </p>
     * <p>
     * Amazon SageMaker Training Plan is a capability within SageMaker that allows customers to reserve and manage GPU
     * capacity for large-scale AI model training. It provides a way to secure predictable access to computational
     * resources within specific timelines and budgets, without the need to manage underlying infrastructure.
     * </p>
     * <p>
     * <b>How it works</b>
     * </p>
     * <p>
     * Plans can be created for specific resources such as SageMaker Training Jobs or SageMaker HyperPod clusters,
     * automatically provisioning resources, setting up infrastructure, executing workloads, and handling infrastructure
     * failures.
     * </p>
     * <p>
     * <b>Plan creation workflow</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users search for available plan offerings based on their requirements (e.g., instance type, count, start time,
     * duration) using the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html">SearchTrainingPlanOfferings</a> </code>
     * API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * They create a plan that best matches their needs using the ID of the plan offering they want to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * After successful upfront payment, the plan's status becomes <code>Scheduled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The plan can be used to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queue training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allocate to an instance group of a SageMaker HyperPod cluster.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When the plan start date arrives, it becomes <code>Active</code>. Based on available reserved capacity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Training jobs are launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance groups are provisioned.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Plan composition</b>
     * </p>
     * <p>
     * A plan can consist of one or more Reserved Capacities, each defined by a specific instance type, quantity,
     * Availability Zone, duration, and start and end times. For more information about Reserved Capacity, see
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html">ReservedCapacitySummary</a> </code>
     * .
     * </p>
     *
     * @param createTrainingPlanRequest
     * @return A Java Future containing the result of the CreateTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrainingPlanResponse> createTrainingPlan(CreateTrainingPlanRequest createTrainingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrainingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrainingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrainingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrainingPlanRequest, CreateTrainingPlanResponse>()
                            .withOperationName("CreateTrainingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrainingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrainingPlanRequest));
            CompletableFuture<CreateTrainingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances and AMI image versions for the transform
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return A Java Future containing the result of the CreateTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransformJobResponse> createTransformJob(CreateTransformJobRequest createTransformJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransformJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransformJobRequest, CreateTransformJobResponse>()
                            .withOperationName("CreateTransformJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransformJobRequest));
            CompletableFuture<CreateTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view
     * a trial's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To
     * create a trial component, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
     * >CreateTrialComponent</a> API.
     * </p>
     *
     * @param createTrialRequest
     * @return A Java Future containing the result of the CreateTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrialResponse> createTrial(CreateTrialRequest createTrialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrialRequest, CreateTrialResponse>()
                            .withOperationName("CreateTrial").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrialRequest));
            CompletableFuture<CreateTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     *
     * @param createTrialComponentRequest
     * @return A Java Future containing the result of the CreateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrialComponentResponse> createTrialComponent(
            CreateTrialComponentRequest createTrialComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrialComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrialComponentRequest, CreateTrialComponentResponse>()
                            .withOperationName("CreateTrialComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrialComponentRequest));
            CompletableFuture<CreateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity
     * Center, a user profile is automatically created. A user profile is the primary holder of settings for an
     * individual user and has a reference to the user's private Amazon Elastic File System home directory.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserProfileRequest, CreateUserProfileResponse>()
                            .withOperationName("CreateUserProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserProfileRequest));
            CompletableFuture<CreateUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a>
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     *
     * @param createWorkforceRequest
     * @return A Java Future containing the result of the CreateWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkforceResponse> createWorkforce(CreateWorkforceRequest createWorkforceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkforceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkforceRequest, CreateWorkforceResponse>()
                            .withOperationName("CreateWorkforce").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkforceRequest));
            CompletableFuture<CreateWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return A Java Future containing the result of the CreateWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkteamResponse> createWorkteam(CreateWorkteamRequest createWorkteamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkteamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkteamRequest, CreateWorkteamResponse>()
                            .withOperationName("CreateWorkteam").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkteamRequest));
            CompletableFuture<CreateWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     *
     * @param deleteActionRequest
     * @return A Java Future containing the result of the DeleteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteActionResponse> deleteAction(DeleteActionRequest deleteActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteActionRequest, DeleteActionResponse>()
                            .withOperationName("DeleteAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteActionRequest));
            CompletableFuture<DeleteActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return A Java Future containing the result of the DeleteAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAlgorithmResponse> deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAlgorithmRequest, DeleteAlgorithmResponse>()
                            .withOperationName("DeleteAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAlgorithmRequest));
            CompletableFuture<DeleteAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>().withOperationName("DeleteApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAppRequest));
            CompletableFuture<DeleteAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     *
     * @param deleteAppImageConfigRequest
     * @return A Java Future containing the result of the DeleteAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppImageConfigResponse> deleteAppImageConfig(
            DeleteAppImageConfigRequest deleteAppImageConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppImageConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppImageConfigRequest, DeleteAppImageConfigResponse>()
                            .withOperationName("DeleteAppImageConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppImageConfigRequest));
            CompletableFuture<DeleteAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     *
     * @param deleteArtifactRequest
     * @return A Java Future containing the result of the DeleteArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteArtifactResponse> deleteArtifact(DeleteArtifactRequest deleteArtifactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteArtifactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteArtifactRequest, DeleteArtifactResponse>()
                            .withOperationName("DeleteArtifact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteArtifactRequest));
            CompletableFuture<DeleteArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                            .withOperationName("DeleteAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssociationRequest));
            CompletableFuture<DeleteAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a SageMaker HyperPod cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterRequest, DeleteClusterResponse>()
                            .withOperationName("DeleteCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterRequest));
            CompletableFuture<DeleteClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the cluster policy of the cluster.
     * </p>
     *
     * @param deleteClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the DeleteClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterSchedulerConfigResponse> deleteClusterSchedulerConfig(
            DeleteClusterSchedulerConfigRequest deleteClusterSchedulerConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterSchedulerConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterSchedulerConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClusterSchedulerConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteClusterSchedulerConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteClusterSchedulerConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteClusterSchedulerConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterSchedulerConfigRequest, DeleteClusterSchedulerConfigResponse>()
                            .withOperationName("DeleteClusterSchedulerConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterSchedulerConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterSchedulerConfigRequest));
            CompletableFuture<DeleteClusterSchedulerConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return A Java Future containing the result of the DeleteCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCodeRepositoryResponse> deleteCodeRepository(
            DeleteCodeRepositoryRequest deleteCodeRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCodeRepositoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCodeRepositoryRequest, DeleteCodeRepositoryResponse>()
                            .withOperationName("DeleteCodeRepository").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCodeRepositoryRequest));
            CompletableFuture<DeleteCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker
     * AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job
     * creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
     * </p>
     * <p>
     * You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or
     * <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and
     * then delete it after its status becomes <code>STOPPED</code>.
     * </p>
     *
     * @param deleteCompilationJobRequest
     * @return A Java Future containing the result of the DeleteCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCompilationJobResponse> deleteCompilationJob(
            DeleteCompilationJobRequest deleteCompilationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCompilationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCompilationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCompilationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCompilationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCompilationJobRequest, DeleteCompilationJobResponse>()
                            .withOperationName("DeleteCompilationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCompilationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCompilationJobRequest));
            CompletableFuture<DeleteCompilationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the compute allocation from the cluster.
     * </p>
     *
     * @param deleteComputeQuotaRequest
     * @return A Java Future containing the result of the DeleteComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteComputeQuotaResponse> deleteComputeQuota(DeleteComputeQuotaRequest deleteComputeQuotaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteComputeQuotaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComputeQuotaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComputeQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteComputeQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteComputeQuotaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteComputeQuotaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteComputeQuotaRequest, DeleteComputeQuotaResponse>()
                            .withOperationName("DeleteComputeQuota").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteComputeQuotaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteComputeQuotaRequest));
            CompletableFuture<DeleteComputeQuotaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     *
     * @param deleteContextRequest
     * @return A Java Future containing the result of the DeleteContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContextResponse> deleteContext(DeleteContextRequest deleteContextRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContextRequest, DeleteContextResponse>()
                            .withOperationName("DeleteContext").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContextRequest));
            CompletableFuture<DeleteContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataQualityJobDefinitionResponse> deleteDataQualityJobDefinition(
            DeleteDataQualityJobDefinitionRequest deleteDataQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataQualityJobDefinitionRequest, DeleteDataQualityJobDefinitionResponse>()
                            .withOperationName("DeleteDataQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataQualityJobDefinitionRequest));
            CompletableFuture<DeleteDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteDeviceFleetRequest
     * @return A Java Future containing the result of the DeleteDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceFleetResponse> deleteDeviceFleet(DeleteDeviceFleetRequest deleteDeviceFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeviceFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceFleetRequest, DeleteDeviceFleetResponse>()
                            .withOperationName("DeleteDeviceFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeviceFleetRequest));
            CompletableFuture<DeleteDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                            .withOperationName("DeleteDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDomainRequest));
            CompletableFuture<DeleteDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEdgeDeploymentPlanResponse> deleteEdgeDeploymentPlan(
            DeleteEdgeDeploymentPlanRequest deleteEdgeDeploymentPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEdgeDeploymentPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentPlanRequest, DeleteEdgeDeploymentPlanResponse>()
                            .withOperationName("DeleteEdgeDeploymentPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEdgeDeploymentPlanRequest));
            CompletableFuture<DeleteEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEdgeDeploymentStageResponse> deleteEdgeDeploymentStage(
            DeleteEdgeDeploymentStageRequest deleteEdgeDeploymentStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEdgeDeploymentStageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEdgeDeploymentStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEdgeDeploymentStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEdgeDeploymentStageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEdgeDeploymentStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEdgeDeploymentStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEdgeDeploymentStageRequest, DeleteEdgeDeploymentStageResponse>()
                            .withOperationName("DeleteEdgeDeploymentStage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEdgeDeploymentStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEdgeDeploymentStageRequest));
            CompletableFuture<DeleteEdgeDeploymentStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointRequest));
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return A Java Future containing the result of the DeleteEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointConfigResponse> deleteEndpointConfig(
            DeleteEndpointConfigRequest deleteEndpointConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointConfigRequest, DeleteEndpointConfigResponse>()
                            .withOperationName("DeleteEndpointConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointConfigRequest));
            CompletableFuture<DeleteEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a
     * list of the trials associated with the experiment.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return A Java Future containing the result of the DeleteExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteExperimentResponse> deleteExperiment(DeleteExperimentRequest deleteExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteExperimentRequest, DeleteExperimentResponse>()
                            .withOperationName("DeleteExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteExperimentRequest));
            CompletableFuture<DeleteExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code>
     * with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     *
     * @param deleteFeatureGroupRequest
     * @return A Java Future containing the result of the DeleteFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFeatureGroupResponse> deleteFeatureGroup(DeleteFeatureGroupRequest deleteFeatureGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFeatureGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFeatureGroupRequest, DeleteFeatureGroupResponse>()
                            .withOperationName("DeleteFeatureGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFeatureGroupRequest));
            CompletableFuture<DeleteFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     * @return A Java Future containing the result of the DeleteFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowDefinitionResponse> deleteFlowDefinition(
            DeleteFlowDefinitionRequest deleteFlowDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowDefinitionRequest, DeleteFlowDefinitionResponse>()
                            .withOperationName("DeleteFlowDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFlowDefinitionRequest));
            CompletableFuture<DeleteFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a hub.
     * </p>
     *
     * @param deleteHubRequest
     * @return A Java Future containing the result of the DeleteHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHub" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHubResponse> deleteHub(DeleteHubRequest deleteHubRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHubRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHubRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHub");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHubResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteHubResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHubResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHubRequest, DeleteHubResponse>().withOperationName("DeleteHub")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHubRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteHubRequest));
            CompletableFuture<DeleteHubResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the contents of a hub.
     * </p>
     *
     * @param deleteHubContentRequest
     * @return A Java Future containing the result of the DeleteHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHubContentResponse> deleteHubContent(DeleteHubContentRequest deleteHubContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHubContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHubContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHubContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHubContentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteHubContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHubContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHubContentRequest, DeleteHubContentResponse>()
                            .withOperationName("DeleteHubContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHubContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHubContentRequest));
            CompletableFuture<DeleteHubContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a hub content reference in order to remove a model from a private hub.
     * </p>
     *
     * @param deleteHubContentReferenceRequest
     * @return A Java Future containing the result of the DeleteHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHubContentReferenceResponse> deleteHubContentReference(
            DeleteHubContentReferenceRequest deleteHubContentReferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHubContentReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHubContentReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHubContentReference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHubContentReferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteHubContentReferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHubContentReferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHubContentReferenceRequest, DeleteHubContentReferenceResponse>()
                            .withOperationName("DeleteHubContentReference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHubContentReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHubContentReferenceRequest));
            CompletableFuture<DeleteHubContentReferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>.
     * When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     * @return A Java Future containing the result of the DeleteHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHumanTaskUiResponse> deleteHumanTaskUi(DeleteHumanTaskUiRequest deleteHumanTaskUiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHumanTaskUiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHumanTaskUiRequest, DeleteHumanTaskUiResponse>()
                            .withOperationName("DeleteHumanTaskUi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHumanTaskUiRequest));
            CompletableFuture<DeleteHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning
     * job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It
     * does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
     * </p>
     *
     * @param deleteHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the DeleteHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHyperParameterTuningJobResponse> deleteHyperParameterTuningJob(
            DeleteHyperParameterTuningJobRequest deleteHyperParameterTuningJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHyperParameterTuningJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHyperParameterTuningJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteHyperParameterTuningJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteHyperParameterTuningJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHyperParameterTuningJobRequest, DeleteHyperParameterTuningJobResponse>()
                            .withOperationName("DeleteHyperParameterTuningJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHyperParameterTuningJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHyperParameterTuningJobRequest));
            CompletableFuture<DeleteHyperParameterTuningJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
     * </p>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                            .withOperationName("DeleteImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImageRequest));
            CompletableFuture<DeleteImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
     * </p>
     *
     * @param deleteImageVersionRequest
     * @return A Java Future containing the result of the DeleteImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImageVersionResponse> deleteImageVersion(DeleteImageVersionRequest deleteImageVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImageVersionRequest, DeleteImageVersionResponse>()
                            .withOperationName("DeleteImageVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImageVersionRequest));
            CompletableFuture<DeleteImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an inference component.
     * </p>
     *
     * @param deleteInferenceComponentRequest
     * @return A Java Future containing the result of the DeleteInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInferenceComponentResponse> deleteInferenceComponent(
            DeleteInferenceComponentRequest deleteInferenceComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInferenceComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInferenceComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInferenceComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInferenceComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInferenceComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInferenceComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInferenceComponentRequest, DeleteInferenceComponentResponse>()
                            .withOperationName("DeleteInferenceComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInferenceComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInferenceComponentRequest));
            CompletableFuture<DeleteInferenceComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an inference experiment.
     * </p>
     * <note>
     * <p>
     * This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes
     * the metadata of your experiment.
     * </p>
     * </note>
     *
     * @param deleteInferenceExperimentRequest
     * @return A Java Future containing the result of the DeleteInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInferenceExperimentResponse> deleteInferenceExperiment(
            DeleteInferenceExperimentRequest deleteInferenceExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInferenceExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInferenceExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInferenceExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInferenceExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInferenceExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInferenceExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInferenceExperimentRequest, DeleteInferenceExperimentResponse>()
                            .withOperationName("DeleteInferenceExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInferenceExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInferenceExperimentRequest));
            CompletableFuture<DeleteInferenceExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an MLflow Tracking Server. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.
     * </p>
     *
     * @param deleteMlflowTrackingServerRequest
     * @return A Java Future containing the result of the DeleteMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMlflowTrackingServerResponse> deleteMlflowTrackingServer(
            DeleteMlflowTrackingServerRequest deleteMlflowTrackingServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlflowTrackingServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlflowTrackingServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMlflowTrackingServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMlflowTrackingServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMlflowTrackingServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMlflowTrackingServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMlflowTrackingServerRequest, DeleteMlflowTrackingServerResponse>()
                            .withOperationName("DeleteMlflowTrackingServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMlflowTrackingServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMlflowTrackingServerRequest));
            CompletableFuture<DeleteMlflowTrackingServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                            .withOperationName("DeleteModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelRequest));
            CompletableFuture<DeleteModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model bias job definition.
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelBiasJobDefinitionResponse> deleteModelBiasJobDefinition(
            DeleteModelBiasJobDefinitionRequest deleteModelBiasJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelBiasJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelBiasJobDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelBiasJobDefinitionRequest, DeleteModelBiasJobDefinitionResponse>()
                            .withOperationName("DeleteModelBiasJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelBiasJobDefinitionRequest));
            CompletableFuture<DeleteModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker Model Card.
     * </p>
     *
     * @param deleteModelCardRequest
     * @return A Java Future containing the result of the DeleteModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelCardResponse> deleteModelCard(DeleteModelCardRequest deleteModelCardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelCardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelCardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelCard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelCardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelCardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelCardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelCardRequest, DeleteModelCardResponse>()
                            .withOperationName("DeleteModelCard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelCardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelCardRequest));
            CompletableFuture<DeleteModelCardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model explainability job definition.
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> deleteModelExplainabilityJobDefinition(
            DeleteModelExplainabilityJobDefinitionRequest deleteModelExplainabilityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelExplainabilityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelExplainabilityJobDefinitionRequest, DeleteModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DeleteModelExplainabilityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelExplainabilityJobDefinitionRequest));
            CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return A Java Future containing the result of the DeleteModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageResponse> deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageRequest, DeleteModelPackageResponse>()
                            .withOperationName("DeleteModelPackage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelPackageRequest));
            CompletableFuture<DeleteModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageGroupResponse> deleteModelPackageGroup(
            DeleteModelPackageGroupRequest deleteModelPackageGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelPackageGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupRequest, DeleteModelPackageGroupResponse>()
                            .withOperationName("DeleteModelPackageGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelPackageGroupRequest));
            CompletableFuture<DeleteModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelPackageGroupPolicyResponse> deleteModelPackageGroupPolicy(
            DeleteModelPackageGroupPolicyRequest deleteModelPackageGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelPackageGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelPackageGroupPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelPackageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelPackageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelPackageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelPackageGroupPolicyRequest, DeleteModelPackageGroupPolicyResponse>()
                            .withOperationName("DeleteModelPackageGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelPackageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelPackageGroupPolicyRequest));
            CompletableFuture<DeleteModelPackageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteModelQualityJobDefinitionResponse> deleteModelQualityJobDefinition(
            DeleteModelQualityJobDefinitionRequest deleteModelQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelQualityJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelQualityJobDefinitionRequest, DeleteModelQualityJobDefinitionResponse>()
                            .withOperationName("DeleteModelQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelQualityJobDefinitionRequest));
            CompletableFuture<DeleteModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     * @return A Java Future containing the result of the DeleteMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMonitoringScheduleResponse> deleteMonitoringSchedule(
            DeleteMonitoringScheduleRequest deleteMonitoringScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMonitoringScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitoringScheduleRequest, DeleteMonitoringScheduleResponse>()
                            .withOperationName("DeleteMonitoringSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMonitoringScheduleRequest));
            CompletableFuture<DeleteMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker AI removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return A Java Future containing the result of the DeleteNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotebookInstanceResponse> deleteNotebookInstance(
            DeleteNotebookInstanceRequest deleteNotebookInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNotebookInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceRequest, DeleteNotebookInstanceResponse>()
                            .withOperationName("DeleteNotebookInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNotebookInstanceRequest));
            CompletableFuture<DeleteNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNotebookInstanceLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNotebookInstanceLifecycleConfigRequest, DeleteNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DeleteNotebookInstanceLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an optimization job.
     * </p>
     *
     * @param deleteOptimizationJobRequest
     * @return A Java Future containing the result of the DeleteOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOptimizationJobResponse> deleteOptimizationJob(
            DeleteOptimizationJobRequest deleteOptimizationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOptimizationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptimizationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptimizationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOptimizationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOptimizationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOptimizationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOptimizationJobRequest, DeleteOptimizationJobResponse>()
                            .withOperationName("DeleteOptimizationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOptimizationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOptimizationJobRequest));
            CompletableFuture<DeleteOptimizationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a SageMaker Partner AI App.
     * </p>
     *
     * @param deletePartnerAppRequest
     * @return A Java Future containing the result of the DeletePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePartnerAppResponse> deletePartnerApp(DeletePartnerAppRequest deletePartnerAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePartnerAppRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePartnerAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePartnerApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePartnerAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePartnerAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePartnerAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePartnerAppRequest, DeletePartnerAppResponse>()
                            .withOperationName("DeletePartnerApp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePartnerAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePartnerAppRequest));
            CompletableFuture<DeletePartnerAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     *
     * @param deletePipelineRequest
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePipelineRequest, DeletePipelineResponse>()
                            .withOperationName("DeletePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePipelineRequest));
            CompletableFuture<DeletePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                            .withOperationName("DeleteProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProjectRequest));
            CompletableFuture<DeleteProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to delete a space.
     * </p>
     *
     * @param deleteSpaceRequest
     * @return A Java Future containing the result of the DeleteSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSpaceResponse> deleteSpace(DeleteSpaceRequest deleteSpaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSpaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSpaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSpaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSpaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSpaceRequest, DeleteSpaceResponse>()
                            .withOperationName("DeleteSpace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSpaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSpaceRequest));
            CompletableFuture<DeleteSpaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration,
     * there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration
     * from UserSettings in all Domains and UserProfiles.
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStudioLifecycleConfigResponse> deleteStudioLifecycleConfig(
            DeleteStudioLifecycleConfigRequest deleteStudioLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStudioLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioLifecycleConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioLifecycleConfigRequest, DeleteStudioLifecycleConfigResponse>()
                            .withOperationName("DeleteStudioLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStudioLifecycleConfigRequest));
            CompletableFuture<DeleteStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed
     * from Apps that the SageMaker Domain or User Profile launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTagsRequest));
            CompletableFuture<DeleteTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html"
     * >DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     *
     * @param deleteTrialRequest
     * @return A Java Future containing the result of the DeleteTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrialResponse> deleteTrial(DeleteTrialRequest deleteTrialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrialRequest, DeleteTrialResponse>()
                            .withOperationName("DeleteTrial").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrialRequest));
            CompletableFuture<DeleteTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param deleteTrialComponentRequest
     * @return A Java Future containing the result of the DeleteTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrialComponentResponse> deleteTrialComponent(
            DeleteTrialComponentRequest deleteTrialComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrialComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrialComponentRequest, DeleteTrialComponentResponse>()
                            .withOperationName("DeleteTrialComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrialComponentRequest));
            CompletableFuture<DeleteTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return A Java Future containing the result of the DeleteUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserProfileRequest, DeleteUserProfileResponse>()
                            .withOperationName("DeleteUserProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserProfileRequest));
            CompletableFuture<DeleteUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to
     * create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a>
     * operation to delete all work teams before you delete the workforce. If you try to delete a workforce that
     * contains one or more work teams, you will receive a <code>ResourceInUse</code> error.
     * </p>
     * </important>
     *
     * @param deleteWorkforceRequest
     * @return A Java Future containing the result of the DeleteWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkforceResponse> deleteWorkforce(DeleteWorkforceRequest deleteWorkforceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkforceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkforceRequest, DeleteWorkforceResponse>()
                            .withOperationName("DeleteWorkforce").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkforceRequest));
            CompletableFuture<DeleteWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return A Java Future containing the result of the DeleteWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkteamResponse> deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkteamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkteamRequest, DeleteWorkteamResponse>()
                            .withOperationName("DeleteWorkteam").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkteamRequest));
            CompletableFuture<DeleteWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     *
     * @param deregisterDevicesRequest
     * @return A Java Future containing the result of the DeregisterDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterDevicesResponse> deregisterDevices(DeregisterDevicesRequest deregisterDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterDevicesRequest, DeregisterDevicesResponse>()
                            .withOperationName("DeregisterDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterDevicesRequest));
            CompletableFuture<DeregisterDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     *
     * @param describeActionRequest
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeActionResponse> describeAction(DescribeActionRequest describeActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeActionRequest, DescribeActionResponse>()
                            .withOperationName("DescribeAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeActionRequest));
            CompletableFuture<DescribeActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return A Java Future containing the result of the DescribeAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlgorithmResponse> describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAlgorithmRequest, DescribeAlgorithmResponse>()
                            .withOperationName("DescribeAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAlgorithmRequest));
            CompletableFuture<DescribeAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     *
     * @param describeAppRequest
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppResponse> describeApp(DescribeAppRequest describeAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                            .withOperationName("DescribeApp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppRequest));
            CompletableFuture<DescribeAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     *
     * @param describeAppImageConfigRequest
     * @return A Java Future containing the result of the DescribeAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppImageConfigResponse> describeAppImageConfig(
            DescribeAppImageConfigRequest describeAppImageConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAppImageConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppImageConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppImageConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAppImageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAppImageConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAppImageConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAppImageConfigRequest, DescribeAppImageConfigResponse>()
                            .withOperationName("DescribeAppImageConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAppImageConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAppImageConfigRequest));
            CompletableFuture<DescribeAppImageConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     *
     * @param describeArtifactRequest
     * @return A Java Future containing the result of the DescribeArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeArtifactResponse> describeArtifact(DescribeArtifactRequest describeArtifactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeArtifactRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeArtifactRequest, DescribeArtifactResponse>()
                            .withOperationName("DescribeArtifact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeArtifactRequest));
            CompletableFuture<DescribeArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <note>
     * <p>
     * AutoML jobs created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * cannot be described by <code>DescribeAutoMLJob</code>.
     * </p>
     * </note>
     *
     * @param describeAutoMlJobRequest
     * @return A Java Future containing the result of the DescribeAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoMlJobResponse> describeAutoMLJob(DescribeAutoMlJobRequest describeAutoMlJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAutoMlJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutoMlJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutoMLJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAutoMlJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAutoMlJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAutoMlJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoMlJobRequest, DescribeAutoMlJobResponse>()
                            .withOperationName("DescribeAutoMLJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAutoMlJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAutoMlJobRequest));
            CompletableFuture<DescribeAutoMlJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     *
     * @param describeAutoMlJobV2Request
     * @return A Java Future containing the result of the DescribeAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoMlJobV2Response> describeAutoMLJobV2(
            DescribeAutoMlJobV2Request describeAutoMlJobV2Request) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAutoMlJobV2Request,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutoMlJobV2Request
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutoMLJobV2");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAutoMlJobV2Response> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAutoMlJobV2Response::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAutoMlJobV2Response> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoMlJobV2Request, DescribeAutoMlJobV2Response>()
                            .withOperationName("DescribeAutoMLJobV2").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAutoMlJobV2RequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAutoMlJobV2Request));
            CompletableFuture<DescribeAutoMlJobV2Response> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterRequest
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterRequest, DescribeClusterResponse>()
                            .withOperationName("DescribeCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterRequest));
            CompletableFuture<DescribeClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterNodeRequest
     * @return A Java Future containing the result of the DescribeClusterNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterNode" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterNodeResponse> describeClusterNode(
            DescribeClusterNodeRequest describeClusterNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterNodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClusterNodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClusterNodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClusterNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterNodeRequest, DescribeClusterNodeResponse>()
                            .withOperationName("DescribeClusterNode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterNodeRequest));
            CompletableFuture<DescribeClusterNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This
     * helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param describeClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the DescribeClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterSchedulerConfigResponse> describeClusterSchedulerConfig(
            DescribeClusterSchedulerConfigRequest describeClusterSchedulerConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterSchedulerConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClusterSchedulerConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterSchedulerConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClusterSchedulerConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClusterSchedulerConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClusterSchedulerConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterSchedulerConfigRequest, DescribeClusterSchedulerConfigResponse>()
                            .withOperationName("DescribeClusterSchedulerConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterSchedulerConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterSchedulerConfigRequest));
            CompletableFuture<DescribeClusterSchedulerConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return A Java Future containing the result of the DescribeCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCodeRepositoryResponse> describeCodeRepository(
            DescribeCodeRepositoryRequest describeCodeRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCodeRepositoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCodeRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCodeRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCodeRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCodeRepositoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCodeRepositoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCodeRepositoryRequest, DescribeCodeRepositoryResponse>()
                            .withOperationName("DescribeCodeRepository").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCodeRepositoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCodeRepositoryRequest));
            CompletableFuture<DescribeCodeRepositoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html"
     * >CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return A Java Future containing the result of the DescribeCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCompilationJobResponse> describeCompilationJob(
            DescribeCompilationJobRequest describeCompilationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCompilationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCompilationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCompilationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCompilationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCompilationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCompilationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCompilationJobRequest, DescribeCompilationJobResponse>()
                            .withOperationName("DescribeCompilationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCompilationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCompilationJobRequest));
            CompletableFuture<DescribeCompilationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     *
     * @param describeComputeQuotaRequest
     * @return A Java Future containing the result of the DescribeComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeComputeQuota"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComputeQuotaResponse> describeComputeQuota(
            DescribeComputeQuotaRequest describeComputeQuotaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeComputeQuotaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeComputeQuotaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComputeQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComputeQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComputeQuotaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeComputeQuotaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComputeQuotaRequest, DescribeComputeQuotaResponse>()
                            .withOperationName("DescribeComputeQuota").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeComputeQuotaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeComputeQuotaRequest));
            CompletableFuture<DescribeComputeQuotaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     *
     * @param describeContextRequest
     * @return A Java Future containing the result of the DescribeContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeContextResponse> describeContext(DescribeContextRequest describeContextRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeContextRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeContextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeContext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeContextResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeContextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeContextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeContextRequest, DescribeContextResponse>()
                            .withOperationName("DescribeContext").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeContextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeContextRequest));
            CompletableFuture<DescribeContextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataQualityJobDefinitionResponse> describeDataQualityJobDefinition(
            DescribeDataQualityJobDefinitionRequest describeDataQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataQualityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDataQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataQualityJobDefinitionRequest, DescribeDataQualityJobDefinitionResponse>()
                            .withOperationName("DescribeDataQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataQualityJobDefinitionRequest));
            CompletableFuture<DescribeDataQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeviceRequest, DescribeDeviceResponse>()
                            .withOperationName("DescribeDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDeviceRequest));
            CompletableFuture<DescribeDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     *
     * @param describeDeviceFleetRequest
     * @return A Java Future containing the result of the DescribeDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeviceFleetResponse> describeDeviceFleet(
            DescribeDeviceFleetRequest describeDeviceFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeviceFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeviceFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeviceFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeviceFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeviceFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeviceFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeviceFleetRequest, DescribeDeviceFleetResponse>()
                            .withOperationName("DescribeDeviceFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDeviceFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDeviceFleetRequest));
            CompletableFuture<DescribeDeviceFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainRequest, DescribeDomainResponse>()
                            .withOperationName("DescribeDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDomainRequest));
            CompletableFuture<DescribeDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DescribeEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEdgeDeploymentPlanResponse> describeEdgeDeploymentPlan(
            DescribeEdgeDeploymentPlanRequest describeEdgeDeploymentPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEdgeDeploymentPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgeDeploymentPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgeDeploymentPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEdgeDeploymentPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEdgeDeploymentPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEdgeDeploymentPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgeDeploymentPlanRequest, DescribeEdgeDeploymentPlanResponse>()
                            .withOperationName("DescribeEdgeDeploymentPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEdgeDeploymentPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEdgeDeploymentPlanRequest));
            CompletableFuture<DescribeEdgeDeploymentPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     * @return A Java Future containing the result of the DescribeEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEdgePackagingJobResponse> describeEdgePackagingJob(
            DescribeEdgePackagingJobRequest describeEdgePackagingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEdgePackagingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEdgePackagingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEdgePackagingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEdgePackagingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEdgePackagingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEdgePackagingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEdgePackagingJobRequest, DescribeEdgePackagingJobResponse>()
                            .withOperationName("DescribeEdgePackagingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEdgePackagingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEdgePackagingJobRequest));
            CompletableFuture<DescribeEdgePackagingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                            .withOperationName("DescribeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointRequest));
            CompletableFuture<DescribeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return A Java Future containing the result of the DescribeEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointConfigResponse> describeEndpointConfig(
            DescribeEndpointConfigRequest describeEndpointConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointConfigRequest, DescribeEndpointConfigResponse>()
                            .withOperationName("DescribeEndpointConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointConfigRequest));
            CompletableFuture<DescribeEndpointConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     *
     * @param describeExperimentRequest
     * @return A Java Future containing the result of the DescribeExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExperimentResponse> describeExperiment(DescribeExperimentRequest describeExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExperimentRequest, DescribeExperimentResponse>()
                            .withOperationName("DescribeExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeExperimentRequest));
            CompletableFuture<DescribeExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     *
     * @param describeFeatureGroupRequest
     * @return A Java Future containing the result of the DescribeFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeatureGroupResponse> describeFeatureGroup(
            DescribeFeatureGroupRequest describeFeatureGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFeatureGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeatureGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeatureGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeatureGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureGroupRequest, DescribeFeatureGroupResponse>()
                            .withOperationName("DescribeFeatureGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFeatureGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFeatureGroupRequest));
            CompletableFuture<DescribeFeatureGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     *
     * @param describeFeatureMetadataRequest
     * @return A Java Future containing the result of the DescribeFeatureMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeatureMetadataResponse> describeFeatureMetadata(
            DescribeFeatureMetadataRequest describeFeatureMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFeatureMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFeatureMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeatureMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeatureMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeatureMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureMetadataRequest, DescribeFeatureMetadataResponse>()
                            .withOperationName("DescribeFeatureMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFeatureMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFeatureMetadataRequest));
            CompletableFuture<DescribeFeatureMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     *
     * @param describeFlowDefinitionRequest
     * @return A Java Future containing the result of the DescribeFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowDefinitionResponse> describeFlowDefinition(
            DescribeFlowDefinitionRequest describeFlowDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlowDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlowDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFlowDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowDefinitionRequest, DescribeFlowDefinitionResponse>()
                            .withOperationName("DescribeFlowDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlowDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlowDefinitionRequest));
            CompletableFuture<DescribeFlowDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a hub.
     * </p>
     *
     * @param describeHubRequest
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHubResponse> describeHub(DescribeHubRequest describeHubRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHubRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHubRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHub");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHubResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeHubResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHubResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHubRequest, DescribeHubResponse>()
                            .withOperationName("DescribeHub").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHubRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHubRequest));
            CompletableFuture<DescribeHubResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe the content of a hub.
     * </p>
     *
     * @param describeHubContentRequest
     * @return A Java Future containing the result of the DescribeHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHubContentResponse> describeHubContent(DescribeHubContentRequest describeHubContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHubContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHubContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHubContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHubContentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHubContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHubContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHubContentRequest, DescribeHubContentResponse>()
                            .withOperationName("DescribeHubContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHubContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHubContentRequest));
            CompletableFuture<DescribeHubContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     *
     * @param describeHumanTaskUiRequest
     * @return A Java Future containing the result of the DescribeHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHumanTaskUiResponse> describeHumanTaskUi(
            DescribeHumanTaskUiRequest describeHumanTaskUiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHumanTaskUiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHumanTaskUiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHumanTaskUi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHumanTaskUiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHumanTaskUiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHumanTaskUiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHumanTaskUiRequest, DescribeHumanTaskUiResponse>()
                            .withOperationName("DescribeHumanTaskUi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHumanTaskUiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHumanTaskUiRequest));
            CompletableFuture<DescribeHumanTaskUiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include
     * the name, Amazon Resource Name (ARN), job status of your tuning job and more.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the DescribeHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHyperParameterTuningJobResponse> describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHyperParameterTuningJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeHyperParameterTuningJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHyperParameterTuningJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHyperParameterTuningJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHyperParameterTuningJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeHyperParameterTuningJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHyperParameterTuningJobRequest, DescribeHyperParameterTuningJobResponse>()
                            .withOperationName("DescribeHyperParameterTuningJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHyperParameterTuningJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHyperParameterTuningJobRequest));
            CompletableFuture<DescribeHyperParameterTuningJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a SageMaker AI image.
     * </p>
     *
     * @param describeImageRequest
     * @return A Java Future containing the result of the DescribeImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageResponse> describeImage(DescribeImageRequest describeImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImageRequest, DescribeImageResponse>()
                            .withOperationName("DescribeImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeImageRequest));
            CompletableFuture<DescribeImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a version of a SageMaker AI image.
     * </p>
     *
     * @param describeImageVersionRequest
     * @return A Java Future containing the result of the DescribeImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageVersionResponse> describeImageVersion(
            DescribeImageVersionRequest describeImageVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeImageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImageVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeImageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeImageVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeImageVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImageVersionRequest, DescribeImageVersionResponse>()
                            .withOperationName("DescribeImageVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeImageVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeImageVersionRequest));
            CompletableFuture<DescribeImageVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an inference component.
     * </p>
     *
     * @param describeInferenceComponentRequest
     * @return A Java Future containing the result of the DescribeInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInferenceComponentResponse> describeInferenceComponent(
            DescribeInferenceComponentRequest describeInferenceComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInferenceComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInferenceComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInferenceComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInferenceComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInferenceComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInferenceComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInferenceComponentRequest, DescribeInferenceComponentResponse>()
                            .withOperationName("DescribeInferenceComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInferenceComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInferenceComponentRequest));
            CompletableFuture<DescribeInferenceComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about an inference experiment.
     * </p>
     *
     * @param describeInferenceExperimentRequest
     * @return A Java Future containing the result of the DescribeInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInferenceExperimentResponse> describeInferenceExperiment(
            DescribeInferenceExperimentRequest describeInferenceExperimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInferenceExperimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInferenceExperimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInferenceExperiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInferenceExperimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInferenceExperimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInferenceExperimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInferenceExperimentRequest, DescribeInferenceExperimentResponse>()
                            .withOperationName("DescribeInferenceExperiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInferenceExperimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInferenceExperimentRequest));
            CompletableFuture<DescribeInferenceExperimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the DescribeInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInferenceRecommendationsJobResponse> describeInferenceRecommendationsJob(
            DescribeInferenceRecommendationsJobRequest describeInferenceRecommendationsJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInferenceRecommendationsJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInferenceRecommendationsJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInferenceRecommendationsJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInferenceRecommendationsJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInferenceRecommendationsJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInferenceRecommendationsJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInferenceRecommendationsJobRequest, DescribeInferenceRecommendationsJobResponse>()
                            .withOperationName("DescribeInferenceRecommendationsJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInferenceRecommendationsJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInferenceRecommendationsJobRequest));
            CompletableFuture<DescribeInferenceRecommendationsJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return A Java Future containing the result of the DescribeLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLabelingJobResponse> describeLabelingJob(
            DescribeLabelingJobRequest describeLabelingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLabelingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLabelingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLabelingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLabelingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLabelingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeLabelingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLabelingJobRequest, DescribeLabelingJobResponse>()
                            .withOperationName("DescribeLabelingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLabelingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLabelingJobRequest));
            CompletableFuture<DescribeLabelingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param describeLineageGroupRequest
     * @return A Java Future containing the result of the DescribeLineageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLineageGroupResponse> describeLineageGroup(
            DescribeLineageGroupRequest describeLineageGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLineageGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLineageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLineageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLineageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLineageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeLineageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLineageGroupRequest, DescribeLineageGroupResponse>()
                            .withOperationName("DescribeLineageGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLineageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLineageGroupRequest));
            CompletableFuture<DescribeLineageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an MLflow Tracking Server.
     * </p>
     *
     * @param describeMlflowTrackingServerRequest
     * @return A Java Future containing the result of the DescribeMlflowTrackingServer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMlflowTrackingServerResponse> describeMlflowTrackingServer(
            DescribeMlflowTrackingServerRequest describeMlflowTrackingServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMlflowTrackingServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMlflowTrackingServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMlflowTrackingServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMlflowTrackingServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMlflowTrackingServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMlflowTrackingServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMlflowTrackingServerRequest, DescribeMlflowTrackingServerResponse>()
                            .withOperationName("DescribeMlflowTrackingServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMlflowTrackingServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMlflowTrackingServerRequest));
            CompletableFuture<DescribeMlflowTrackingServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelRequest, DescribeModelResponse>()
                            .withOperationName("DescribeModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelRequest));
            CompletableFuture<DescribeModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelBiasJobDefinitionResponse> describeModelBiasJobDefinition(
            DescribeModelBiasJobDefinitionRequest describeModelBiasJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelBiasJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelBiasJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelBiasJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelBiasJobDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelBiasJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelBiasJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelBiasJobDefinitionRequest, DescribeModelBiasJobDefinitionResponse>()
                            .withOperationName("DescribeModelBiasJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelBiasJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelBiasJobDefinitionRequest));
            CompletableFuture<DescribeModelBiasJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
     * </p>
     *
     * @param describeModelCardRequest
     * @return A Java Future containing the result of the DescribeModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelCardResponse> describeModelCard(DescribeModelCardRequest describeModelCardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelCardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelCardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelCard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelCardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelCardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelCardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelCardRequest, DescribeModelCardResponse>()
                            .withOperationName("DescribeModelCard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelCardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelCardRequest));
            CompletableFuture<DescribeModelCardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param describeModelCardExportJobRequest
     * @return A Java Future containing the result of the DescribeModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelCardExportJobResponse> describeModelCardExportJob(
            DescribeModelCardExportJobRequest describeModelCardExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelCardExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelCardExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelCardExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelCardExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelCardExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelCardExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelCardExportJobRequest, DescribeModelCardExportJobResponse>()
                            .withOperationName("DescribeModelCardExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelCardExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelCardExportJobRequest));
            CompletableFuture<DescribeModelCardExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> describeModelExplainabilityJobDefinition(
            DescribeModelExplainabilityJobDefinitionRequest describeModelExplainabilityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeModelExplainabilityJobDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelExplainabilityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelExplainabilityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelExplainabilityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeModelExplainabilityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelExplainabilityJobDefinitionRequest, DescribeModelExplainabilityJobDefinitionResponse>()
                            .withOperationName("DescribeModelExplainabilityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelExplainabilityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelExplainabilityJobDefinitionRequest));
            CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <important>
     * <p>
     * If you provided a KMS Key ID when you created your model package, you will see the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your
     * CloudTrail logs when you use this API.
     * </p>
     * </important>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return A Java Future containing the result of the DescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelPackageResponse> describeModelPackage(
            DescribeModelPackageRequest describeModelPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelPackageRequest, DescribeModelPackageResponse>()
                            .withOperationName("DescribeModelPackage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelPackageRequest));
            CompletableFuture<DescribeModelPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     *
     * @param describeModelPackageGroupRequest
     * @return A Java Future containing the result of the DescribeModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelPackageGroupResponse> describeModelPackageGroup(
            DescribeModelPackageGroupRequest describeModelPackageGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelPackageGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelPackageGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelPackageGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelPackageGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeModelPackageGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelPackageGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelPackageGroupRequest, DescribeModelPackageGroupResponse>()
                            .withOperationName("DescribeModelPackageGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelPackageGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelPackageGroupRequest));
            CompletableFuture<DescribeModelPackageGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeModelQualityJobDefinitionResponse> describeModelQualityJobDefinition(
            DescribeModelQualityJobDefinitionRequest describeModelQualityJobDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelQualityJobDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeModelQualityJobDefinitionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelQualityJobDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeModelQualityJobDefinitionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeModelQualityJobDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeModelQualityJobDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeModelQualityJobDefinitionRequest, DescribeModelQualityJobDefinitionResponse>()
                            .withOperationName("DescribeModelQualityJobDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeModelQualityJobDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeModelQualityJobDefinitionRequest));
            CompletableFuture<DescribeModelQualityJobDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     * @return A Java Future containing the result of the DescribeMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMonitoringScheduleResponse> describeMonitoringSchedule(
            DescribeMonitoringScheduleRequest describeMonitoringScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMonitoringScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMonitoringScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMonitoringSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMonitoringScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMonitoringScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMonitoringScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMonitoringScheduleRequest, DescribeMonitoringScheduleResponse>()
                            .withOperationName("DescribeMonitoringSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMonitoringScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMonitoringScheduleRequest));
            CompletableFuture<DescribeMonitoringScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return A Java Future containing the result of the DescribeNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNotebookInstanceResponse> describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNotebookInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNotebookInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNotebookInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNotebookInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNotebookInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>()
                            .withOperationName("DescribeNotebookInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeNotebookInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNotebookInstanceRequest));
            CompletableFuture<DescribeNotebookInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNotebookInstanceLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeNotebookInstanceLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNotebookInstanceLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNotebookInstanceLifecycleConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeNotebookInstanceLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNotebookInstanceLifecycleConfigRequest, DescribeNotebookInstanceLifecycleConfigResponse>()
                            .withOperationName("DescribeNotebookInstanceLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeNotebookInstanceLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNotebookInstanceLifecycleConfigRequest));
            CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the properties of the specified optimization job.
     * </p>
     *
     * @param describeOptimizationJobRequest
     * @return A Java Future containing the result of the DescribeOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOptimizationJobResponse> describeOptimizationJob(
            DescribeOptimizationJobRequest describeOptimizationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOptimizationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptimizationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptimizationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOptimizationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOptimizationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOptimizationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOptimizationJobRequest, DescribeOptimizationJobResponse>()
                            .withOperationName("DescribeOptimizationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOptimizationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOptimizationJobRequest));
            CompletableFuture<DescribeOptimizationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a SageMaker Partner AI App.
     * </p>
     *
     * @param describePartnerAppRequest
     * @return A Java Future containing the result of the DescribePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePartnerAppResponse> describePartnerApp(DescribePartnerAppRequest describePartnerAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePartnerAppRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePartnerAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePartnerApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePartnerAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePartnerAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePartnerAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePartnerAppRequest, DescribePartnerAppResponse>()
                            .withOperationName("DescribePartnerApp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePartnerAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePartnerAppRequest));
            CompletableFuture<DescribePartnerAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineResponse> describePipeline(DescribePipelineRequest describePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineRequest, DescribePipelineResponse>()
                            .withOperationName("DescribePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePipelineRequest));
            CompletableFuture<DescribePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineDefinitionForExecution operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineDefinitionForExecutionResponse> describePipelineDefinitionForExecution(
            DescribePipelineDefinitionForExecutionRequest describePipelineDefinitionForExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePipelineDefinitionForExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePipelineDefinitionForExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineDefinitionForExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineDefinitionForExecutionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribePipelineDefinitionForExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineDefinitionForExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineDefinitionForExecutionRequest, DescribePipelineDefinitionForExecutionResponse>()
                            .withOperationName("DescribePipelineDefinitionForExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePipelineDefinitionForExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePipelineDefinitionForExecutionRequest));
            CompletableFuture<DescribePipelineDefinitionForExecutionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     *
     * @param describePipelineExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePipelineExecutionResponse> describePipelineExecution(
            DescribePipelineExecutionRequest describePipelineExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePipelineExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePipelineExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePipelineExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePipelineExecutionRequest, DescribePipelineExecutionResponse>()
                            .withOperationName("DescribePipelineExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePipelineExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePipelineExecutionRequest));
            CompletableFuture<DescribePipelineExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     *
     * @param describeProcessingJobRequest
     * @return A Java Future containing the result of the DescribeProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProcessingJobResponse> describeProcessingJob(
            DescribeProcessingJobRequest describeProcessingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProcessingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProcessingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProcessingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProcessingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProcessingJobRequest, DescribeProcessingJobResponse>()
                            .withOperationName("DescribeProcessingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProcessingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProcessingJobRequest));
            CompletableFuture<DescribeProcessingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                            .withOperationName("DescribeProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProjectRequest));
            CompletableFuture<DescribeProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the space.
     * </p>
     *
     * @param describeSpaceRequest
     * @return A Java Future containing the result of the DescribeSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSpace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpaceResponse> describeSpace(DescribeSpaceRequest describeSpaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSpaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSpaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeSpaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSpaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpaceRequest, DescribeSpaceResponse>()
                            .withOperationName("DescribeSpace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSpaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSpaceRequest));
            CompletableFuture<DescribeSpaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeStudioLifecycleConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStudioLifecycleConfigResponse> describeStudioLifecycleConfig(
            DescribeStudioLifecycleConfigRequest describeStudioLifecycleConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStudioLifecycleConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeStudioLifecycleConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStudioLifecycleConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStudioLifecycleConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStudioLifecycleConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeStudioLifecycleConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStudioLifecycleConfigRequest, DescribeStudioLifecycleConfigResponse>()
                            .withOperationName("DescribeStudioLifecycleConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeStudioLifecycleConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeStudioLifecycleConfigRequest));
            CompletableFuture<DescribeStudioLifecycleConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return A Java Future containing the result of the DescribeSubscribedWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSubscribedWorkteamResponse> describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSubscribedWorkteamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSubscribedWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSubscribedWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSubscribedWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSubscribedWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSubscribedWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSubscribedWorkteamRequest, DescribeSubscribedWorkteamResponse>()
                            .withOperationName("DescribeSubscribedWorkteam").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSubscribedWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSubscribedWorkteamRequest));
            CompletableFuture<DescribeSubscribedWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return A Java Future containing the result of the DescribeTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrainingJobResponse> describeTrainingJob(
            DescribeTrainingJobRequest describeTrainingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrainingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrainingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrainingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrainingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrainingJobRequest, DescribeTrainingJobResponse>()
                            .withOperationName("DescribeTrainingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrainingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrainingJobRequest));
            CompletableFuture<DescribeTrainingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a specific training plan.
     * </p>
     *
     * @param describeTrainingPlanRequest
     * @return A Java Future containing the result of the DescribeTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrainingPlanResponse> describeTrainingPlan(
            DescribeTrainingPlanRequest describeTrainingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrainingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrainingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrainingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrainingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrainingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrainingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrainingPlanRequest, DescribeTrainingPlanResponse>()
                            .withOperationName("DescribeTrainingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrainingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrainingPlanRequest));
            CompletableFuture<DescribeTrainingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return A Java Future containing the result of the DescribeTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTransformJobResponse> describeTransformJob(
            DescribeTransformJobRequest describeTransformJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTransformJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTransformJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTransformJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTransformJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTransformJobRequest, DescribeTransformJobResponse>()
                            .withOperationName("DescribeTransformJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTransformJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTransformJobRequest));
            CompletableFuture<DescribeTransformJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     *
     * @param describeTrialRequest
     * @return A Java Future containing the result of the DescribeTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrialResponse> describeTrial(DescribeTrialRequest describeTrialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrialResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeTrialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrialRequest, DescribeTrialResponse>()
                            .withOperationName("DescribeTrial").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrialRequest));
            CompletableFuture<DescribeTrialResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     *
     * @param describeTrialComponentRequest
     * @return A Java Future containing the result of the DescribeTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrialComponentResponse> describeTrialComponent(
            DescribeTrialComponentRequest describeTrialComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrialComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrialComponentRequest, DescribeTrialComponentResponse>()
                            .withOperationName("DescribeTrialComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrialComponentRequest));
            CompletableFuture<DescribeTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     *
     * @param describeUserProfileRequest
     * @return A Java Future containing the result of the DescribeUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserProfileResponse> describeUserProfile(
            DescribeUserProfileRequest describeUserProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserProfileRequest, DescribeUserProfileResponse>()
                            .withOperationName("DescribeUserProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserProfileRequest));
            CompletableFuture<DescribeUserProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important>
     *
     * @param describeWorkforceRequest
     * @return A Java Future containing the result of the DescribeWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorkforceResponse> describeWorkforce(DescribeWorkforceRequest describeWorkforceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkforceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkforceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkforce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorkforceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorkforceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorkforceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkforceRequest, DescribeWorkforceResponse>()
                            .withOperationName("DescribeWorkforce").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorkforceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorkforceRequest));
            CompletableFuture<DescribeWorkforceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the creation date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return A Java Future containing the result of the DescribeWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorkteamResponse> describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkteamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkteamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkteam");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorkteamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorkteamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorkteamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkteamRequest, DescribeWorkteamResponse>()
                            .withOperationName("DescribeWorkteam").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorkteamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorkteamRequest));
            CompletableFuture<DescribeWorkteamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param disableSagemakerServicecatalogPortfolioRequest
     * @return A Java Future containing the result of the DisableSagemakerServicecatalogPortfolio operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DisableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> disableSagemakerServicecatalogPortfolio(
            DisableSagemakerServicecatalogPortfolioRequest disableSagemakerServicecatalogPortfolioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableSagemakerServicecatalogPortfolioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSagemakerServicecatalogPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisableSagemakerServicecatalogPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableSagemakerServicecatalogPortfolioRequest, DisableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("DisableSagemakerServicecatalogPortfolio").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableSagemakerServicecatalogPortfolioRequest));
            CompletableFuture<DisableSagemakerServicecatalogPortfolioResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with.
     * Before you can delete a component, you must disassociate the component from all trials it is associated with. To
     * associate a trial component with a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AssociateTrialComponent.html"
     * >AssociateTrialComponent</a> API.
     * </p>
     * <p>
     * To get a list of the trials a component is associated with, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API. Specify
     * <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response
     * under <code>Results.TrialComponent.Parents</code>.
     * </p>
     *
     * @param disassociateTrialComponentRequest
     * @return A Java Future containing the result of the DisassociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DisassociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateTrialComponentResponse> disassociateTrialComponent(
            DisassociateTrialComponentRequest disassociateTrialComponentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateTrialComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrialComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrialComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateTrialComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateTrialComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateTrialComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrialComponentRequest, DisassociateTrialComponentResponse>()
                            .withOperationName("DisassociateTrialComponent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateTrialComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateTrialComponentRequest));
            CompletableFuture<DisassociateTrialComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param enableSagemakerServicecatalogPortfolioRequest
     * @return A Java Future containing the result of the EnableSagemakerServicecatalogPortfolio operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.EnableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> enableSagemakerServicecatalogPortfolio(
            EnableSagemakerServicecatalogPortfolioRequest enableSagemakerServicecatalogPortfolioRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableSagemakerServicecatalogPortfolioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableSagemakerServicecatalogPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSagemakerServicecatalogPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableSagemakerServicecatalogPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, EnableSagemakerServicecatalogPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableSagemakerServicecatalogPortfolioRequest, EnableSagemakerServicecatalogPortfolioResponse>()
                            .withOperationName("EnableSagemakerServicecatalogPortfolio").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableSagemakerServicecatalogPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableSagemakerServicecatalogPortfolioRequest));
            CompletableFuture<EnableSagemakerServicecatalogPortfolioResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param getDeviceFleetReportRequest
     * @return A Java Future containing the result of the GetDeviceFleetReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetDeviceFleetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceFleetReportResponse> getDeviceFleetReport(
            GetDeviceFleetReportRequest getDeviceFleetReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeviceFleetReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceFleetReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceFleetReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceFleetReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceFleetReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceFleetReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceFleetReportRequest, GetDeviceFleetReportResponse>()
                            .withOperationName("GetDeviceFleetReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeviceFleetReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeviceFleetReportRequest));
            CompletableFuture<GetDeviceFleetReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The resource policy for the lineage group.
     * </p>
     *
     * @param getLineageGroupPolicyRequest
     * @return A Java Future containing the result of the GetLineageGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetLineageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetLineageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLineageGroupPolicyResponse> getLineageGroupPolicy(
            GetLineageGroupPolicyRequest getLineageGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLineageGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLineageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLineageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLineageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLineageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLineageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLineageGroupPolicyRequest, GetLineageGroupPolicyResponse>()
                            .withOperationName("GetLineageGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLineageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLineageGroupPolicyRequest));
            CompletableFuture<GetLineageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a resource policy that manages access for a model group. For information about resource policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     *
     * @param getModelPackageGroupPolicyRequest
     * @return A Java Future containing the result of the GetModelPackageGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetModelPackageGroupPolicyResponse> getModelPackageGroupPolicy(
            GetModelPackageGroupPolicyRequest getModelPackageGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelPackageGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelPackageGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelPackageGroupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelPackageGroupPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelPackageGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelPackageGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelPackageGroupPolicyRequest, GetModelPackageGroupPolicyResponse>()
                            .withOperationName("GetModelPackageGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelPackageGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getModelPackageGroupPolicyRequest));
            CompletableFuture<GetModelPackageGroupPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param getSagemakerServicecatalogPortfolioStatusRequest
     * @return A Java Future containing the result of the GetSagemakerServicecatalogPortfolioStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetSagemakerServicecatalogPortfolioStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> getSagemakerServicecatalogPortfolioStatus(
            GetSagemakerServicecatalogPortfolioStatusRequest getSagemakerServicecatalogPortfolioStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getSagemakerServicecatalogPortfolioStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSagemakerServicecatalogPortfolioStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSagemakerServicecatalogPortfolioStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSagemakerServicecatalogPortfolioStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSagemakerServicecatalogPortfolioStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSagemakerServicecatalogPortfolioStatusRequest, GetSagemakerServicecatalogPortfolioStatusResponse>()
                            .withOperationName("GetSagemakerServicecatalogPortfolioStatus")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSagemakerServicecatalogPortfolioStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSagemakerServicecatalogPortfolioStatusRequest));
            CompletableFuture<GetSagemakerServicecatalogPortfolioStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an Amazon SageMaker Inference Recommender autoscaling recommendation job. Returns recommendations for
     * autoscaling policies that you can apply to your SageMaker endpoint.
     * </p>
     *
     * @param getScalingConfigurationRecommendationRequest
     * @return A Java Future containing the result of the GetScalingConfigurationRecommendation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.GetScalingConfigurationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetScalingConfigurationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetScalingConfigurationRecommendationResponse> getScalingConfigurationRecommendation(
            GetScalingConfigurationRecommendationRequest getScalingConfigurationRecommendationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getScalingConfigurationRecommendationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getScalingConfigurationRecommendationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SageMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetScalingConfigurationRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetScalingConfigurationRecommendationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetScalingConfigurationRecommendationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetScalingConfigurationRecommendationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetScalingConfigurationRecommendationRequest, GetScalingConfigurationRecommendationResponse>()
                            .withOperationName("GetScalingConfigurationRecommendation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetScalingConfigurationRecommendationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getScalingConfigurationRecommendationRequest));
            CompletableFuture<GetScalingConfigurationRecommendationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
      