/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon SageMaker AI app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppDetails implements SdkPojo, Serializable, ToCopyableBuilder<AppDetails.Builder, AppDetails> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(AppDetails::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(AppDetails::userProfileName)).setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(AppDetails::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppType").getter(getter(AppDetails::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(AppDetails::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AppDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AppDetails::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<ResourceSpec> RESOURCE_SPEC_FIELD = SdkField.<ResourceSpec> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceSpec").getter(getter(AppDetails::resourceSpec)).setter(setter(Builder::resourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, SPACE_NAME_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            RESOURCE_SPEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String userProfileName;

    private final String spaceName;

    private final String appType;

    private final String appName;

    private final String status;

    private final Instant creationTime;

    private final ResourceSpec resourceSpec;

    private AppDetails(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.spaceName = builder.spaceName;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.resourceSpec = builder.resourceSpec;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String appName() {
        return appName;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public final AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the ResourceSpec property for this object.
     * 
     * @return The value of the ResourceSpec property for this object.
     */
    public final ResourceSpec resourceSpec() {
        return resourceSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDetails)) {
            return false;
        }
        AppDetails other = (AppDetails) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(spaceName(), other.spaceName()) && Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(appName(), other.appName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(resourceSpec(), other.resourceSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppDetails").add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("SpaceName", spaceName()).add("AppType", appTypeAsString()).add("AppName", appName())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("ResourceSpec", resourceSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ResourceSpec":
            return Optional.ofNullable(clazz.cast(resourceSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("UserProfileName", USER_PROFILE_NAME_FIELD);
        map.put("SpaceName", SPACE_NAME_FIELD);
        map.put("AppType", APP_TYPE_FIELD);
        map.put("AppName", APP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ResourceSpec", RESOURCE_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppDetails, T> g) {
        return obj -> g.apply((AppDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppDetails> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app.
         * </p>
         * 
         * @param appType
         *        The type of app.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the ResourceSpec property for this object.
         *
         * @param resourceSpec
         *        The new value for the ResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpec(ResourceSpec resourceSpec);

        /**
         * Sets the value of the ResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceSpec(ResourceSpec)}.
         * 
         * @param resourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpec(ResourceSpec)
         */
        default Builder resourceSpec(Consumer<ResourceSpec.Builder> resourceSpec) {
            return resourceSpec(ResourceSpec.builder().applyMutation(resourceSpec).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private String spaceName;

        private String appType;

        private String appName;

        private String status;

        private Instant creationTime;

        private ResourceSpec resourceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDetails model) {
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            spaceName(model.spaceName);
            appType(model.appType);
            appName(model.appName);
            status(model.status);
            creationTime(model.creationTime);
            resourceSpec(model.resourceSpec);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getAppName() {
            return appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ResourceSpec.Builder getResourceSpec() {
            return resourceSpec != null ? resourceSpec.toBuilder() : null;
        }

        public final void setResourceSpec(ResourceSpec.BuilderImpl resourceSpec) {
            this.resourceSpec = resourceSpec != null ? resourceSpec.build() : null;
        }

        @Override
        public final Builder resourceSpec(ResourceSpec resourceSpec) {
            this.resourceSpec = resourceSpec;
            return this;
        }

        @Override
        public AppDetails build() {
            return new AppDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
