/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ClusterNodeSummariesCopier {
    static List<ClusterNodeSummary> copy(Collection<? extends ClusterNodeSummary> clusterNodeSummariesParam) {
        List<ClusterNodeSummary> list;
        if (clusterNodeSummariesParam == null || clusterNodeSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterNodeSummary> modifiableList = new ArrayList<>(clusterNodeSummariesParam.size());
            clusterNodeSummariesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ClusterNodeSummary> copyFromBuilder(Collection<? extends ClusterNodeSummary.Builder> clusterNodeSummariesParam) {
        List<ClusterNodeSummary> list;
        if (clusterNodeSummariesParam == null || clusterNodeSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterNodeSummary> modifiableList = new ArrayList<>(clusterNodeSummariesParam.size());
            clusterNodeSummariesParam.forEach(entry -> {
                ClusterNodeSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ClusterNodeSummary.Builder> copyToBuilder(Collection<? extends ClusterNodeSummary> clusterNodeSummariesParam) {
        List<ClusterNodeSummary.Builder> list;
        if (clusterNodeSummariesParam == null || clusterNodeSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterNodeSummary.Builder> modifiableList = new ArrayList<>(clusterNodeSummariesParam.size());
            clusterNodeSummariesParam.forEach(entry -> {
                ClusterNodeSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
