/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target entity to allocate compute resources to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeQuotaTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeQuotaTarget.Builder, ComputeQuotaTarget> {
    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamName").getter(getter(ComputeQuotaTarget::teamName)).setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()).build();

    private static final SdkField<Integer> FAIR_SHARE_WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FairShareWeight").getter(getter(ComputeQuotaTarget::fairShareWeight))
            .setter(setter(Builder::fairShareWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FairShareWeight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_NAME_FIELD,
            FAIR_SHARE_WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String teamName;

    private final Integer fairShareWeight;

    private ComputeQuotaTarget(BuilderImpl builder) {
        this.teamName = builder.teamName;
        this.fairShareWeight = builder.fairShareWeight;
    }

    /**
     * <p>
     * Name of the team to allocate compute resources to.
     * </p>
     * 
     * @return Name of the team to allocate compute resources to.
     */
    public final String teamName() {
        return teamName;
    }

    /**
     * <p>
     * Assigned entity fair-share weight. Idle compute will be shared across entities based on these assigned weights.
     * This weight is only used when <code>FairShare</code> is enabled.
     * </p>
     * <p>
     * A weight of 0 is the lowest priority and 100 is the highest. Weight 0 is the default.
     * </p>
     * 
     * @return Assigned entity fair-share weight. Idle compute will be shared across entities based on these assigned
     *         weights. This weight is only used when <code>FairShare</code> is enabled.</p>
     *         <p>
     *         A weight of 0 is the lowest priority and 100 is the highest. Weight 0 is the default.
     */
    public final Integer fairShareWeight() {
        return fairShareWeight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        hashCode = 31 * hashCode + Objects.hashCode(fairShareWeight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeQuotaTarget)) {
            return false;
        }
        ComputeQuotaTarget other = (ComputeQuotaTarget) obj;
        return Objects.equals(teamName(), other.teamName()) && Objects.equals(fairShareWeight(), other.fairShareWeight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeQuotaTarget").add("TeamName", teamName()).add("FairShareWeight", fairShareWeight())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TeamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        case "FairShareWeight":
            return Optional.ofNullable(clazz.cast(fairShareWeight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TeamName", TEAM_NAME_FIELD);
        map.put("FairShareWeight", FAIR_SHARE_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeQuotaTarget, T> g) {
        return obj -> g.apply((ComputeQuotaTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeQuotaTarget> {
        /**
         * <p>
         * Name of the team to allocate compute resources to.
         * </p>
         * 
         * @param teamName
         *        Name of the team to allocate compute resources to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);

        /**
         * <p>
         * Assigned entity fair-share weight. Idle compute will be shared across entities based on these assigned
         * weights. This weight is only used when <code>FairShare</code> is enabled.
         * </p>
         * <p>
         * A weight of 0 is the lowest priority and 100 is the highest. Weight 0 is the default.
         * </p>
         * 
         * @param fairShareWeight
         *        Assigned entity fair-share weight. Idle compute will be shared across entities based on these assigned
         *        weights. This weight is only used when <code>FairShare</code> is enabled.</p>
         *        <p>
         *        A weight of 0 is the lowest priority and 100 is the highest. Weight 0 is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fairShareWeight(Integer fairShareWeight);
    }

    static final class BuilderImpl implements Builder {
        private String teamName;

        private Integer fairShareWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeQuotaTarget model) {
            teamName(model.teamName);
            fairShareWeight(model.fairShareWeight);
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public final Integer getFairShareWeight() {
            return fairShareWeight;
        }

        public final void setFairShareWeight(Integer fairShareWeight) {
            this.fairShareWeight = fairShareWeight;
        }

        @Override
        public final Builder fairShareWeight(Integer fairShareWeight) {
            this.fairShareWeight = fairShareWeight;
            return this;
        }

        @Override
        public ComputeQuotaTarget build() {
            return new ComputeQuotaTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
