/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInferenceComponentRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateInferenceComponentRequest.Builder, CreateInferenceComponentRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentName").getter(getter(CreateInferenceComponentRequest::inferenceComponentName))
            .setter(setter(Builder::inferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(CreateInferenceComponentRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(CreateInferenceComponentRequest::variantName))
            .setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<InferenceComponentSpecification> SPECIFICATION_FIELD = SdkField
            .<InferenceComponentSpecification> builder(MarshallingType.SDK_POJO).memberName("Specification")
            .getter(getter(CreateInferenceComponentRequest::specification)).setter(setter(Builder::specification))
            .constructor(InferenceComponentSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()).build();

    private static final SdkField<InferenceComponentRuntimeConfig> RUNTIME_CONFIG_FIELD = SdkField
            .<InferenceComponentRuntimeConfig> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfig")
            .getter(getter(CreateInferenceComponentRequest::runtimeConfig)).setter(setter(Builder::runtimeConfig))
            .constructor(InferenceComponentRuntimeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateInferenceComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_COMPONENT_NAME_FIELD, ENDPOINT_NAME_FIELD, VARIANT_NAME_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceComponentName;

    private final String endpointName;

    private final String variantName;

    private final InferenceComponentSpecification specification;

    private final InferenceComponentRuntimeConfig runtimeConfig;

    private final List<Tag> tags;

    private CreateInferenceComponentRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name to assign to the inference component.
     * </p>
     * 
     * @return A unique name to assign to the inference component.
     */
    public final String inferenceComponentName() {
        return inferenceComponentName;
    }

    /**
     * <p>
     * The name of an existing endpoint where you host the inference component.
     * </p>
     * 
     * @return The name of an existing endpoint where you host the inference component.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of an existing production variant where you host the inference component.
     * </p>
     * 
     * @return The name of an existing production variant where you host the inference component.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * Details about the resources to deploy with this inference component, including the model, container, and compute
     * resources.
     * </p>
     * 
     * @return Details about the resources to deploy with this inference component, including the model, container, and
     *         compute resources.
     */
    public final InferenceComponentSpecification specification() {
        return specification;
    }

    /**
     * <p>
     * Runtime settings for a model that is deployed with an inference component.
     * </p>
     * 
     * @return Runtime settings for a model that is deployed with an inference component.
     */
    public final InferenceComponentRuntimeConfig runtimeConfig() {
        return runtimeConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs associated with the model. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs associated with the model. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceComponentRequest)) {
            return false;
        }
        CreateInferenceComponentRequest other = (CreateInferenceComponentRequest) obj;
        return Objects.equals(inferenceComponentName(), other.inferenceComponentName())
                && Objects.equals(endpointName(), other.endpointName()) && Objects.equals(variantName(), other.variantName())
                && Objects.equals(specification(), other.specification())
                && Objects.equals(runtimeConfig(), other.runtimeConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInferenceComponentRequest").add("InferenceComponentName", inferenceComponentName())
                .add("EndpointName", endpointName()).add("VariantName", variantName()).add("Specification", specification())
                .add("RuntimeConfig", runtimeConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceComponentName":
            return Optional.ofNullable(clazz.cast(inferenceComponentName()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "Specification":
            return Optional.ofNullable(clazz.cast(specification()));
        case "RuntimeConfig":
            return Optional.ofNullable(clazz.cast(runtimeConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceComponentRequest, T> g) {
        return obj -> g.apply((CreateInferenceComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInferenceComponentRequest> {
        /**
         * <p>
         * A unique name to assign to the inference component.
         * </p>
         * 
         * @param inferenceComponentName
         *        A unique name to assign to the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentName(String inferenceComponentName);

        /**
         * <p>
         * The name of an existing endpoint where you host the inference component.
         * </p>
         * 
         * @param endpointName
         *        The name of an existing endpoint where you host the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of an existing production variant where you host the inference component.
         * </p>
         * 
         * @param variantName
         *        The name of an existing production variant where you host the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * Details about the resources to deploy with this inference component, including the model, container, and
         * compute resources.
         * </p>
         * 
         * @param specification
         *        Details about the resources to deploy with this inference component, including the model, container,
         *        and compute resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(InferenceComponentSpecification specification);

        /**
         * <p>
         * Details about the resources to deploy with this inference component, including the model, container, and
         * compute resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentSpecification.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #specification(InferenceComponentSpecification)}.
         * 
         * @param specification
         *        a consumer that will call methods on {@link InferenceComponentSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specification(InferenceComponentSpecification)
         */
        default Builder specification(Consumer<InferenceComponentSpecification.Builder> specification) {
            return specification(InferenceComponentSpecification.builder().applyMutation(specification).build());
        }

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * 
         * @param runtimeConfig
         *        Runtime settings for a model that is deployed with an inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig);

        /**
         * <p>
         * Runtime settings for a model that is deployed with an inference component.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentRuntimeConfig.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentRuntimeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentRuntimeConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #runtimeConfig(InferenceComponentRuntimeConfig)}.
         * 
         * @param runtimeConfig
         *        a consumer that will call methods on {@link InferenceComponentRuntimeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfig(InferenceComponentRuntimeConfig)
         */
        default Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> runtimeConfig) {
            return runtimeConfig(InferenceComponentRuntimeConfig.builder().applyMutation(runtimeConfig).build());
        }

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String inferenceComponentName;

        private String endpointName;

        private String variantName;

        private InferenceComponentSpecification specification;

        private InferenceComponentRuntimeConfig runtimeConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceComponentRequest model) {
            super(model);
            inferenceComponentName(model.inferenceComponentName);
            endpointName(model.endpointName);
            variantName(model.variantName);
            specification(model.specification);
            runtimeConfig(model.runtimeConfig);
            tags(model.tags);
        }

        public final String getInferenceComponentName() {
            return inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final InferenceComponentSpecification.Builder getSpecification() {
            return specification != null ? specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getRuntimeConfig() {
            return runtimeConfig != null ? runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceComponentRequest build() {
            return new CreateInferenceComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
