/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedMlflowTrackingServerUrlRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreatePresignedMlflowTrackingServerUrlRequest.Builder, CreatePresignedMlflowTrackingServerUrlRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(CreatePresignedMlflowTrackingServerUrlRequest::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final SdkField<Integer> EXPIRES_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiresInSeconds").getter(getter(CreatePresignedMlflowTrackingServerUrlRequest::expiresInSeconds))
            .setter(setter(Builder::expiresInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresInSeconds").build()).build();

    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionExpirationDurationInSeconds")
            .getter(getter(CreatePresignedMlflowTrackingServerUrlRequest::sessionExpirationDurationInSeconds))
            .setter(setter(Builder::sessionExpirationDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD,
            EXPIRES_IN_SECONDS_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerName;

    private final Integer expiresInSeconds;

    private final Integer sessionExpirationDurationInSeconds;

    private CreatePresignedMlflowTrackingServerUrlRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
        this.expiresInSeconds = builder.expiresInSeconds;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    /**
     * <p>
     * The name of the tracking server to connect to your MLflow UI.
     * </p>
     * 
     * @return The name of the tracking server to connect to your MLflow UI.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    /**
     * <p>
     * The duration in seconds that your presigned URL is valid. The presigned URL can be used only once.
     * </p>
     * 
     * @return The duration in seconds that your presigned URL is valid. The presigned URL can be used only once.
     */
    public final Integer expiresInSeconds() {
        return expiresInSeconds;
    }

    /**
     * <p>
     * The duration in seconds that your MLflow UI session is valid.
     * </p>
     * 
     * @return The duration in seconds that your MLflow UI session is valid.
     */
    public final Integer sessionExpirationDurationInSeconds() {
        return sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedMlflowTrackingServerUrlRequest)) {
            return false;
        }
        CreatePresignedMlflowTrackingServerUrlRequest other = (CreatePresignedMlflowTrackingServerUrlRequest) obj;
        return Objects.equals(trackingServerName(), other.trackingServerName())
                && Objects.equals(expiresInSeconds(), other.expiresInSeconds())
                && Objects.equals(sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedMlflowTrackingServerUrlRequest").add("TrackingServerName", trackingServerName())
                .add("ExpiresInSeconds", expiresInSeconds())
                .add("SessionExpirationDurationInSeconds", sessionExpirationDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        case "ExpiresInSeconds":
            return Optional.ofNullable(clazz.cast(expiresInSeconds()));
        case "SessionExpirationDurationInSeconds":
            return Optional.ofNullable(clazz.cast(sessionExpirationDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ExpiresInSeconds", EXPIRES_IN_SECONDS_FIELD);
        map.put("SessionExpirationDurationInSeconds", SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedMlflowTrackingServerUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedMlflowTrackingServerUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePresignedMlflowTrackingServerUrlRequest> {
        /**
         * <p>
         * The name of the tracking server to connect to your MLflow UI.
         * </p>
         * 
         * @param trackingServerName
         *        The name of the tracking server to connect to your MLflow UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        /**
         * <p>
         * The duration in seconds that your presigned URL is valid. The presigned URL can be used only once.
         * </p>
         * 
         * @param expiresInSeconds
         *        The duration in seconds that your presigned URL is valid. The presigned URL can be used only once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSeconds(Integer expiresInSeconds);

        /**
         * <p>
         * The duration in seconds that your MLflow UI session is valid.
         * </p>
         * 
         * @param sessionExpirationDurationInSeconds
         *        The duration in seconds that your MLflow UI session is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trackingServerName;

        private Integer expiresInSeconds;

        private Integer sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedMlflowTrackingServerUrlRequest model) {
            super(model);
            trackingServerName(model.trackingServerName);
            expiresInSeconds(model.expiresInSeconds);
            sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final Integer getExpiresInSeconds() {
            return expiresInSeconds;
        }

        public final void setExpiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
        }

        @Override
        public final Builder expiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return sessionExpirationDurationInSeconds;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedMlflowTrackingServerUrlRequest build() {
            return new CreatePresignedMlflowTrackingServerUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
