/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that SageMaker Neo automatically derived about the model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DerivedInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<DerivedInformation.Builder, DerivedInformation> {
    private static final SdkField<String> DERIVED_DATA_INPUT_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DerivedDataInputConfig").getter(getter(DerivedInformation::derivedDataInputConfig))
            .setter(setter(Builder::derivedDataInputConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivedDataInputConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DERIVED_DATA_INPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String derivedDataInputConfig;

    private DerivedInformation(BuilderImpl builder) {
        this.derivedDataInputConfig = builder.derivedDataInputConfig;
    }

    /**
     * <p>
     * The data input configuration that SageMaker Neo automatically derived for the model. When SageMaker Neo derives
     * this information, you don't need to specify the data input configuration when you create a compilation job.
     * </p>
     * 
     * @return The data input configuration that SageMaker Neo automatically derived for the model. When SageMaker Neo
     *         derives this information, you don't need to specify the data input configuration when you create a
     *         compilation job.
     */
    public final String derivedDataInputConfig() {
        return derivedDataInputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(derivedDataInputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DerivedInformation)) {
            return false;
        }
        DerivedInformation other = (DerivedInformation) obj;
        return Objects.equals(derivedDataInputConfig(), other.derivedDataInputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DerivedInformation").add("DerivedDataInputConfig", derivedDataInputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DerivedDataInputConfig":
            return Optional.ofNullable(clazz.cast(derivedDataInputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DerivedDataInputConfig", DERIVED_DATA_INPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DerivedInformation, T> g) {
        return obj -> g.apply((DerivedInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DerivedInformation> {
        /**
         * <p>
         * The data input configuration that SageMaker Neo automatically derived for the model. When SageMaker Neo
         * derives this information, you don't need to specify the data input configuration when you create a
         * compilation job.
         * </p>
         * 
         * @param derivedDataInputConfig
         *        The data input configuration that SageMaker Neo automatically derived for the model. When SageMaker
         *        Neo derives this information, you don't need to specify the data input configuration when you create a
         *        compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder derivedDataInputConfig(String derivedDataInputConfig);
    }

    static final class BuilderImpl implements Builder {
        private String derivedDataInputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DerivedInformation model) {
            derivedDataInputConfig(model.derivedDataInputConfig);
        }

        public final String getDerivedDataInputConfig() {
            return derivedDataInputConfig;
        }

        public final void setDerivedDataInputConfig(String derivedDataInputConfig) {
            this.derivedDataInputConfig = derivedDataInputConfig;
        }

        @Override
        public final Builder derivedDataInputConfig(String derivedDataInputConfig) {
            this.derivedDataInputConfig = derivedDataInputConfig;
            return this;
        }

        @Override
        public DerivedInformation build() {
            return new DerivedInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
