/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEdgePackagingJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeEdgePackagingJobResponse.Builder, DescribeEdgePackagingJobResponse> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobArn").getter(getter(DescribeEdgePackagingJobResponse::edgePackagingJobArn))
            .setter(setter(Builder::edgePackagingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobArn").build())
            .build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobName").getter(getter(DescribeEdgePackagingJobResponse::edgePackagingJobName))
            .setter(setter(Builder::edgePackagingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(DescribeEdgePackagingJobResponse::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeEdgePackagingJobResponse::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(DescribeEdgePackagingJobResponse::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeEdgePackagingJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<EdgeOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(DescribeEdgePackagingJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(EdgeOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> RESOURCE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceKey").getter(getter(DescribeEdgePackagingJobResponse::resourceKey))
            .setter(setter(Builder::resourceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()).build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobStatus")
            .getter(getter(DescribeEdgePackagingJobResponse::edgePackagingJobStatusAsString))
            .setter(setter(Builder::edgePackagingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatus").build())
            .build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobStatusMessage")
            .getter(getter(DescribeEdgePackagingJobResponse::edgePackagingJobStatusMessage))
            .setter(setter(Builder::edgePackagingJobStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatusMessage")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeEdgePackagingJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeEdgePackagingJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> MODEL_ARTIFACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArtifact").getter(getter(DescribeEdgePackagingJobResponse::modelArtifact))
            .setter(setter(Builder::modelArtifact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifact").build()).build();

    private static final SdkField<String> MODEL_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelSignature").getter(getter(DescribeEdgePackagingJobResponse::modelSignature))
            .setter(setter(Builder::modelSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSignature").build()).build();

    private static final SdkField<EdgePresetDeploymentOutput> PRESET_DEPLOYMENT_OUTPUT_FIELD = SdkField
            .<EdgePresetDeploymentOutput> builder(MarshallingType.SDK_POJO).memberName("PresetDeploymentOutput")
            .getter(getter(DescribeEdgePackagingJobResponse::presetDeploymentOutput))
            .setter(setter(Builder::presetDeploymentOutput)).constructor(EdgePresetDeploymentOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetDeploymentOutput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_ARN_FIELD,
            EDGE_PACKAGING_JOB_NAME_FIELD, COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, ROLE_ARN_FIELD,
            OUTPUT_CONFIG_FIELD, RESOURCE_KEY_FIELD, EDGE_PACKAGING_JOB_STATUS_FIELD, EDGE_PACKAGING_JOB_STATUS_MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MODEL_ARTIFACT_FIELD, MODEL_SIGNATURE_FIELD,
            PRESET_DEPLOYMENT_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String edgePackagingJobArn;

    private final String edgePackagingJobName;

    private final String compilationJobName;

    private final String modelName;

    private final String modelVersion;

    private final String roleArn;

    private final EdgeOutputConfig outputConfig;

    private final String resourceKey;

    private final String edgePackagingJobStatus;

    private final String edgePackagingJobStatusMessage;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String modelArtifact;

    private final String modelSignature;

    private final EdgePresetDeploymentOutput presetDeploymentOutput;

    private DescribeEdgePackagingJobResponse(BuilderImpl builder) {
        super(builder);
        this.edgePackagingJobArn = builder.edgePackagingJobArn;
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.roleArn = builder.roleArn;
        this.outputConfig = builder.outputConfig;
        this.resourceKey = builder.resourceKey;
        this.edgePackagingJobStatus = builder.edgePackagingJobStatus;
        this.edgePackagingJobStatusMessage = builder.edgePackagingJobStatusMessage;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.modelArtifact = builder.modelArtifact;
        this.modelSignature = builder.modelSignature;
        this.presetDeploymentOutput = builder.presetDeploymentOutput;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the edge packaging job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the edge packaging job.
     */
    public final String edgePackagingJobArn() {
        return edgePackagingJobArn;
    }

    /**
     * <p>
     * The name of the edge packaging job.
     * </p>
     * 
     * @return The name of the edge packaging job.
     */
    public final String edgePackagingJobName() {
        return edgePackagingJobName;
    }

    /**
     * <p>
     * The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.
     * </p>
     * 
     * @return The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being
     *         packaged.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version of the model.
     * </p>
     * 
     * @return The version of the model.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and
     * to contact Neo.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the
     *         model, and to contact Neo.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The output configuration for the edge packaging job.
     * </p>
     * 
     * @return The output configuration for the edge packaging job.
     */
    public final EdgeOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.
     * </p>
     * 
     * @return The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.
     */
    public final String resourceKey() {
        return resourceKey;
    }

    /**
     * <p>
     * The current status of the packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #edgePackagingJobStatus} will return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #edgePackagingJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the packaging job.
     * @see EdgePackagingJobStatus
     */
    public final EdgePackagingJobStatus edgePackagingJobStatus() {
        return EdgePackagingJobStatus.fromValue(edgePackagingJobStatus);
    }

    /**
     * <p>
     * The current status of the packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #edgePackagingJobStatus} will return {@link EdgePackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #edgePackagingJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the packaging job.
     * @see EdgePackagingJobStatus
     */
    public final String edgePackagingJobStatusAsString() {
        return edgePackagingJobStatus;
    }

    /**
     * <p>
     * Returns a message describing the job status and error messages.
     * </p>
     * 
     * @return Returns a message describing the job status and error messages.
     */
    public final String edgePackagingJobStatusMessage() {
        return edgePackagingJobStatusMessage;
    }

    /**
     * <p>
     * The timestamp of when the packaging job was created.
     * </p>
     * 
     * @return The timestamp of when the packaging job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of when the job was last updated.
     * </p>
     * 
     * @return The timestamp of when the job was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Simple Storage (S3) URI where model artifacts ares stored.
     * </p>
     * 
     * @return The Amazon Simple Storage (S3) URI where model artifacts ares stored.
     */
    public final String modelArtifact() {
        return modelArtifact;
    }

    /**
     * <p>
     * The signature document of files in the model artifact.
     * </p>
     * 
     * @return The signature document of files in the model artifact.
     */
    public final String modelSignature() {
        return modelSignature;
    }

    /**
     * <p>
     * The output of a SageMaker Edge Manager deployable resource.
     * </p>
     * 
     * @return The output of a SageMaker Edge Manager deployable resource.
     */
    public final EdgePresetDeploymentOutput presetDeploymentOutput() {
        return presetDeploymentOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(modelSignature());
        hashCode = 31 * hashCode + Objects.hashCode(presetDeploymentOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEdgePackagingJobResponse)) {
            return false;
        }
        DescribeEdgePackagingJobResponse other = (DescribeEdgePackagingJobResponse) obj;
        return Objects.equals(edgePackagingJobArn(), other.edgePackagingJobArn())
                && Objects.equals(edgePackagingJobName(), other.edgePackagingJobName())
                && Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(resourceKey(), other.resourceKey())
                && Objects.equals(edgePackagingJobStatusAsString(), other.edgePackagingJobStatusAsString())
                && Objects.equals(edgePackagingJobStatusMessage(), other.edgePackagingJobStatusMessage())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(modelArtifact(), other.modelArtifact())
                && Objects.equals(modelSignature(), other.modelSignature())
                && Objects.equals(presetDeploymentOutput(), other.presetDeploymentOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEdgePackagingJobResponse").add("EdgePackagingJobArn", edgePackagingJobArn())
                .add("EdgePackagingJobName", edgePackagingJobName()).add("CompilationJobName", compilationJobName())
                .add("ModelName", modelName()).add("ModelVersion", modelVersion()).add("RoleArn", roleArn())
                .add("OutputConfig", outputConfig()).add("ResourceKey", resourceKey())
                .add("EdgePackagingJobStatus", edgePackagingJobStatusAsString())
                .add("EdgePackagingJobStatusMessage", edgePackagingJobStatusMessage()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("ModelArtifact", modelArtifact())
                .add("ModelSignature", modelSignature()).add("PresetDeploymentOutput", presetDeploymentOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgePackagingJobArn":
            return Optional.ofNullable(clazz.cast(edgePackagingJobArn()));
        case "EdgePackagingJobName":
            return Optional.ofNullable(clazz.cast(edgePackagingJobName()));
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "ResourceKey":
            return Optional.ofNullable(clazz.cast(resourceKey()));
        case "EdgePackagingJobStatus":
            return Optional.ofNullable(clazz.cast(edgePackagingJobStatusAsString()));
        case "EdgePackagingJobStatusMessage":
            return Optional.ofNullable(clazz.cast(edgePackagingJobStatusMessage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "ModelArtifact":
            return Optional.ofNullable(clazz.cast(modelArtifact()));
        case "ModelSignature":
            return Optional.ofNullable(clazz.cast(modelSignature()));
        case "PresetDeploymentOutput":
            return Optional.ofNullable(clazz.cast(presetDeploymentOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgePackagingJobArn", EDGE_PACKAGING_JOB_ARN_FIELD);
        map.put("EdgePackagingJobName", EDGE_PACKAGING_JOB_NAME_FIELD);
        map.put("CompilationJobName", COMPILATION_JOB_NAME_FIELD);
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("ResourceKey", RESOURCE_KEY_FIELD);
        map.put("EdgePackagingJobStatus", EDGE_PACKAGING_JOB_STATUS_FIELD);
        map.put("EdgePackagingJobStatusMessage", EDGE_PACKAGING_JOB_STATUS_MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("ModelArtifact", MODEL_ARTIFACT_FIELD);
        map.put("ModelSignature", MODEL_SIGNATURE_FIELD);
        map.put("PresetDeploymentOutput", PRESET_DEPLOYMENT_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEdgePackagingJobResponse, T> g) {
        return obj -> g.apply((DescribeEdgePackagingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEdgePackagingJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobArn
         *        The Amazon Resource Name (ARN) of the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobArn(String edgePackagingJobArn);

        /**
         * <p>
         * The name of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobName
         *        The name of the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobName(String edgePackagingJobName);

        /**
         * <p>
         * The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being
         *        packaged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version of the model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model,
         * and to contact Neo.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the
         *        model, and to contact Neo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The output configuration for the edge packaging job.
         * </p>
         * 
         * @param outputConfig
         *        The output configuration for the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(EdgeOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration for the edge packaging job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeOutputConfig.Builder} avoiding the
         * need to create one manually via {@link EdgeOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeOutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(EdgeOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link EdgeOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(EdgeOutputConfig)
         */
        default Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return outputConfig(EdgeOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.
         * </p>
         * 
         * @param resourceKey
         *        The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKey(String resourceKey);

        /**
         * <p>
         * The current status of the packaging job.
         * </p>
         * 
         * @param edgePackagingJobStatus
         *        The current status of the packaging job.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder edgePackagingJobStatus(String edgePackagingJobStatus);

        /**
         * <p>
         * The current status of the packaging job.
         * </p>
         * 
         * @param edgePackagingJobStatus
         *        The current status of the packaging job.
         * @see EdgePackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePackagingJobStatus
         */
        Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus);

        /**
         * <p>
         * Returns a message describing the job status and error messages.
         * </p>
         * 
         * @param edgePackagingJobStatusMessage
         *        Returns a message describing the job status and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobStatusMessage(String edgePackagingJobStatusMessage);

        /**
         * <p>
         * The timestamp of when the packaging job was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the packaging job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of when the job was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of when the job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Simple Storage (S3) URI where model artifacts ares stored.
         * </p>
         * 
         * @param modelArtifact
         *        The Amazon Simple Storage (S3) URI where model artifacts ares stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArtifact(String modelArtifact);

        /**
         * <p>
         * The signature document of files in the model artifact.
         * </p>
         * 
         * @param modelSignature
         *        The signature document of files in the model artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSignature(String modelSignature);

        /**
         * <p>
         * The output of a SageMaker Edge Manager deployable resource.
         * </p>
         * 
         * @param presetDeploymentOutput
         *        The output of a SageMaker Edge Manager deployable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presetDeploymentOutput(EdgePresetDeploymentOutput presetDeploymentOutput);

        /**
         * <p>
         * The output of a SageMaker Edge Manager deployable resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgePresetDeploymentOutput.Builder}
         * avoiding the need to create one manually via {@link EdgePresetDeploymentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgePresetDeploymentOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #presetDeploymentOutput(EdgePresetDeploymentOutput)}.
         * 
         * @param presetDeploymentOutput
         *        a consumer that will call methods on {@link EdgePresetDeploymentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presetDeploymentOutput(EdgePresetDeploymentOutput)
         */
        default Builder presetDeploymentOutput(Consumer<EdgePresetDeploymentOutput.Builder> presetDeploymentOutput) {
            return presetDeploymentOutput(EdgePresetDeploymentOutput.builder().applyMutation(presetDeploymentOutput).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String edgePackagingJobArn;

        private String edgePackagingJobName;

        private String compilationJobName;

        private String modelName;

        private String modelVersion;

        private String roleArn;

        private EdgeOutputConfig outputConfig;

        private String resourceKey;

        private String edgePackagingJobStatus;

        private String edgePackagingJobStatusMessage;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String modelArtifact;

        private String modelSignature;

        private EdgePresetDeploymentOutput presetDeploymentOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEdgePackagingJobResponse model) {
            super(model);
            edgePackagingJobArn(model.edgePackagingJobArn);
            edgePackagingJobName(model.edgePackagingJobName);
            compilationJobName(model.compilationJobName);
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            roleArn(model.roleArn);
            outputConfig(model.outputConfig);
            resourceKey(model.resourceKey);
            edgePackagingJobStatus(model.edgePackagingJobStatus);
            edgePackagingJobStatusMessage(model.edgePackagingJobStatusMessage);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            modelArtifact(model.modelArtifact);
            modelSignature(model.modelSignature);
            presetDeploymentOutput(model.presetDeploymentOutput);
        }

        public final String getEdgePackagingJobArn() {
            return edgePackagingJobArn;
        }

        public final void setEdgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
        }

        @Override
        public final Builder edgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
            return this;
        }

        public final String getEdgePackagingJobName() {
            return edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getResourceKey() {
            return resourceKey;
        }

        public final void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        @Override
        public final Builder resourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final String getEdgePackagingJobStatus() {
            return edgePackagingJobStatus;
        }

        public final void setEdgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
        }

        @Override
        public final Builder edgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
            return this;
        }

        @Override
        public final Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus) {
            this.edgePackagingJobStatus(edgePackagingJobStatus == null ? null : edgePackagingJobStatus.toString());
            return this;
        }

        public final String getEdgePackagingJobStatusMessage() {
            return edgePackagingJobStatusMessage;
        }

        public final void setEdgePackagingJobStatusMessage(String edgePackagingJobStatusMessage) {
            this.edgePackagingJobStatusMessage = edgePackagingJobStatusMessage;
        }

        @Override
        public final Builder edgePackagingJobStatusMessage(String edgePackagingJobStatusMessage) {
            this.edgePackagingJobStatusMessage = edgePackagingJobStatusMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getModelArtifact() {
            return modelArtifact;
        }

        public final void setModelArtifact(String modelArtifact) {
            this.modelArtifact = modelArtifact;
        }

        @Override
        public final Builder modelArtifact(String modelArtifact) {
            this.modelArtifact = modelArtifact;
            return this;
        }

        public final String getModelSignature() {
            return modelSignature;
        }

        public final void setModelSignature(String modelSignature) {
            this.modelSignature = modelSignature;
        }

        @Override
        public final Builder modelSignature(String modelSignature) {
            this.modelSignature = modelSignature;
            return this;
        }

        public final EdgePresetDeploymentOutput.Builder getPresetDeploymentOutput() {
            return presetDeploymentOutput != null ? presetDeploymentOutput.toBuilder() : null;
        }

        public final void setPresetDeploymentOutput(EdgePresetDeploymentOutput.BuilderImpl presetDeploymentOutput) {
            this.presetDeploymentOutput = presetDeploymentOutput != null ? presetDeploymentOutput.build() : null;
        }

        @Override
        public final Builder presetDeploymentOutput(EdgePresetDeploymentOutput presetDeploymentOutput) {
            this.presetDeploymentOutput = presetDeploymentOutput;
            return this;
        }

        @Override
        public DescribeEdgePackagingJobResponse build() {
            return new DescribeEdgePackagingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
