/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMlflowTrackingServerResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeMlflowTrackingServerResponse.Builder, DescribeMlflowTrackingServerResponse> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerArn").getter(getter(DescribeMlflowTrackingServerResponse::trackingServerArn))
            .setter(setter(Builder::trackingServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerArn").build()).build();

    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(DescribeMlflowTrackingServerResponse::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactStoreUri").getter(getter(DescribeMlflowTrackingServerResponse::artifactStoreUri))
            .setter(setter(Builder::artifactStoreUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()).build();

    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerSize").getter(getter(DescribeMlflowTrackingServerResponse::trackingServerSizeAsString))
            .setter(setter(Builder::trackingServerSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build())
            .build();

    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlflowVersion").getter(getter(DescribeMlflowTrackingServerResponse::mlflowVersion))
            .setter(setter(Builder::mlflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeMlflowTrackingServerResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> TRACKING_SERVER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerStatus")
            .getter(getter(DescribeMlflowTrackingServerResponse::trackingServerStatusAsString))
            .setter(setter(Builder::trackingServerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerStatus").build())
            .build();

    private static final SdkField<String> IS_ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsActive").getter(getter(DescribeMlflowTrackingServerResponse::isActiveAsString))
            .setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActive").build()).build();

    private static final SdkField<String> TRACKING_SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerUrl").getter(getter(DescribeMlflowTrackingServerResponse::trackingServerUrl))
            .setter(setter(Builder::trackingServerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerUrl").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(DescribeMlflowTrackingServerResponse::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticModelRegistration")
            .getter(getter(DescribeMlflowTrackingServerResponse::automaticModelRegistration))
            .setter(setter(Builder::automaticModelRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeMlflowTrackingServerResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeMlflowTrackingServerResponse::createdBy))
            .setter(setter(Builder::createdBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeMlflowTrackingServerResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeMlflowTrackingServerResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD,
            TRACKING_SERVER_NAME_FIELD, ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, MLFLOW_VERSION_FIELD,
            ROLE_ARN_FIELD, TRACKING_SERVER_STATUS_FIELD, IS_ACTIVE_FIELD, TRACKING_SERVER_URL_FIELD,
            WEEKLY_MAINTENANCE_WINDOW_START_FIELD, AUTOMATIC_MODEL_REGISTRATION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerArn;

    private final String trackingServerName;

    private final String artifactStoreUri;

    private final String trackingServerSize;

    private final String mlflowVersion;

    private final String roleArn;

    private final String trackingServerStatus;

    private final String isActive;

    private final String trackingServerUrl;

    private final String weeklyMaintenanceWindowStart;

    private final Boolean automaticModelRegistration;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private DescribeMlflowTrackingServerResponse(BuilderImpl builder) {
        super(builder);
        this.trackingServerArn = builder.trackingServerArn;
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.mlflowVersion = builder.mlflowVersion;
        this.roleArn = builder.roleArn;
        this.trackingServerStatus = builder.trackingServerStatus;
        this.isActive = builder.isActive;
        this.trackingServerUrl = builder.trackingServerUrl;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * The ARN of the described tracking server.
     * </p>
     * 
     * @return The ARN of the described tracking server.
     */
    public final String trackingServerArn() {
        return trackingServerArn;
    }

    /**
     * <p>
     * The name of the described tracking server.
     * </p>
     * 
     * @return The name of the described tracking server.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    /**
     * <p>
     * The S3 URI of the general purpose bucket used as the MLflow Tracking Server artifact store.
     * </p>
     * 
     * @return The S3 URI of the general purpose bucket used as the MLflow Tracking Server artifact store.
     */
    public final String artifactStoreUri() {
        return artifactStoreUri;
    }

    /**
     * <p>
     * The size of the described tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The size of the described tracking server.
     * @see TrackingServerSize
     */
    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(trackingServerSize);
    }

    /**
     * <p>
     * The size of the described tracking server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The size of the described tracking server.
     * @see TrackingServerSize
     */
    public final String trackingServerSizeAsString() {
        return trackingServerSize;
    }

    /**
     * <p>
     * The MLflow version used for the described tracking server.
     * </p>
     * 
     * @return The MLflow version used for the described tracking server.
     */
    public final String mlflowVersion() {
        return mlflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an IAM role in your account that the described MLflow Tracking Server uses to
     * access the artifact store in Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an IAM role in your account that the described MLflow Tracking Server
     *         uses to access the artifact store in Amazon S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The current creation status of the described MLflow Tracking Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return The current creation status of the described MLflow Tracking Server.
     * @see TrackingServerStatus
     */
    public final TrackingServerStatus trackingServerStatus() {
        return TrackingServerStatus.fromValue(trackingServerStatus);
    }

    /**
     * <p>
     * The current creation status of the described MLflow Tracking Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerStatus} will return {@link TrackingServerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trackingServerStatusAsString}.
     * </p>
     * 
     * @return The current creation status of the described MLflow Tracking Server.
     * @see TrackingServerStatus
     */
    public final String trackingServerStatusAsString() {
        return trackingServerStatus;
    }

    /**
     * <p>
     * Whether the described MLflow Tracking Server is currently active.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isActive} will
     * return {@link IsTrackingServerActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isActiveAsString}.
     * </p>
     * 
     * @return Whether the described MLflow Tracking Server is currently active.
     * @see IsTrackingServerActive
     */
    public final IsTrackingServerActive isActive() {
        return IsTrackingServerActive.fromValue(isActive);
    }

    /**
     * <p>
     * Whether the described MLflow Tracking Server is currently active.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isActive} will
     * return {@link IsTrackingServerActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isActiveAsString}.
     * </p>
     * 
     * @return Whether the described MLflow Tracking Server is currently active.
     * @see IsTrackingServerActive
     */
    public final String isActiveAsString() {
        return isActive;
    }

    /**
     * <p>
     * The URL to connect to the MLflow user interface for the described tracking server.
     * </p>
     * 
     * @return The URL to connect to the MLflow user interface for the described tracking server.
     */
    public final String trackingServerUrl() {
        return trackingServerUrl;
    }

    /**
     * <p>
     * The day and time of the week when weekly maintenance occurs on the described tracking server.
     * </p>
     * 
     * @return The day and time of the week when weekly maintenance occurs on the described tracking server.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    /**
     * <p>
     * Whether automatic registration of new MLflow models to the SageMaker Model Registry is enabled.
     * </p>
     * 
     * @return Whether automatic registration of new MLflow models to the SageMaker Model Registry is enabled.
     */
    public final Boolean automaticModelRegistration() {
        return automaticModelRegistration;
    }

    /**
     * <p>
     * The timestamp of when the described MLflow Tracking Server was created.
     * </p>
     * 
     * @return The timestamp of when the described MLflow Tracking Server was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The timestamp of when the described MLflow Tracking Server was last modified.
     * </p>
     * 
     * @return The timestamp of when the described MLflow Tracking Server was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isActiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMlflowTrackingServerResponse)) {
            return false;
        }
        DescribeMlflowTrackingServerResponse other = (DescribeMlflowTrackingServerResponse) obj;
        return Objects.equals(trackingServerArn(), other.trackingServerArn())
                && Objects.equals(trackingServerName(), other.trackingServerName())
                && Objects.equals(artifactStoreUri(), other.artifactStoreUri())
                && Objects.equals(trackingServerSizeAsString(), other.trackingServerSizeAsString())
                && Objects.equals(mlflowVersion(), other.mlflowVersion()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(trackingServerStatusAsString(), other.trackingServerStatusAsString())
                && Objects.equals(isActiveAsString(), other.isActiveAsString())
                && Objects.equals(trackingServerUrl(), other.trackingServerUrl())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart())
                && Objects.equals(automaticModelRegistration(), other.automaticModelRegistration())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMlflowTrackingServerResponse").add("TrackingServerArn", trackingServerArn())
                .add("TrackingServerName", trackingServerName()).add("ArtifactStoreUri", artifactStoreUri())
                .add("TrackingServerSize", trackingServerSizeAsString()).add("MlflowVersion", mlflowVersion())
                .add("RoleArn", roleArn()).add("TrackingServerStatus", trackingServerStatusAsString())
                .add("IsActive", isActiveAsString()).add("TrackingServerUrl", trackingServerUrl())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart())
                .add("AutomaticModelRegistration", automaticModelRegistration()).add("CreationTime", creationTime())
                .add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerArn":
            return Optional.ofNullable(clazz.cast(trackingServerArn()));
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        case "ArtifactStoreUri":
            return Optional.ofNullable(clazz.cast(artifactStoreUri()));
        case "TrackingServerSize":
            return Optional.ofNullable(clazz.cast(trackingServerSizeAsString()));
        case "MlflowVersion":
            return Optional.ofNullable(clazz.cast(mlflowVersion()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "TrackingServerStatus":
            return Optional.ofNullable(clazz.cast(trackingServerStatusAsString()));
        case "IsActive":
            return Optional.ofNullable(clazz.cast(isActiveAsString()));
        case "TrackingServerUrl":
            return Optional.ofNullable(clazz.cast(trackingServerUrl()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        case "AutomaticModelRegistration":
            return Optional.ofNullable(clazz.cast(automaticModelRegistration()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerArn", TRACKING_SERVER_ARN_FIELD);
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("TrackingServerSize", TRACKING_SERVER_SIZE_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("TrackingServerStatus", TRACKING_SERVER_STATUS_FIELD);
        map.put("IsActive", IS_ACTIVE_FIELD);
        map.put("TrackingServerUrl", TRACKING_SERVER_URL_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("AutomaticModelRegistration", AUTOMATIC_MODEL_REGISTRATION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMlflowTrackingServerResponse, T> g) {
        return obj -> g.apply((DescribeMlflowTrackingServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMlflowTrackingServerResponse> {
        /**
         * <p>
         * The ARN of the described tracking server.
         * </p>
         * 
         * @param trackingServerArn
         *        The ARN of the described tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerArn(String trackingServerArn);

        /**
         * <p>
         * The name of the described tracking server.
         * </p>
         * 
         * @param trackingServerName
         *        The name of the described tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        /**
         * <p>
         * The S3 URI of the general purpose bucket used as the MLflow Tracking Server artifact store.
         * </p>
         * 
         * @param artifactStoreUri
         *        The S3 URI of the general purpose bucket used as the MLflow Tracking Server artifact store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStoreUri(String artifactStoreUri);

        /**
         * <p>
         * The size of the described tracking server.
         * </p>
         * 
         * @param trackingServerSize
         *        The size of the described tracking server.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(String trackingServerSize);

        /**
         * <p>
         * The size of the described tracking server.
         * </p>
         * 
         * @param trackingServerSize
         *        The size of the described tracking server.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(TrackingServerSize trackingServerSize);

        /**
         * <p>
         * The MLflow version used for the described tracking server.
         * </p>
         * 
         * @param mlflowVersion
         *        The MLflow version used for the described tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlflowVersion(String mlflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an IAM role in your account that the described MLflow Tracking Server uses
         * to access the artifact store in Amazon S3.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) for an IAM role in your account that the described MLflow Tracking
         *        Server uses to access the artifact store in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The current creation status of the described MLflow Tracking Server.
         * </p>
         * 
         * @param trackingServerStatus
         *        The current creation status of the described MLflow Tracking Server.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(String trackingServerStatus);

        /**
         * <p>
         * The current creation status of the described MLflow Tracking Server.
         * </p>
         * 
         * @param trackingServerStatus
         *        The current creation status of the described MLflow Tracking Server.
         * @see TrackingServerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerStatus
         */
        Builder trackingServerStatus(TrackingServerStatus trackingServerStatus);

        /**
         * <p>
         * Whether the described MLflow Tracking Server is currently active.
         * </p>
         * 
         * @param isActive
         *        Whether the described MLflow Tracking Server is currently active.
         * @see IsTrackingServerActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsTrackingServerActive
         */
        Builder isActive(String isActive);

        /**
         * <p>
         * Whether the described MLflow Tracking Server is currently active.
         * </p>
         * 
         * @param isActive
         *        Whether the described MLflow Tracking Server is currently active.
         * @see IsTrackingServerActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsTrackingServerActive
         */
        Builder isActive(IsTrackingServerActive isActive);

        /**
         * <p>
         * The URL to connect to the MLflow user interface for the described tracking server.
         * </p>
         * 
         * @param trackingServerUrl
         *        The URL to connect to the MLflow user interface for the described tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerUrl(String trackingServerUrl);

        /**
         * <p>
         * The day and time of the week when weekly maintenance occurs on the described tracking server.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The day and time of the week when weekly maintenance occurs on the described tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        /**
         * <p>
         * Whether automatic registration of new MLflow models to the SageMaker Model Registry is enabled.
         * </p>
         * 
         * @param automaticModelRegistration
         *        Whether automatic registration of new MLflow models to the SageMaker Model Registry is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticModelRegistration(Boolean automaticModelRegistration);

        /**
         * <p>
         * The timestamp of when the described MLflow Tracking Server was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the described MLflow Tracking Server was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The timestamp of when the described MLflow Tracking Server was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of when the described MLflow Tracking Server was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trackingServerArn;

        private String trackingServerName;

        private String artifactStoreUri;

        private String trackingServerSize;

        private String mlflowVersion;

        private String roleArn;

        private String trackingServerStatus;

        private String isActive;

        private String trackingServerUrl;

        private String weeklyMaintenanceWindowStart;

        private Boolean automaticModelRegistration;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMlflowTrackingServerResponse model) {
            super(model);
            trackingServerArn(model.trackingServerArn);
            trackingServerName(model.trackingServerName);
            artifactStoreUri(model.artifactStoreUri);
            trackingServerSize(model.trackingServerSize);
            mlflowVersion(model.mlflowVersion);
            roleArn(model.roleArn);
            trackingServerStatus(model.trackingServerStatus);
            isActive(model.isActive);
            trackingServerUrl(model.trackingServerUrl);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            automaticModelRegistration(model.automaticModelRegistration);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getTrackingServerArn() {
            return trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTrackingServerStatus() {
            return trackingServerStatus;
        }

        public final void setTrackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
        }

        @Override
        public final Builder trackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
            return this;
        }

        @Override
        public final Builder trackingServerStatus(TrackingServerStatus trackingServerStatus) {
            this.trackingServerStatus(trackingServerStatus == null ? null : trackingServerStatus.toString());
            return this;
        }

        public final String getIsActive() {
            return isActive;
        }

        public final void setIsActive(String isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(String isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public final Builder isActive(IsTrackingServerActive isActive) {
            this.isActive(isActive == null ? null : isActive.toString());
            return this;
        }

        public final String getTrackingServerUrl() {
            return trackingServerUrl;
        }

        public final void setTrackingServerUrl(String trackingServerUrl) {
            this.trackingServerUrl = trackingServerUrl;
        }

        @Override
        public final Builder trackingServerUrl(String trackingServerUrl) {
            this.trackingServerUrl = trackingServerUrl;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeMlflowTrackingServerResponse build() {
            return new DescribeMlflowTrackingServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
