/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the holiday featurization attributes applicable to each item of time-series datasets during the training of a
 * forecasting model. This allows the model to identify patterns associated with specific holidays.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HolidayConfigAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<HolidayConfigAttributes.Builder, HolidayConfigAttributes> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(HolidayConfigAttributes::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String countryCode;

    private HolidayConfigAttributes(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
    }

    /**
     * <p>
     * The country code for the holiday calendar.
     * </p>
     * <p>
     * For the list of public holiday calendars supported by AutoML job V2, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes"
     * >Country Codes</a>. Use the country code corresponding to the country of your choice.
     * </p>
     * 
     * @return The country code for the holiday calendar.</p>
     *         <p>
     *         For the list of public holiday calendars supported by AutoML job V2, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes"
     *         >Country Codes</a>. Use the country code corresponding to the country of your choice.
     */
    public final String countryCode() {
        return countryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HolidayConfigAttributes)) {
            return false;
        }
        HolidayConfigAttributes other = (HolidayConfigAttributes) obj;
        return Objects.equals(countryCode(), other.countryCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HolidayConfigAttributes").add("CountryCode", countryCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HolidayConfigAttributes, T> g) {
        return obj -> g.apply((HolidayConfigAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HolidayConfigAttributes> {
        /**
         * <p>
         * The country code for the holiday calendar.
         * </p>
         * <p>
         * For the list of public holiday calendars supported by AutoML job V2, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes"
         * >Country Codes</a>. Use the country code corresponding to the country of your choice.
         * </p>
         * 
         * @param countryCode
         *        The country code for the holiday calendar.</p>
         *        <p>
         *        For the list of public holiday calendars supported by AutoML job V2, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes"
         *        >Country Codes</a>. Use the country code corresponding to the country of your choice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);
    }

    static final class BuilderImpl implements Builder {
        private String countryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(HolidayConfigAttributes model) {
            countryCode(model.countryCode);
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public HolidayConfigAttributes build() {
            return new HolidayConfigAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
