/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings related to idle shutdown of Studio applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdleSettings implements SdkPojo, Serializable, ToCopyableBuilder<IdleSettings.Builder, IdleSettings> {
    private static final SdkField<String> LIFECYCLE_MANAGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleManagement").getter(getter(IdleSettings::lifecycleManagementAsString))
            .setter(setter(Builder::lifecycleManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleManagement").build())
            .build();

    private static final SdkField<Integer> IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleTimeoutInMinutes").getter(getter(IdleSettings::idleTimeoutInMinutes))
            .setter(setter(Builder::idleTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeoutInMinutes").build())
            .build();

    private static final SdkField<Integer> MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MinIdleTimeoutInMinutes")
            .getter(getter(IdleSettings::minIdleTimeoutInMinutes)).setter(setter(Builder::minIdleTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIdleTimeoutInMinutes").build())
            .build();

    private static final SdkField<Integer> MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxIdleTimeoutInMinutes")
            .getter(getter(IdleSettings::maxIdleTimeoutInMinutes)).setter(setter(Builder::maxIdleTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIdleTimeoutInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_MANAGEMENT_FIELD,
            IDLE_TIMEOUT_IN_MINUTES_FIELD, MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD, MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lifecycleManagement;

    private final Integer idleTimeoutInMinutes;

    private final Integer minIdleTimeoutInMinutes;

    private final Integer maxIdleTimeoutInMinutes;

    private IdleSettings(BuilderImpl builder) {
        this.lifecycleManagement = builder.lifecycleManagement;
        this.idleTimeoutInMinutes = builder.idleTimeoutInMinutes;
        this.minIdleTimeoutInMinutes = builder.minIdleTimeoutInMinutes;
        this.maxIdleTimeoutInMinutes = builder.maxIdleTimeoutInMinutes;
    }

    /**
     * <p>
     * Indicates whether idle shutdown is activated for the application type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lifecycleManagement} will return {@link LifecycleManagement#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lifecycleManagementAsString}.
     * </p>
     * 
     * @return Indicates whether idle shutdown is activated for the application type.
     * @see LifecycleManagement
     */
    public final LifecycleManagement lifecycleManagement() {
        return LifecycleManagement.fromValue(lifecycleManagement);
    }

    /**
     * <p>
     * Indicates whether idle shutdown is activated for the application type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lifecycleManagement} will return {@link LifecycleManagement#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lifecycleManagementAsString}.
     * </p>
     * 
     * @return Indicates whether idle shutdown is activated for the application type.
     * @see LifecycleManagement
     */
    public final String lifecycleManagementAsString() {
        return lifecycleManagement;
    }

    /**
     * <p>
     * The time that SageMaker waits after the application becomes idle before shutting it down.
     * </p>
     * 
     * @return The time that SageMaker waits after the application becomes idle before shutting it down.
     */
    public final Integer idleTimeoutInMinutes() {
        return idleTimeoutInMinutes;
    }

    /**
     * <p>
     * The minimum value in minutes that custom idle shutdown can be set to by the user.
     * </p>
     * 
     * @return The minimum value in minutes that custom idle shutdown can be set to by the user.
     */
    public final Integer minIdleTimeoutInMinutes() {
        return minIdleTimeoutInMinutes;
    }

    /**
     * <p>
     * The maximum value in minutes that custom idle shutdown can be set to by the user.
     * </p>
     * 
     * @return The maximum value in minutes that custom idle shutdown can be set to by the user.
     */
    public final Integer maxIdleTimeoutInMinutes() {
        return maxIdleTimeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(minIdleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(maxIdleTimeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdleSettings)) {
            return false;
        }
        IdleSettings other = (IdleSettings) obj;
        return Objects.equals(lifecycleManagementAsString(), other.lifecycleManagementAsString())
                && Objects.equals(idleTimeoutInMinutes(), other.idleTimeoutInMinutes())
                && Objects.equals(minIdleTimeoutInMinutes(), other.minIdleTimeoutInMinutes())
                && Objects.equals(maxIdleTimeoutInMinutes(), other.maxIdleTimeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdleSettings").add("LifecycleManagement", lifecycleManagementAsString())
                .add("IdleTimeoutInMinutes", idleTimeoutInMinutes()).add("MinIdleTimeoutInMinutes", minIdleTimeoutInMinutes())
                .add("MaxIdleTimeoutInMinutes", maxIdleTimeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleManagement":
            return Optional.ofNullable(clazz.cast(lifecycleManagementAsString()));
        case "IdleTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(idleTimeoutInMinutes()));
        case "MinIdleTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(minIdleTimeoutInMinutes()));
        case "MaxIdleTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(maxIdleTimeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LifecycleManagement", LIFECYCLE_MANAGEMENT_FIELD);
        map.put("IdleTimeoutInMinutes", IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("MinIdleTimeoutInMinutes", MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("MaxIdleTimeoutInMinutes", MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdleSettings, T> g) {
        return obj -> g.apply((IdleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdleSettings> {
        /**
         * <p>
         * Indicates whether idle shutdown is activated for the application type.
         * </p>
         * 
         * @param lifecycleManagement
         *        Indicates whether idle shutdown is activated for the application type.
         * @see LifecycleManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleManagement
         */
        Builder lifecycleManagement(String lifecycleManagement);

        /**
         * <p>
         * Indicates whether idle shutdown is activated for the application type.
         * </p>
         * 
         * @param lifecycleManagement
         *        Indicates whether idle shutdown is activated for the application type.
         * @see LifecycleManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleManagement
         */
        Builder lifecycleManagement(LifecycleManagement lifecycleManagement);

        /**
         * <p>
         * The time that SageMaker waits after the application becomes idle before shutting it down.
         * </p>
         * 
         * @param idleTimeoutInMinutes
         *        The time that SageMaker waits after the application becomes idle before shutting it down.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeoutInMinutes(Integer idleTimeoutInMinutes);

        /**
         * <p>
         * The minimum value in minutes that custom idle shutdown can be set to by the user.
         * </p>
         * 
         * @param minIdleTimeoutInMinutes
         *        The minimum value in minutes that custom idle shutdown can be set to by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIdleTimeoutInMinutes(Integer minIdleTimeoutInMinutes);

        /**
         * <p>
         * The maximum value in minutes that custom idle shutdown can be set to by the user.
         * </p>
         * 
         * @param maxIdleTimeoutInMinutes
         *        The maximum value in minutes that custom idle shutdown can be set to by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxIdleTimeoutInMinutes(Integer maxIdleTimeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String lifecycleManagement;

        private Integer idleTimeoutInMinutes;

        private Integer minIdleTimeoutInMinutes;

        private Integer maxIdleTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(IdleSettings model) {
            lifecycleManagement(model.lifecycleManagement);
            idleTimeoutInMinutes(model.idleTimeoutInMinutes);
            minIdleTimeoutInMinutes(model.minIdleTimeoutInMinutes);
            maxIdleTimeoutInMinutes(model.maxIdleTimeoutInMinutes);
        }

        public final String getLifecycleManagement() {
            return lifecycleManagement;
        }

        public final void setLifecycleManagement(String lifecycleManagement) {
            this.lifecycleManagement = lifecycleManagement;
        }

        @Override
        public final Builder lifecycleManagement(String lifecycleManagement) {
            this.lifecycleManagement = lifecycleManagement;
            return this;
        }

        @Override
        public final Builder lifecycleManagement(LifecycleManagement lifecycleManagement) {
            this.lifecycleManagement(lifecycleManagement == null ? null : lifecycleManagement.toString());
            return this;
        }

        public final Integer getIdleTimeoutInMinutes() {
            return idleTimeoutInMinutes;
        }

        public final void setIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        }

        @Override
        public final Builder idleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
            return this;
        }

        public final Integer getMinIdleTimeoutInMinutes() {
            return minIdleTimeoutInMinutes;
        }

        public final void setMinIdleTimeoutInMinutes(Integer minIdleTimeoutInMinutes) {
            this.minIdleTimeoutInMinutes = minIdleTimeoutInMinutes;
        }

        @Override
        public final Builder minIdleTimeoutInMinutes(Integer minIdleTimeoutInMinutes) {
            this.minIdleTimeoutInMinutes = minIdleTimeoutInMinutes;
            return this;
        }

        public final Integer getMaxIdleTimeoutInMinutes() {
            return maxIdleTimeoutInMinutes;
        }

        public final void setMaxIdleTimeoutInMinutes(Integer maxIdleTimeoutInMinutes) {
            this.maxIdleTimeoutInMinutes = maxIdleTimeoutInMinutes;
        }

        @Override
        public final Builder maxIdleTimeoutInMinutes(Integer maxIdleTimeoutInMinutes) {
            this.maxIdleTimeoutInMinutes = maxIdleTimeoutInMinutes;
            return this;
        }

        @Override
        public IdleSettings build() {
            return new IdleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
