/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deployment configuration for an endpoint that hosts inference components. The configuration includes the desired
 * deployment strategy and rollback settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentDeploymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentDeploymentConfig.Builder, InferenceComponentDeploymentConfig> {
    private static final SdkField<InferenceComponentRollingUpdatePolicy> ROLLING_UPDATE_POLICY_FIELD = SdkField
            .<InferenceComponentRollingUpdatePolicy> builder(MarshallingType.SDK_POJO).memberName("RollingUpdatePolicy")
            .getter(getter(InferenceComponentDeploymentConfig::rollingUpdatePolicy)).setter(setter(Builder::rollingUpdatePolicy))
            .constructor(InferenceComponentRollingUpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingUpdatePolicy").build())
            .build();

    private static final SdkField<AutoRollbackConfig> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfig> builder(MarshallingType.SDK_POJO).memberName("AutoRollbackConfiguration")
            .getter(getter(InferenceComponentDeploymentConfig::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_UPDATE_POLICY_FIELD,
            AUTO_ROLLBACK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InferenceComponentRollingUpdatePolicy rollingUpdatePolicy;

    private final AutoRollbackConfig autoRollbackConfiguration;

    private InferenceComponentDeploymentConfig(BuilderImpl builder) {
        this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    /**
     * <p>
     * Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
     * </p>
     * 
     * @return Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
     */
    public final InferenceComponentRollingUpdatePolicy rollingUpdatePolicy() {
        return rollingUpdatePolicy;
    }

    /**
     * Returns the value of the AutoRollbackConfiguration property for this object.
     * 
     * @return The value of the AutoRollbackConfiguration property for this object.
     */
    public final AutoRollbackConfig autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollingUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentDeploymentConfig)) {
            return false;
        }
        InferenceComponentDeploymentConfig other = (InferenceComponentDeploymentConfig) obj;
        return Objects.equals(rollingUpdatePolicy(), other.rollingUpdatePolicy())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentDeploymentConfig").add("RollingUpdatePolicy", rollingUpdatePolicy())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollingUpdatePolicy":
            return Optional.ofNullable(clazz.cast(rollingUpdatePolicy()));
        case "AutoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RollingUpdatePolicy", ROLLING_UPDATE_POLICY_FIELD);
        map.put("AutoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentDeploymentConfig, T> g) {
        return obj -> g.apply((InferenceComponentDeploymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentDeploymentConfig> {
        /**
         * <p>
         * Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
         * </p>
         * 
         * @param rollingUpdatePolicy
         *        Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy rollingUpdatePolicy);

        /**
         * <p>
         * Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentRollingUpdatePolicy.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentRollingUpdatePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentRollingUpdatePolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy)}.
         * 
         * @param rollingUpdatePolicy
         *        a consumer that will call methods on {@link InferenceComponentRollingUpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy)
         */
        default Builder rollingUpdatePolicy(Consumer<InferenceComponentRollingUpdatePolicy.Builder> rollingUpdatePolicy) {
            return rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy.builder().applyMutation(rollingUpdatePolicy).build());
        }

        /**
         * Sets the value of the AutoRollbackConfiguration property for this object.
         *
         * @param autoRollbackConfiguration
         *        The new value for the AutoRollbackConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration);

        /**
         * Sets the value of the AutoRollbackConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfig.Builder} avoiding the
         * need to create one manually via {@link AutoRollbackConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoRollbackConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfig)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfig)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfig.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfig.builder().applyMutation(autoRollbackConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InferenceComponentRollingUpdatePolicy rollingUpdatePolicy;

        private AutoRollbackConfig autoRollbackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentDeploymentConfig model) {
            rollingUpdatePolicy(model.rollingUpdatePolicy);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final InferenceComponentRollingUpdatePolicy.Builder getRollingUpdatePolicy() {
            return rollingUpdatePolicy != null ? rollingUpdatePolicy.toBuilder() : null;
        }

        public final void setRollingUpdatePolicy(InferenceComponentRollingUpdatePolicy.BuilderImpl rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy != null ? rollingUpdatePolicy.build() : null;
        }

        @Override
        public final Builder rollingUpdatePolicy(InferenceComponentRollingUpdatePolicy rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy;
            return this;
        }

        public final AutoRollbackConfig.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfig.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        @Override
        public InferenceComponentDeploymentConfig build() {
            return new InferenceComponentDeploymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
