/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a rolling deployment strategy for updating a SageMaker AI inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentRollingUpdatePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentRollingUpdatePolicy.Builder, InferenceComponentRollingUpdatePolicy> {
    private static final SdkField<InferenceComponentCapacitySize> MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<InferenceComponentCapacitySize> builder(MarshallingType.SDK_POJO).memberName("MaximumBatchSize")
            .getter(getter(InferenceComponentRollingUpdatePolicy::maximumBatchSize)).setter(setter(Builder::maximumBatchSize))
            .constructor(InferenceComponentCapacitySize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()).build();

    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitIntervalInSeconds").getter(getter(InferenceComponentRollingUpdatePolicy::waitIntervalInSeconds))
            .setter(setter(Builder::waitIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumExecutionTimeoutInSeconds")
            .getter(getter(InferenceComponentRollingUpdatePolicy::maximumExecutionTimeoutInSeconds))
            .setter(setter(Builder::maximumExecutionTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<InferenceComponentCapacitySize> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<InferenceComponentCapacitySize> builder(MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize")
            .getter(getter(InferenceComponentRollingUpdatePolicy::rollbackMaximumBatchSize))
            .setter(setter(Builder::rollbackMaximumBatchSize)).constructor(InferenceComponentCapacitySize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD,
            WAIT_INTERVAL_IN_SECONDS_FIELD, MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD, ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InferenceComponentCapacitySize maximumBatchSize;

    private final Integer waitIntervalInSeconds;

    private final Integer maximumExecutionTimeoutInSeconds;

    private final InferenceComponentCapacitySize rollbackMaximumBatchSize;

    private InferenceComponentRollingUpdatePolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    /**
     * <p>
     * The batch size for each rolling step in the deployment process. For each step, SageMaker AI provisions capacity
     * on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint fleet. The
     * value must be between 5% to 50% of the copy count of the inference component.
     * </p>
     * 
     * @return The batch size for each rolling step in the deployment process. For each step, SageMaker AI provisions
     *         capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old
     *         endpoint fleet. The value must be between 5% to 50% of the copy count of the inference component.
     */
    public final InferenceComponentCapacitySize maximumBatchSize() {
        return maximumBatchSize;
    }

    /**
     * <p>
     * The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new fleet.
     * </p>
     * 
     * @return The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new
     *         fleet.
     */
    public final Integer waitIntervalInSeconds() {
        return waitIntervalInSeconds;
    }

    /**
     * <p>
     * The time limit for the total deployment. Exceeding this limit causes a timeout.
     * </p>
     * 
     * @return The time limit for the total deployment. Exceeding this limit causes a timeout.
     */
    public final Integer maximumExecutionTimeoutInSeconds() {
        return maximumExecutionTimeoutInSeconds;
    }

    /**
     * <p>
     * The batch size for a rollback to the old endpoint fleet. If this field is absent, the value is set to the
     * default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire
     * capacity of the old fleet at once during rollback.
     * </p>
     * 
     * @return The batch size for a rollback to the old endpoint fleet. If this field is absent, the value is set to the
     *         default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the
     *         entire capacity of the old fleet at once during rollback.
     */
    public final InferenceComponentCapacitySize rollbackMaximumBatchSize() {
        return rollbackMaximumBatchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackMaximumBatchSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentRollingUpdatePolicy)) {
            return false;
        }
        InferenceComponentRollingUpdatePolicy other = (InferenceComponentRollingUpdatePolicy) obj;
        return Objects.equals(maximumBatchSize(), other.maximumBatchSize())
                && Objects.equals(waitIntervalInSeconds(), other.waitIntervalInSeconds())
                && Objects.equals(maximumExecutionTimeoutInSeconds(), other.maximumExecutionTimeoutInSeconds())
                && Objects.equals(rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentRollingUpdatePolicy").add("MaximumBatchSize", maximumBatchSize())
                .add("WaitIntervalInSeconds", waitIntervalInSeconds())
                .add("MaximumExecutionTimeoutInSeconds", maximumExecutionTimeoutInSeconds())
                .add("RollbackMaximumBatchSize", rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumBatchSize":
            return Optional.ofNullable(clazz.cast(maximumBatchSize()));
        case "WaitIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(waitIntervalInSeconds()));
        case "MaximumExecutionTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(maximumExecutionTimeoutInSeconds()));
        case "RollbackMaximumBatchSize":
            return Optional.ofNullable(clazz.cast(rollbackMaximumBatchSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumBatchSize", MAXIMUM_BATCH_SIZE_FIELD);
        map.put("WaitIntervalInSeconds", WAIT_INTERVAL_IN_SECONDS_FIELD);
        map.put("MaximumExecutionTimeoutInSeconds", MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD);
        map.put("RollbackMaximumBatchSize", ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentRollingUpdatePolicy, T> g) {
        return obj -> g.apply((InferenceComponentRollingUpdatePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentRollingUpdatePolicy> {
        /**
         * <p>
         * The batch size for each rolling step in the deployment process. For each step, SageMaker AI provisions
         * capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint
         * fleet. The value must be between 5% to 50% of the copy count of the inference component.
         * </p>
         * 
         * @param maximumBatchSize
         *        The batch size for each rolling step in the deployment process. For each step, SageMaker AI provisions
         *        capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old
         *        endpoint fleet. The value must be between 5% to 50% of the copy count of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchSize(InferenceComponentCapacitySize maximumBatchSize);

        /**
         * <p>
         * The batch size for each rolling step in the deployment process. For each step, SageMaker AI provisions
         * capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint
         * fleet. The value must be between 5% to 50% of the copy count of the inference component.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentCapacitySize.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentCapacitySize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentCapacitySize.Builder#build()} is called
         * immediately and its result is passed to {@link #maximumBatchSize(InferenceComponentCapacitySize)}.
         * 
         * @param maximumBatchSize
         *        a consumer that will call methods on {@link InferenceComponentCapacitySize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumBatchSize(InferenceComponentCapacitySize)
         */
        default Builder maximumBatchSize(Consumer<InferenceComponentCapacitySize.Builder> maximumBatchSize) {
            return maximumBatchSize(InferenceComponentCapacitySize.builder().applyMutation(maximumBatchSize).build());
        }

        /**
         * <p>
         * The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new fleet.
         * </p>
         * 
         * @param waitIntervalInSeconds
         *        The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitIntervalInSeconds(Integer waitIntervalInSeconds);

        /**
         * <p>
         * The time limit for the total deployment. Exceeding this limit causes a timeout.
         * </p>
         * 
         * @param maximumExecutionTimeoutInSeconds
         *        The time limit for the total deployment. Exceeding this limit causes a timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds);

        /**
         * <p>
         * The batch size for a rollback to the old endpoint fleet. If this field is absent, the value is set to the
         * default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire
         * capacity of the old fleet at once during rollback.
         * </p>
         * 
         * @param rollbackMaximumBatchSize
         *        The batch size for a rollback to the old endpoint fleet. If this field is absent, the value is set to
         *        the default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions
         *        the entire capacity of the old fleet at once during rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackMaximumBatchSize(InferenceComponentCapacitySize rollbackMaximumBatchSize);

        /**
         * <p>
         * The batch size for a rollback to the old endpoint fleet. If this field is absent, the value is set to the
         * default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire
         * capacity of the old fleet at once during rollback.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceComponentCapacitySize.Builder}
         * avoiding the need to create one manually via {@link InferenceComponentCapacitySize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentCapacitySize.Builder#build()} is called
         * immediately and its result is passed to {@link #rollbackMaximumBatchSize(InferenceComponentCapacitySize)}.
         * 
         * @param rollbackMaximumBatchSize
         *        a consumer that will call methods on {@link InferenceComponentCapacitySize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackMaximumBatchSize(InferenceComponentCapacitySize)
         */
        default Builder rollbackMaximumBatchSize(Consumer<InferenceComponentCapacitySize.Builder> rollbackMaximumBatchSize) {
            return rollbackMaximumBatchSize(InferenceComponentCapacitySize.builder().applyMutation(rollbackMaximumBatchSize)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InferenceComponentCapacitySize maximumBatchSize;

        private Integer waitIntervalInSeconds;

        private Integer maximumExecutionTimeoutInSeconds;

        private InferenceComponentCapacitySize rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentRollingUpdatePolicy model) {
            maximumBatchSize(model.maximumBatchSize);
            waitIntervalInSeconds(model.waitIntervalInSeconds);
            maximumExecutionTimeoutInSeconds(model.maximumExecutionTimeoutInSeconds);
            rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final InferenceComponentCapacitySize.Builder getMaximumBatchSize() {
            return maximumBatchSize != null ? maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(InferenceComponentCapacitySize.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(InferenceComponentCapacitySize maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final Integer getMaximumExecutionTimeoutInSeconds() {
            return maximumExecutionTimeoutInSeconds;
        }

        public final void setMaximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
        }

        @Override
        public final Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
            return this;
        }

        public final InferenceComponentCapacitySize.Builder getRollbackMaximumBatchSize() {
            return rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(InferenceComponentCapacitySize.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(InferenceComponentCapacitySize rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        @Override
        public InferenceComponentRollingUpdatePolicy build() {
            return new InferenceComponentRollingUpdatePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
