/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure describing the current state of the model in its life cycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelLifeCycle implements SdkPojo, Serializable, ToCopyableBuilder<ModelLifeCycle.Builder, ModelLifeCycle> {
    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(ModelLifeCycle::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final SdkField<String> STAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageStatus").getter(getter(ModelLifeCycle::stageStatus)).setter(setter(Builder::stageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageStatus").build()).build();

    private static final SdkField<String> STAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageDescription").getter(getter(ModelLifeCycle::stageDescription))
            .setter(setter(Builder::stageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD,
            STAGE_STATUS_FIELD, STAGE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stage;

    private final String stageStatus;

    private final String stageDescription;

    private ModelLifeCycle(BuilderImpl builder) {
        this.stage = builder.stage;
        this.stageStatus = builder.stageStatus;
        this.stageDescription = builder.stageDescription;
    }

    /**
     * <p>
     * The current stage in the model life cycle.
     * </p>
     * 
     * @return The current stage in the model life cycle.
     */
    public final String stage() {
        return stage;
    }

    /**
     * <p>
     * The current status of a stage in model life cycle.
     * </p>
     * 
     * @return The current status of a stage in model life cycle.
     */
    public final String stageStatus() {
        return stageStatus;
    }

    /**
     * <p>
     * Describes the stage related details.
     * </p>
     * 
     * @return Describes the stage related details.
     */
    public final String stageDescription() {
        return stageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(stageStatus());
        hashCode = 31 * hashCode + Objects.hashCode(stageDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelLifeCycle)) {
            return false;
        }
        ModelLifeCycle other = (ModelLifeCycle) obj;
        return Objects.equals(stage(), other.stage()) && Objects.equals(stageStatus(), other.stageStatus())
                && Objects.equals(stageDescription(), other.stageDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelLifeCycle").add("Stage", stage()).add("StageStatus", stageStatus())
                .add("StageDescription", stageDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "StageStatus":
            return Optional.ofNullable(clazz.cast(stageStatus()));
        case "StageDescription":
            return Optional.ofNullable(clazz.cast(stageDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Stage", STAGE_FIELD);
        map.put("StageStatus", STAGE_STATUS_FIELD);
        map.put("StageDescription", STAGE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelLifeCycle, T> g) {
        return obj -> g.apply((ModelLifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelLifeCycle> {
        /**
         * <p>
         * The current stage in the model life cycle.
         * </p>
         * 
         * @param stage
         *        The current stage in the model life cycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        /**
         * <p>
         * The current status of a stage in model life cycle.
         * </p>
         * 
         * @param stageStatus
         *        The current status of a stage in model life cycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageStatus(String stageStatus);

        /**
         * <p>
         * Describes the stage related details.
         * </p>
         * 
         * @param stageDescription
         *        Describes the stage related details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDescription(String stageDescription);
    }

    static final class BuilderImpl implements Builder {
        private String stage;

        private String stageStatus;

        private String stageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelLifeCycle model) {
            stage(model.stage);
            stageStatus(model.stageStatus);
            stageDescription(model.stageDescription);
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getStageStatus() {
            return stageStatus;
        }

        public final void setStageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
        }

        @Override
        public final Builder stageStatus(String stageStatus) {
            this.stageStatus = stageStatus;
            return this;
        }

        public final String getStageDescription() {
            return stageDescription;
        }

        public final void setStageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
        }

        @Override
        public final Builder stageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        @Override
        public ModelLifeCycle build() {
            return new ModelLifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
